/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.mixin.client;

import com.mojang.datafixers.util.Pair;
import io.github.fabricators_of_create.porting_lib.extensions.BlockModelExtensions;
import io.github.fabricators_of_create.porting_lib.model.BlockModelConfiguration;
import io.github.fabricators_of_create.porting_lib.model.CompositeModelState;
import io.github.fabricators_of_create.porting_lib.model.IModelGeometry;
import io.github.fabricators_of_create.porting_lib.model.PerspectiveMapWrapper;
import io.github.fabricators_of_create.porting_lib.render.TransformTypeDependentItemBakedModel;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_785;
import net.minecraft.class_793;
import net.minecraft.class_799;
import net.minecraft.class_801;
import net.minecraft.class_806;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_793.class})
public abstract class BlockModelMixin
implements BlockModelExtensions {
    @Unique
    private final BlockModelConfiguration data = new BlockModelConfiguration((class_793)this);
    @Shadow
    public String field_4252;
    @Shadow
    @Final
    private List<class_799> field_4255;

    @Shadow
    public abstract class_793 method_3431();

    @Shadow
    public abstract class_4730 method_24077(String var1);

    @Override
    @Unique
    public BlockModelConfiguration getGeometry() {
        return this.data;
    }

    @Override
    @Unique
    public class_806 getOverrides(class_1088 pModelBakery, class_793 pModel, Function<class_4730, class_1058> textureGetter) {
        return this.field_4255.isEmpty() ? class_806.field_4292 : new class_806(pModelBakery, pModel, arg_0 -> ((class_1088)pModelBakery).method_4726(arg_0), this.field_4255);
    }

    @Inject(method={"getMaterials"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/block/model/BlockModel;getElements()Ljava/util/List;")}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    public void port_lib$getModelMaterials(Function<class_2960, class_1100> modelGetter, Set<Pair<String, String>> missingTextureErrors, CallbackInfoReturnable<Collection<class_4730>> cir, Set set, class_793 blockModel, Set<class_4730> materials) {
        if (this.data.hasCustomGeometry()) {
            materials.addAll(this.data.getTextureDependencies(modelGetter, missingTextureErrors));
            this.field_4255.forEach(p_111475_ -> {
                class_1100 unbakedmodel1 = (class_1100)modelGetter.apply(p_111475_.method_3472());
                if (!Objects.equals(unbakedmodel1, this)) {
                    materials.addAll(unbakedmodel1.method_4754(modelGetter, missingTextureErrors));
                }
            });
            if (this.method_3431() == class_1088.field_5400) {
                class_801.field_4270.forEach(p_111467_ -> materials.add(this.method_24077((String)p_111467_)));
            }
            cir.setReturnValue(materials);
        }
    }

    @Inject(method={"bake(Lnet/minecraft/client/resources/model/ModelBakery;Lnet/minecraft/client/renderer/block/model/BlockModel;Ljava/util/function/Function;Lnet/minecraft/client/resources/model/ModelState;Lnet/minecraft/resources/ResourceLocation;Z)Lnet/minecraft/client/resources/model/BakedModel;"}, at={@At(value="HEAD")}, cancellable=true)
    public void handleCustomModels(class_1088 modelBakery, class_793 otherModel, Function<class_4730, class_1058> spriteGetter, class_3665 modelTransform, class_2960 modelLocation, boolean guiLight3d, CallbackInfoReturnable<class_1087> cir) {
        class_793 blockModel = (class_793)this;
        IModelGeometry<?> customModel = this.data.getCustomGeometry();
        class_3665 customModelState = this.data.getCustomModelState();
        class_3665 newModelState = modelTransform;
        if (customModelState != null) {
            newModelState = new CompositeModelState(modelTransform, customModelState, modelTransform.method_3512());
        }
        if (customModel != null) {
            class_1087 model = customModel.bake(blockModel.getGeometry(), modelBakery, spriteGetter, newModelState, blockModel.getOverrides(modelBakery, otherModel, spriteGetter), modelLocation);
            if (customModelState != null && !(model instanceof TransformTypeDependentItemBakedModel)) {
                model = new PerspectiveMapWrapper(model, customModelState);
            }
            cir.setReturnValue((Object)model);
        }
    }

    @Inject(method={"getElements"}, at={@At(value="HEAD")}, cancellable=true)
    public void fixElements(CallbackInfoReturnable<List<class_785>> cir) {
        if (this.data.hasCustomGeometry()) {
            cir.setReturnValue(Collections.emptyList());
        }
    }
}

