/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.event.client;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_4184;
import net.minecraft.class_6854;
import net.minecraft.class_758;

@Environment(value=EnvType.CLIENT)
public class FogEvents {
    public static final Event<SetDensity> SET_DENSITY = EventFactory.createArrayBacked(SetDensity.class, callbacks -> (info, density) -> {
        int n = 0;
        SetDensity[] setDensityArray = callbacks;
        int n2 = setDensityArray.length;
        if (n < n2) {
            SetDensity callback = setDensityArray[n];
            return callback.setDensity(info, density);
        }
        return density;
    });
    public static final Event<SetColor> SET_COLOR = EventFactory.createArrayBacked(SetColor.class, callbacks -> (data, partialTicks) -> {
        for (SetColor callback : callbacks) {
            callback.setColor(data, partialTicks);
        }
    });
    public static final Event<RenderFog> RENDER_FOG = EventFactory.createArrayBacked(RenderFog.class, callbacks -> (type, info, partialTicks, distance) -> {
        for (RenderFog callback : callbacks) {
            callback.onFogRender(type, info, partialTicks, distance);
        }
    });
    public static final Event<ActualRenderFog> ACTUAL_RENDER_FOG = EventFactory.createArrayBacked(ActualRenderFog.class, callbacks -> (type, info, fogData) -> {
        for (ActualRenderFog callback : callbacks) {
            if (!callback.onFogRender(type, info, fogData)) continue;
            return true;
        }
        return false;
    });

    private FogEvents() {
    }

    @FunctionalInterface
    public static interface ActualRenderFog {
        public boolean onFogRender(class_758.class_4596 var1, class_4184 var2, FogData var3);
    }

    public static class FogData {
        private float farPlaneDistance;
        private float nearPlaneDistance;
        private class_6854 fogShape;

        public FogData(float nearPlaneDistance, float farPlaneDistance, class_6854 fogShape) {
            this.setFarPlaneDistance(farPlaneDistance);
            this.setNearPlaneDistance(nearPlaneDistance);
            this.setFogShape(fogShape);
        }

        public float getFarPlaneDistance() {
            return this.farPlaneDistance;
        }

        public float getNearPlaneDistance() {
            return this.nearPlaneDistance;
        }

        public class_6854 getFogShape() {
            return this.fogShape;
        }

        public void setFarPlaneDistance(float distance) {
            this.farPlaneDistance = distance;
        }

        public void setNearPlaneDistance(float distance) {
            this.nearPlaneDistance = distance;
        }

        public void setFogShape(class_6854 shape) {
            this.fogShape = shape;
        }

        public void scaleFarPlaneDistance(float factor) {
            this.farPlaneDistance *= factor;
        }

        public void scaleNearPlaneDistance(float factor) {
            this.nearPlaneDistance *= factor;
        }
    }

    @FunctionalInterface
    public static interface RenderFog {
        public void onFogRender(class_758.class_4596 var1, class_4184 var2, float var3, float var4);
    }

    @FunctionalInterface
    public static interface SetColor {
        public void setColor(ColorData var1, float var2);
    }

    public static class ColorData {
        private final class_4184 camera;
        private float red;
        private float green;
        private float blue;

        public ColorData(class_4184 camera, float r, float g, float b) {
            this.camera = camera;
            this.red = r;
            this.green = g;
            this.blue = b;
        }

        public class_4184 getCamera() {
            return this.camera;
        }

        public float getRed() {
            return this.red;
        }

        public float getGreen() {
            return this.green;
        }

        public float getBlue() {
            return this.blue;
        }

        public void setRed(float red) {
            this.red = red;
        }

        public void setGreen(float green) {
            this.green = green;
        }

        public void setBlue(float blue) {
            this.blue = blue;
        }
    }

    @FunctionalInterface
    public static interface SetDensity {
        public float setDensity(class_4184 var1, float var2);
    }
}

