/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.fabricators_of_create.porting_lib.crafting.CraftingHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1865;
import net.minecraft.class_2378;
import net.minecraft.class_2444;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class ConditionalRecipe {
    public static final class_1865<class_1860<?>> SERIALZIER = (class_1865)class_2378.method_10230((class_2378)class_2378.field_17598, (class_2960)new class_2960("forge:conditional"), new Serializer());

    public static Builder builder() {
        return new Builder();
    }

    public static void init() {
    }

    public static class Builder {
        private List<ConditionJsonProvider[]> conditions = new ArrayList<ConditionJsonProvider[]>();
        private List<class_2444> recipes = new ArrayList<class_2444>();
        private List<ConditionJsonProvider> currentConditions = new ArrayList<ConditionJsonProvider>();

        public Builder addCondition(ConditionJsonProvider condition) {
            this.currentConditions.add(condition);
            return this;
        }

        public Builder addRecipe(Consumer<Consumer<class_2444>> callable) {
            callable.accept(this::addRecipe);
            return this;
        }

        public Builder addRecipe(class_2444 recipe) {
            if (this.currentConditions.isEmpty()) {
                throw new IllegalStateException("Can not add a recipe with no conditions.");
            }
            this.conditions.add(this.currentConditions.toArray(new ConditionJsonProvider[this.currentConditions.size()]));
            this.recipes.add(recipe);
            this.currentConditions.clear();
            return this;
        }

        public void build(Consumer<class_2444> consumer, String namespace, String path) {
            this.build(consumer, new class_2960(namespace, path));
        }

        public void build(Consumer<class_2444> consumer, class_2960 id) {
            if (!this.currentConditions.isEmpty()) {
                throw new IllegalStateException("Invalid ConditionalRecipe builder, Orphaned conditions");
            }
            if (this.recipes.isEmpty()) {
                throw new IllegalStateException("Invalid ConditionalRecipe builder, No recipes");
            }
            consumer.accept(new Finished(id, this.conditions, this.recipes));
        }
    }

    public static class Serializer<T extends class_1860<?>>
    implements class_1865<T> {
        public T method_8121(class_2960 recipeId, JsonObject json) {
            JsonArray items = class_3518.method_15261((JsonObject)json, (String)"recipes");
            int idx = 0;
            for (JsonElement ele : items) {
                if (!ele.isJsonObject()) {
                    throw new JsonSyntaxException("Invalid recipes entry at index " + idx + " Must be JsonObject");
                }
                if (Serializer.processConditions(class_3518.method_15261((JsonObject)ele.getAsJsonObject(), (String)"fabric:load_conditions"))) {
                    return (T)class_1863.method_17720((class_2960)recipeId, (JsonObject)class_3518.method_15296((JsonObject)ele.getAsJsonObject(), (String)"recipe"));
                }
                ++idx;
            }
            return null;
        }

        public static boolean processConditions(JsonArray conditions) {
            for (int x = 0; x < conditions.size(); ++x) {
                if (!conditions.get(x).isJsonObject()) {
                    throw new JsonSyntaxException("Conditions must be an array of JsonObjects");
                }
                JsonObject json = conditions.get(x).getAsJsonObject();
                if (CraftingHelper.getConditionPredicate(json).test(json)) continue;
                return false;
            }
            return true;
        }

        public T method_8122(class_2960 recipeId, class_2540 buffer) {
            return null;
        }

        public void method_8124(class_2540 buffer, T recipe) {
        }
    }

    private static class Finished
    implements class_2444 {
        private final class_2960 id;
        private final List<ConditionJsonProvider[]> conditions;
        private final List<class_2444> recipes;

        private Finished(class_2960 id, List<ConditionJsonProvider[]> conditions, List<class_2444> recipes) {
            this.id = id;
            this.conditions = conditions;
            this.recipes = recipes;
        }

        public void method_10416(JsonObject json) {
            JsonArray array = new JsonArray();
            json.add("recipes", (JsonElement)array);
            for (int x = 0; x < this.conditions.size(); ++x) {
                JsonObject holder = new JsonObject();
                JsonArray conds = new JsonArray();
                for (ConditionJsonProvider c : this.conditions.get(x)) {
                    conds.add((JsonElement)c.toJson());
                }
                holder.add("fabric:load_conditions", (JsonElement)conds);
                holder.add("recipe", (JsonElement)this.recipes.get(x).method_17799());
                array.add((JsonElement)holder);
            }
        }

        public class_2960 method_10417() {
            return this.id;
        }

        public class_1865<?> method_17800() {
            return SERIALZIER;
        }

        public JsonObject method_10415() {
            return null;
        }

        public class_2960 method_10418() {
            return null;
        }
    }
}

