/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.impl;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import net.devtech.arrp.api.RuntimeResourcePack;
import net.devtech.arrp.json.animation.JAnimation;
import net.devtech.arrp.json.blockstate.JMultipart;
import net.devtech.arrp.json.blockstate.JState;
import net.devtech.arrp.json.blockstate.JVariant;
import net.devtech.arrp.json.blockstate.JWhen;
import net.devtech.arrp.json.lang.JLang;
import net.devtech.arrp.json.loot.JCondition;
import net.devtech.arrp.json.loot.JFunction;
import net.devtech.arrp.json.loot.JLootTable;
import net.devtech.arrp.json.loot.JPool;
import net.devtech.arrp.json.models.JModel;
import net.devtech.arrp.json.models.JTextures;
import net.devtech.arrp.json.recipe.JIngredient;
import net.devtech.arrp.json.recipe.JIngredients;
import net.devtech.arrp.json.recipe.JKeys;
import net.devtech.arrp.json.recipe.JPattern;
import net.devtech.arrp.json.recipe.JRecipe;
import net.devtech.arrp.json.tags.JTag;
import net.devtech.arrp.util.CallableFunction;
import net.devtech.arrp.util.CountingInputStream;
import net.devtech.arrp.util.UnsafeByteArrayOutputStream;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@Deprecated
@ApiStatus.Internal
public class RuntimeResourcePackImpl
implements RuntimeResourcePack,
class_3262 {
    public static final ExecutorService EXECUTOR_SERVICE;
    public static final boolean DUMP;
    public static final boolean DEBUG_PERFORMANCE;
    public static final Gson GSON;
    private static final Logger LOGGER;
    public final int packVersion;
    private final class_2960 id;
    private final Lock waiting = new ReentrantLock();
    private final Map<class_2960, Supplier<byte[]>> data = new ConcurrentHashMap<class_2960, Supplier<byte[]>>();
    private final Map<class_2960, Supplier<byte[]>> assets = new ConcurrentHashMap<class_2960, Supplier<byte[]>>();
    private final Map<String, Supplier<byte[]>> root = new ConcurrentHashMap<String, Supplier<byte[]>>();
    private final Map<class_2960, JLang> langMergable = new ConcurrentHashMap<class_2960, JLang>();

    public RuntimeResourcePackImpl(class_2960 id) {
        this(id, 5);
    }

    public RuntimeResourcePackImpl(class_2960 id, int version) {
        this.packVersion = version;
        this.id = id;
    }

    @Override
    public void addRecoloredImage(class_2960 identifier, InputStream target, IntUnaryOperator operator) {
        this.addLazyResource(class_3264.field_14188, RuntimeResourcePackImpl.fix(identifier, "textures", "png"), (i, r) -> {
            try {
                CountingInputStream is = new CountingInputStream(target);
                BufferedImage base = ImageIO.read(is);
                BufferedImage recolored = new BufferedImage(base.getWidth(), base.getHeight(), 2);
                for (int y = 0; y < base.getHeight(); ++y) {
                    for (int x = 0; x < base.getWidth(); ++x) {
                        recolored.setRGB(x, y, operator.applyAsInt(base.getRGB(x, y)));
                    }
                }
                UnsafeByteArrayOutputStream baos = new UnsafeByteArrayOutputStream(is.bytes());
                ImageIO.write((RenderedImage)recolored, "png", baos);
                return baos.getBytes();
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public byte[] addLang(class_2960 identifier, JLang lang) {
        return this.addAsset(RuntimeResourcePackImpl.fix(identifier, "lang", "json"), RuntimeResourcePackImpl.serialize(lang.getLang()));
    }

    @Override
    public void mergeLang(class_2960 identifier, JLang lang) {
        this.langMergable.compute(identifier, (identifier1, lang1) -> {
            if (lang1 == null) {
                lang1 = new JLang();
                this.addLazyResource(class_3264.field_14188, identifier, (pack, identifier2) -> pack.addLang(identifier, lang));
            }
            lang1.getLang().putAll(lang.getLang());
            return lang1;
        });
    }

    @Override
    public byte[] addLootTable(class_2960 identifier, JLootTable table) {
        return this.addData(RuntimeResourcePackImpl.fix(identifier, "loot_tables", "json"), RuntimeResourcePackImpl.serialize(table));
    }

    @Override
    public Future<byte[]> addAsyncResource(class_3264 type, class_2960 path, CallableFunction<class_2960, byte[]> data) {
        Future<byte[]> future = EXECUTOR_SERVICE.submit(() -> (byte[])data.get(path));
        this.getSys(type).put(path, () -> {
            try {
                return (byte[])future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        });
        return future;
    }

    @Override
    public void addLazyResource(class_3264 type, class_2960 path, BiFunction<RuntimeResourcePack, class_2960, byte[]> func) {
        this.getSys(type).put(path, new Memoized<class_2960>(func, path));
    }

    @Override
    public byte[] addResource(class_3264 type, class_2960 path, byte[] data) {
        this.getSys(type).put(path, () -> data);
        return data;
    }

    @Override
    public Future<byte[]> addAsyncRootResource(String path, CallableFunction<String, byte[]> data) {
        Future<byte[]> future = EXECUTOR_SERVICE.submit(() -> (byte[])data.get(path));
        this.root.put(path, () -> {
            try {
                return (byte[])future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        });
        return future;
    }

    @Override
    public void addLazyRootResource(String path, BiFunction<RuntimeResourcePack, String, byte[]> data) {
        this.root.put(path, new Memoized<String>(data, path));
    }

    @Override
    public byte[] addRootResource(String path, byte[] data) {
        this.root.put(path, () -> data);
        return data;
    }

    @Override
    public byte[] addAsset(class_2960 path, byte[] data) {
        return this.addResource(class_3264.field_14188, path, data);
    }

    @Override
    public byte[] addData(class_2960 path, byte[] data) {
        return this.addResource(class_3264.field_14190, path, data);
    }

    @Override
    public byte[] addModel(JModel model, class_2960 path) {
        return this.addAsset(RuntimeResourcePackImpl.fix(path, "models", "json"), RuntimeResourcePackImpl.serialize(model));
    }

    @Override
    public byte[] addBlockState(JState state, class_2960 path) {
        return this.addAsset(RuntimeResourcePackImpl.fix(path, "blockstates", "json"), RuntimeResourcePackImpl.serialize(state));
    }

    @Override
    public byte[] addTexture(class_2960 id, BufferedImage image) {
        UnsafeByteArrayOutputStream ubaos = new UnsafeByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", ubaos);
        }
        catch (IOException e) {
            throw new RuntimeException("impossible.", e);
        }
        return this.addAsset(RuntimeResourcePackImpl.fix(id, "textures", "png"), ubaos.getBytes());
    }

    @Override
    public byte[] addAnimation(class_2960 id, JAnimation animation) {
        return this.addAsset(RuntimeResourcePackImpl.fix(id, "textures", "png.mcmeta"), RuntimeResourcePackImpl.serialize(animation));
    }

    @Override
    public byte[] addTag(class_2960 id, JTag tag) {
        return this.addData(RuntimeResourcePackImpl.fix(id, "tags", "json"), RuntimeResourcePackImpl.serialize(tag));
    }

    @Override
    public byte[] addRecipe(class_2960 id, JRecipe recipe) {
        return this.addData(RuntimeResourcePackImpl.fix(id, "recipes", "json"), RuntimeResourcePackImpl.serialize(recipe));
    }

    @Override
    public Future<?> async(Consumer<RuntimeResourcePack> action) {
        this.lock();
        return EXECUTOR_SERVICE.submit(() -> {
            action.accept(this);
            this.waiting.unlock();
        });
    }

    @Override
    public void dumpDirect(Path output) {
        LOGGER.info("dumping " + this.id + "'s assets and data");
        try {
            for (Map.Entry<String, Supplier<byte[]>> entry : this.root.entrySet()) {
                Path path = output.resolve(entry.getKey());
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.write(path, entry.getValue().get(), new OpenOption[0]);
            }
            Path assets = output.resolve("assets");
            Files.createDirectories(assets, new FileAttribute[0]);
            for (Map.Entry<class_2960, Supplier<byte[]>> entry : this.assets.entrySet()) {
                this.write(assets, entry.getKey(), entry.getValue().get());
            }
            Path path = output.resolve("data");
            Files.createDirectories(path, new FileAttribute[0]);
            for (Map.Entry<class_2960, Supplier<byte[]>> entry : this.data.entrySet()) {
                this.write(path, entry.getKey(), entry.getValue().get());
            }
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void load(Path dir) throws IOException {
        Stream<Path> stream = Files.walk(dir, new FileVisitOption[0]);
        for (Path file : () -> stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(dir::relativize).iterator()) {
            String path;
            String s = file.toString();
            if (s.startsWith("assets")) {
                path = s.substring("assets".length() + 1);
                this.load(path, this.assets, Files.readAllBytes(file));
                continue;
            }
            if (s.startsWith("data")) {
                path = s.substring("data".length() + 1);
                this.load(path, this.data, Files.readAllBytes(file));
                continue;
            }
            byte[] data = Files.readAllBytes(file);
            this.root.put(s, () -> data);
        }
    }

    @Override
    public void dump(File output) {
        this.dump(Paths.get(output.toURI()));
    }

    @Override
    public void dump(ZipOutputStream zos) throws IOException {
        class_2960 id;
        this.lock();
        for (Map.Entry<String, Supplier<byte[]>> entry : this.root.entrySet()) {
            zos.putNextEntry(new ZipEntry(entry.getKey()));
            zos.write(entry.getValue().get());
            zos.closeEntry();
        }
        for (Map.Entry<String, Supplier<byte[]>> entry : this.assets.entrySet()) {
            id = (class_2960)entry.getKey();
            zos.putNextEntry(new ZipEntry("assets/" + id.method_12836() + "/" + id.method_12832()));
            zos.write(entry.getValue().get());
            zos.closeEntry();
        }
        for (Map.Entry<String, Supplier<byte[]>> entry : this.data.entrySet()) {
            id = (class_2960)entry.getKey();
            zos.putNextEntry(new ZipEntry("data/" + id.method_12836() + "/" + id.method_12832()));
            zos.write(entry.getValue().get());
            zos.closeEntry();
        }
        this.waiting.unlock();
    }

    @Override
    public void load(ZipInputStream stream) throws IOException {
        ZipEntry entry;
        while ((entry = stream.getNextEntry()) != null) {
            String path;
            String s = entry.toString();
            if (s.startsWith("assets")) {
                path = s.substring("assets".length() + 1);
                this.load(path, this.assets, this.read(entry, stream));
                continue;
            }
            if (s.startsWith("data")) {
                path = s.substring("data".length() + 1);
                this.load(path, this.data, this.read(entry, stream));
                continue;
            }
            byte[] data = this.read(entry, stream);
            this.root.put(s, () -> data);
        }
    }

    @Override
    public class_2960 getId() {
        return this.id;
    }

    public InputStream method_14410(String fileName) {
        if (!fileName.contains("/") && !fileName.contains("\\")) {
            this.lock();
            Supplier<byte[]> supplier = this.root.get(fileName);
            if (supplier == null) {
                this.waiting.unlock();
                return null;
            }
            this.waiting.unlock();
            return new ByteArrayInputStream(supplier.get());
        }
        throw new IllegalArgumentException("File name can't be a path");
    }

    public InputStream method_14405(class_3264 type, class_2960 id) {
        this.lock();
        Supplier<byte[]> supplier = this.getSys(type).get(id);
        if (supplier == null) {
            LOGGER.warn("No resource found for " + id);
            this.waiting.unlock();
            return null;
        }
        this.waiting.unlock();
        return new ByteArrayInputStream(supplier.get());
    }

    public Collection<class_2960> method_14408(class_3264 type, String namespace, String prefix, int maxDepth, Predicate<String> pathFilter) {
        this.lock();
        HashSet<class_2960> identifiers = new HashSet<class_2960>();
        for (class_2960 identifier : this.getSys(type).keySet()) {
            if (!identifier.method_12836().equals(namespace) || !identifier.method_12832().startsWith(prefix) || !pathFilter.test(identifier.method_12832())) continue;
            identifiers.add(identifier);
        }
        this.waiting.unlock();
        return identifiers;
    }

    public boolean method_14411(class_3264 type, class_2960 id) {
        this.lock();
        boolean contains = this.getSys(type).containsKey(id);
        this.waiting.unlock();
        return contains;
    }

    public Set<String> method_14406(class_3264 type) {
        this.lock();
        HashSet<String> namespaces = new HashSet<String>();
        for (class_2960 identifier : this.getSys(type).keySet()) {
            namespaces.add(identifier.method_12836());
        }
        this.waiting.unlock();
        return namespaces;
    }

    public <T> T method_14407(class_3270<T> metaReader) {
        if (metaReader.method_14420().equals("pack")) {
            JsonObject object = new JsonObject();
            object.addProperty("pack_format", (Number)this.packVersion);
            object.addProperty("description", "runtime resource pack");
            return (T)metaReader.method_14421(object);
        }
        LOGGER.info("'" + metaReader.method_14420() + "' is an unsupported metadata key!");
        return (T)metaReader.method_14421(new JsonObject());
    }

    public String method_14409() {
        return "Runtime Resource Pack" + this.id;
    }

    public void close() {
        LOGGER.info("closing rrp " + this.id);
        this.lock();
        if (DUMP) {
            this.dump();
        }
        this.waiting.unlock();
    }

    private static byte[] serialize(Object object) {
        UnsafeByteArrayOutputStream ubaos = new UnsafeByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(ubaos);
        GSON.toJson(object, (Appendable)writer);
        try {
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ubaos.getBytes();
    }

    private static class_2960 fix(class_2960 identifier, String prefix, String append) {
        return new class_2960(identifier.method_12836(), prefix + "/" + identifier.method_12832() + "." + append);
    }

    protected byte[] read(ZipEntry entry, InputStream stream) throws IOException {
        byte[] data = new byte[Math.toIntExact(entry.getSize())];
        if (stream.read(data) != data.length) {
            throw new IOException("Zip stream was cut off! (maybe incorrect zip entry length? maybe u didn't flush your stream?)");
        }
        return data;
    }

    protected void load(String fullPath, Map<class_2960, Supplier<byte[]>> map, byte[] data) {
        int sep = fullPath.indexOf(47);
        String namespace = fullPath.substring(0, sep);
        String path = fullPath.substring(sep + 1);
        map.put(new class_2960(namespace, path), () -> data);
    }

    private void lock() {
        if (!this.waiting.tryLock()) {
            if (DEBUG_PERFORMANCE) {
                long start = System.currentTimeMillis();
                this.waiting.lock();
                long end = System.currentTimeMillis();
                LOGGER.warn("waited " + (end - start) + "ms for lock in RRP: " + this.id);
            } else {
                this.waiting.lock();
            }
        }
    }

    private void write(Path dir, class_2960 identifier, byte[] data) {
        try {
            Path file = dir.resolve(identifier.method_12836()).resolve(identifier.method_12832());
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            try (OutputStream output = Files.newOutputStream(file, new OpenOption[0]);){
                output.write(data);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<class_2960, Supplier<byte[]>> getSys(class_3264 side) {
        return side == class_3264.field_14188 ? this.assets : this.data;
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().registerTypeAdapter(JMultipart.class, (Object)new JMultipart.Serializer()).registerTypeAdapter(JWhen.class, (Object)new JWhen.Serializer()).registerTypeAdapter(JState.class, (Object)new JState.Serializer()).registerTypeAdapter(JVariant.class, (Object)new JVariant.Serializer()).registerTypeAdapter(JTextures.class, (Object)new JTextures.Serializer()).registerTypeAdapter(JAnimation.class, (Object)new JAnimation.Serializer()).registerTypeAdapter(JFunction.class, (Object)new JFunction.Serializer()).registerTypeAdapter(JPool.class, (Object)new JPool.Serializer()).registerTypeAdapter(JPattern.class, (Object)new JPattern.Serializer()).registerTypeAdapter(JKeys.class, (Object)new JKeys.Serializer()).registerTypeAdapter(JIngredient.class, (Object)new JIngredient.Serializer()).registerTypeAdapter(JIngredients.class, (Object)new JIngredients.Serializer()).registerTypeAdapter(class_2960.class, (Object)new class_2960.class_2961()).registerTypeAdapter(JCondition.class, (Object)new JCondition.Serializer()).create();
        LOGGER = LogManager.getLogger((String)"RRP");
        Properties properties = new Properties();
        int processors = Math.max(Runtime.getRuntime().availableProcessors() / 2 - 1, 1);
        boolean dump = false;
        boolean performance = false;
        properties.setProperty("threads", String.valueOf(processors));
        properties.setProperty("dump assets", "false");
        properties.setProperty("debug performance", "false");
        File file = new File("config/rrp.properties");
        try (FileReader reader = new FileReader(file);){
            properties.load(reader);
            processors = Integer.parseInt(properties.getProperty("threads"));
            dump = Boolean.parseBoolean(properties.getProperty("dump assets"));
            performance = Boolean.parseBoolean(properties.getProperty("debug performance"));
        }
        catch (Throwable t) {
            LOGGER.warn("Invalid config, creating new one!");
            file.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(file);){
                properties.store(writer, "number of threads RRP should use for generating resources");
            }
            catch (IOException ex) {
                LOGGER.error("Unable to write to RRP config!");
                ex.printStackTrace();
            }
        }
        EXECUTOR_SERVICE = Executors.newFixedThreadPool(processors, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ARRP-Workers-%s").build());
        DUMP = dump;
        DEBUG_PERFORMANCE = performance;
    }

    private class Memoized<T>
    implements Supplier<byte[]> {
        private final BiFunction<RuntimeResourcePack, T, byte[]> func;
        private final T path;
        private byte[] data;

        public Memoized(BiFunction<RuntimeResourcePack, T, byte[]> func, T path) {
            this.func = func;
            this.path = path;
        }

        @Override
        public byte[] get() {
            if (this.data == null) {
                this.data = this.func.apply(RuntimeResourcePackImpl.this, (RuntimeResourcePack)this.path);
            }
            return this.data;
        }
    }
}

