/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.registrate.util.entry;

import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.fabric.RegistryObject;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import com.tterrag.registrate.util.nullness.NonnullType;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public class RegistryEntry<T>
implements NonNullSupplier<T> {
    private static RegistryEntry<?> EMPTY = new RegistryEntry(null, RegistryObject.empty());
    private final AbstractRegistrate<?> owner;
    @Nullable
    private final RegistryObject<T> delegate;

    public static <T> RegistryEntry<T> empty() {
        RegistryEntry<?> t = EMPTY;
        return t;
    }

    public RegistryEntry(AbstractRegistrate<?> owner, RegistryObject<T> delegate) {
        if (EMPTY != null && owner == null) {
            throw new NullPointerException("Owner must not be null");
        }
        if (EMPTY != null && delegate == null) {
            throw new NullPointerException("Delegate must not be null");
        }
        this.owner = owner;
        this.delegate = delegate;
    }

    public void updateReference(class_2378<? super T> registry) {
        RegistryObject<T> delegate = this.delegate;
        Objects.requireNonNull(delegate, "Registry entry is empty").updateReference(registry);
    }

    @Override
    @NonnullType
    public T get() {
        RegistryObject delegate = this.delegate;
        return Objects.requireNonNull(this.getUnchecked(), () -> delegate == null ? "Registry entry is empty" : "Registry entry not present: " + delegate.getId());
    }

    @Nullable
    public T getUnchecked() {
        RegistryObject<Object> delegate = this.delegate;
        return delegate == null ? null : delegate.orElse(null);
    }

    public <R, E extends R> RegistryEntry<E> getSibling(class_5321<? extends class_2378<R>> registryType) {
        return this == EMPTY ? RegistryEntry.empty() : this.owner.get(this.getId().method_12832(), registryType);
    }

    @Deprecated
    public <R, E extends R> RegistryEntry<E> getSibling(Class<? super R> registryType) {
        return this == EMPTY ? RegistryEntry.empty() : this.owner.get(this.getId().method_12832(), registryType);
    }

    public <R, E extends R> RegistryEntry<E> getSibling(class_2378<R> registry) {
        return this.getSibling(registry.method_30517());
    }

    public RegistryEntry<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        if (!this.isPresent() || predicate.test(this.get())) {
            return this;
        }
        return RegistryEntry.empty();
    }

    public <R> boolean is(R entry) {
        return this.get() == entry;
    }

    protected static <E extends RegistryEntry<?>> E cast(Class<? super E> clazz, RegistryEntry<?> entry) {
        if (clazz.isInstance(entry)) {
            return (E)entry;
        }
        throw new IllegalArgumentException("Could not convert RegistryEntry: expecting " + clazz + ", found " + entry.getClass());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegistryEntry)) {
            return false;
        }
        RegistryEntry other = (RegistryEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RegistryObject<T> this$delegate = this.delegate;
        RegistryObject<T> other$delegate = other.delegate;
        return !(this$delegate == null ? other$delegate != null : !((Object)this$delegate).equals(other$delegate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RegistryEntry;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RegistryObject<T> $delegate = this.delegate;
        result = result * 59 + ($delegate == null ? 43 : ((Object)$delegate).hashCode());
        return result;
    }

    public class_2960 getId() {
        return this.delegate.getId();
    }

    public boolean isPresent() {
        return this.delegate.isPresent();
    }

    public void ifPresent(Consumer<? super T> consumer) {
        this.delegate.ifPresent(consumer);
    }

    public Stream<T> stream() {
        return this.delegate.stream();
    }

    public <U> Optional<U> map(Function<? super T, ? extends U> mapper) {
        return this.delegate.map(mapper);
    }

    public <U> Optional<U> flatMap(Function<? super T, Optional<U>> mapper) {
        return this.delegate.flatMap(mapper);
    }

    public <U> Supplier<U> lazyMap(Function<? super T, ? extends U> mapper) {
        return this.delegate.lazyMap(mapper);
    }

    public T orElse(T other) {
        return this.delegate.orElse(other);
    }

    public T orElseGet(Supplier<? extends T> other) {
        return this.delegate.orElseGet(other);
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        return this.delegate.orElseThrow(exceptionSupplier);
    }

    private static interface Exclusions<T> {
        public T get();

        public RegistryObject<T> filter(Predicate<? super T> var1);

        public void updateReference(class_2378<? extends T> var1);
    }
}

