/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.registrate.providers;

import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.fabric.LanguageProvider;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateProvider;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import com.tterrag.registrate.util.nullness.NonnullType;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.minecraft.class_1299;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2403;
import net.minecraft.class_2408;
import net.minecraft.class_2588;
import net.minecraft.class_2591;
import net.minecraft.class_3611;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class RegistrateLangProvider
extends LanguageProvider
implements RegistrateProvider {
    private final AbstractRegistrate<?> owner;
    private final AccessibleLanguageProvider upsideDown;
    private static final String NORMAL_CHARS = "abcdefghijklmn\u00f1opqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_,;.?!/\\'";
    private static final String UPSIDE_DOWN_CHARS = "\u0250q\u0254p\u01dd\u025fb\u0265\u0131\u0638\u029e\u05df\u026fuuodb\u0279s\u0287n\u028c\u028dx\u028ez\u2c6f\u15fa\u0186\u15e1\u018e\u2132\u2141HI\u017f\u029e\ua780WNO\u0500\u1f49\u1d1aS\u27d8\u2229\u039bMX\u028eZ0\u0196\u1105\u0190\u3123\u03db9\u312586\u203e'\u061b\u02d9\u00bf\u00a1/\\,";

    public RegistrateLangProvider(AbstractRegistrate<?> owner, class_2403 gen) {
        super(gen, owner.getModid(), "en_us");
        this.owner = owner;
        this.upsideDown = new AccessibleLanguageProvider(gen, owner.getModid(), "en_ud");
    }

    @Override
    public EnvType getSide() {
        return EnvType.CLIENT;
    }

    @Override
    public String method_10321() {
        return "Lang (en_us/en_ud)";
    }

    @Override
    protected void addTranslations() {
        this.owner.genData(ProviderType.LANG, this);
    }

    public static final String toEnglishName(String internalName) {
        return Arrays.stream(internalName.toLowerCase(Locale.ROOT).split("_")).map(StringUtils::capitalize).collect(Collectors.joining(" "));
    }

    public String getAutomaticName(NonNullSupplier<?> sup) {
        Object t = sup.get();
        if (t instanceof class_2248) {
            class_2248 block = (class_2248)t;
            return RegistrateLangProvider.toEnglishName(class_2378.field_11146.method_10221((Object)block).method_12832());
        }
        t = sup.get();
        if (t instanceof class_1792) {
            class_1792 item = (class_1792)t;
            return RegistrateLangProvider.toEnglishName(class_2378.field_11142.method_10221((Object)item).method_12832());
        }
        t = sup.get();
        if (t instanceof class_1887) {
            class_1887 enchantment = (class_1887)t;
            return RegistrateLangProvider.toEnglishName(class_2378.field_11160.method_10221((Object)enchantment).method_12832());
        }
        t = sup.get();
        if (t instanceof class_1299) {
            class_1299 entityType = (class_1299)t;
            return RegistrateLangProvider.toEnglishName(class_2378.field_11145.method_10221((Object)entityType).method_12832());
        }
        t = sup.get();
        if (t instanceof class_2591) {
            class_2591 blockEntityType = (class_2591)t;
            return RegistrateLangProvider.toEnglishName(class_2378.field_11137.method_10221((Object)blockEntityType).method_12832());
        }
        t = sup.get();
        if (t instanceof class_3611) {
            class_3611 fluid = (class_3611)t;
            return RegistrateLangProvider.toEnglishName(class_2378.field_11154.method_10221((Object)fluid).method_12832());
        }
        return "Registry not found, or implemented.";
    }

    public void addBlock(NonNullSupplier<? extends class_2248> block) {
        this.addBlock(block, this.getAutomaticName(block));
    }

    public void addBlockWithTooltip(NonNullSupplier<? extends class_2248> block, String tooltip) {
        this.addBlock(block);
        this.addTooltip(block, tooltip);
    }

    public void addBlockWithTooltip(NonNullSupplier<? extends class_2248> block, String name, String tooltip) {
        this.addBlock(block, name);
        this.addTooltip(block, tooltip);
    }

    public void addItem(NonNullSupplier<? extends class_1792> item) {
        this.addItem(item, this.getAutomaticName(item));
    }

    public void addItemWithTooltip(NonNullSupplier<? extends class_1792> block, String name, List<@NonnullType String> tooltip) {
        this.addItem(block, name);
        this.addTooltip(block, tooltip);
    }

    public void addTooltip(NonNullSupplier<? extends class_1935> item, String tooltip) {
        this.add(((class_1935)item.get()).method_8389().method_7876() + ".desc", tooltip);
    }

    public void addTooltip(NonNullSupplier<? extends class_1935> item, List<@NonnullType String> tooltip) {
        for (int i = 0; i < tooltip.size(); ++i) {
            this.add(((class_1935)item.get()).method_8389().method_7876() + ".desc." + i, tooltip.get(i));
        }
    }

    public void add(class_1761 tab, String name) {
        this.add(((class_2588)tab.method_7737()).method_11022(), name);
    }

    public void addEntityType(NonNullSupplier<? extends class_1299<?>> entity) {
        this.addEntityType(entity, this.getAutomaticName(entity));
    }

    private String toUpsideDown(String normal) {
        char[] ud = new char[normal.length()];
        for (int i = 0; i < normal.length(); ++i) {
            char c = normal.charAt(i);
            if (c == '%') {
                Object fmtArg = "";
                while (Character.isDigit(c) || c == '%' || c == '$' || c == 's' || c == 'd') {
                    fmtArg = (String)fmtArg + c;
                    c = ++i == normal.length() ? (char)'\u0000' : normal.charAt(i);
                }
                --i;
                for (int j = 0; j < ((String)fmtArg).length(); ++j) {
                    ud[normal.length() - 1 - i + j] = ((String)fmtArg).charAt(j);
                }
                continue;
            }
            int lookup = NORMAL_CHARS.indexOf(c);
            if (lookup >= 0) {
                c = UPSIDE_DOWN_CHARS.charAt(lookup);
            }
            ud[normal.length() - 1 - i] = c;
        }
        return new String(ud);
    }

    @Override
    public void add(String key, String value) {
        super.add(key, value);
        this.upsideDown.add(key, this.toUpsideDown(value));
    }

    @Override
    public void method_10319(class_2408 cache) throws IOException {
        super.method_10319(cache);
        this.upsideDown.method_10319(cache);
    }

    static {
        if (NORMAL_CHARS.length() != UPSIDE_DOWN_CHARS.length()) {
            throw new AssertionError((Object)"Char maps do not match in length!");
        }
    }

    private static class AccessibleLanguageProvider
    extends LanguageProvider {
        public AccessibleLanguageProvider(class_2403 gen, String modid, String locale) {
            super(gen, modid, locale);
        }

        @Override
        public void add(@Nullable String key, @Nullable String value) {
            super.add(key, value);
        }

        @Override
        protected void addTranslations() {
        }
    }
}

