/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.registrate.providers;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateProvider;
import com.tterrag.registrate.util.DebugMarkers;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.minecraft.class_2405;
import net.minecraft.class_2408;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class RegistrateDataProvider
implements class_2405 {
    private static final Logger log = LogManager.getLogger(RegistrateDataProvider.class);
    static final BiMap<String, ProviderType<?>> TYPES = HashBiMap.create();
    private final String mod;
    private final Map<ProviderType<?>, RegistrateProvider> subProviders = new LinkedHashMap();

    @Nullable
    public static String getTypeName(ProviderType<?> type) {
        return (String)TYPES.inverse().get(type);
    }

    public RegistrateDataProvider(AbstractRegistrate<?> parent, String modid, FabricDataGenerator generator, ExistingFileHelper helper) {
        this.mod = modid;
        EnumSet<EnvType> sides = EnumSet.noneOf(EnvType.class);
        sides.add(EnvType.SERVER);
        sides.add(EnvType.CLIENT);
        log.debug(DebugMarkers.DATA, "Gathering providers for sides: {}", sides);
        HashMap known = new HashMap();
        for (String id : TYPES.keySet()) {
            ProviderType type = (ProviderType)TYPES.get((Object)id);
            Object prov = type.create(parent, new DataInfo(generator, helper), known);
            known.put(type, (RegistrateProvider)prov);
            if (!sides.contains(prov.getSide())) continue;
            log.debug(DebugMarkers.DATA, "Adding provider for type: {}", (Object)id);
            this.subProviders.put(type, (RegistrateProvider)prov);
        }
    }

    public void method_10319(class_2408 cache) throws IOException {
        for (Map.Entry<ProviderType<?>, RegistrateProvider> e : this.subProviders.entrySet()) {
            log.debug(DebugMarkers.DATA, "Generating data for type: {}", (Object)RegistrateDataProvider.getTypeName(e.getKey()));
            e.getValue().method_10319(cache);
        }
    }

    public String method_10321() {
        return "Registrate Provider for " + this.mod + " [" + this.subProviders.values().stream().map(class_2405::method_10321).collect(Collectors.joining(", ")) + "]";
    }

    public <P extends RegistrateProvider> Optional<P> getSubProvider(ProviderType<P> type) {
        return Optional.ofNullable(this.subProviders.get(type));
    }

    record DataInfo(FabricDataGenerator generator, ExistingFileHelper helper) {
    }
}

