/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.registrate.fabric;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Supplier;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_2248;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2408;
import org.apache.commons.lang3.text.translate.JavaUnicodeEscaper;

public abstract class LanguageProvider
implements class_2405 {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Map<String, String> data = new TreeMap<String, String>();
    private final class_2403 gen;
    private final String modid;
    private final String locale;

    public LanguageProvider(class_2403 gen, String modid, String locale) {
        this.gen = gen;
        this.modid = modid;
        this.locale = locale;
    }

    protected abstract void addTranslations();

    public void method_10319(class_2408 cache) throws IOException {
        this.addTranslations();
        if (!this.data.isEmpty()) {
            this.save(cache, this.data, this.gen.method_10313().resolve("assets/" + this.modid + "/lang/" + this.locale + ".json"));
        }
    }

    public String method_10321() {
        return "Languages: " + this.locale;
    }

    private void save(class_2408 cache, Object object, Path target) throws IOException {
        String data = GSON.toJson(object);
        data = JavaUnicodeEscaper.outsideOf((int)0, (int)127).translate((CharSequence)data);
        String hash = class_2405.field_11280.hashUnencodedChars((CharSequence)data).toString();
        if (!Objects.equals(cache.method_10323(target), hash) || !Files.exists(target, new LinkOption[0])) {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            try (BufferedWriter bufferedwriter = Files.newBufferedWriter(target, new OpenOption[0]);){
                bufferedwriter.write(data);
            }
        }
        cache.method_10325(target, hash);
    }

    public void addBlock(Supplier<? extends class_2248> key, String name) {
        this.add(key.get(), name);
    }

    public void add(class_2248 key, String name) {
        this.add(key.method_9539(), name);
    }

    public void addItem(Supplier<? extends class_1792> key, String name) {
        this.add(key.get(), name);
    }

    public void add(class_1792 key, String name) {
        this.add(key.method_7876(), name);
    }

    public void addItemStack(Supplier<class_1799> key, String name) {
        this.add(key.get(), name);
    }

    public void add(class_1799 key, String name) {
        this.add(key.method_7922(), name);
    }

    public void addEnchantment(Supplier<? extends class_1887> key, String name) {
        this.add(key.get(), name);
    }

    public void add(class_1887 key, String name) {
        this.add(key.method_8184(), name);
    }

    public void addEffect(Supplier<? extends class_1291> key, String name) {
        this.add(key.get(), name);
    }

    public void add(class_1291 key, String name) {
        this.add(key.method_5567(), name);
    }

    public void addEntityType(Supplier<? extends class_1299<?>> key, String name) {
        this.add(key.get(), name);
    }

    public void add(class_1299<?> key, String name) {
        this.add(key.method_5882(), name);
    }

    public void add(String key, String value) {
        if (this.data.put(key, value) != null) {
            throw new IllegalStateException("Duplicate translation key " + key);
        }
    }
}

