/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.registrate.builders;

import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.builders.AbstractBuilder;
import com.tterrag.registrate.builders.BuilderCallback;
import com.tterrag.registrate.fabric.EnvExecutor;
import com.tterrag.registrate.fabric.RegistryObject;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateItemModelProvider;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_326;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;

public class ItemBuilder<T extends class_1792, P>
extends AbstractBuilder<class_1792, T, P, ItemBuilder<T, P>> {
    private final NonNullFunction<class_1792.class_1793, T> factory;
    private NonNullSupplier<class_1792.class_1793> initialProperties = FabricItemSettings::new;
    private NonNullFunction<class_1792.class_1793, class_1792.class_1793> propertiesCallback = NonNullUnaryOperator.identity();
    @Nullable
    private NonNullSupplier<Supplier<class_326>> colorHandler;

    public static <T extends class_1792, P> ItemBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, NonNullFunction<class_1792.class_1793, T> factory) {
        return ItemBuilder.create(owner, parent, name, callback, factory, null);
    }

    public static <T extends class_1792, P> ItemBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, NonNullFunction<class_1792.class_1793, T> factory, @Nullable NonNullSupplier<? extends class_1761> tab) {
        return new ItemBuilder<T, P>(owner, parent, name, callback, factory).defaultModel().defaultLang().transform(ib -> tab == null ? ib : ib.tab(tab));
    }

    protected ItemBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, NonNullFunction<class_1792.class_1793, T> factory) {
        super(owner, parent, name, callback, class_2378.field_25108);
        this.factory = factory;
    }

    public ItemBuilder<T, P> properties(NonNullUnaryOperator<class_1792.class_1793> func) {
        this.propertiesCallback = this.propertiesCallback.andThen(func);
        return this;
    }

    public ItemBuilder<T, P> initialProperties(NonNullSupplier<class_1792.class_1793> properties) {
        this.initialProperties = properties;
        return this;
    }

    public ItemBuilder<T, P> tab(NonNullSupplier<? extends class_1761> tab) {
        return this.properties(p -> p.method_7892((class_1761)tab.get()));
    }

    public ItemBuilder<T, P> color(NonNullSupplier<Supplier<class_326>> colorHandler) {
        if (this.colorHandler == null) {
            EnvExecutor.runWhenOn(EnvType.CLIENT, () -> this::registerItemColor);
        }
        this.colorHandler = colorHandler;
        return this;
    }

    protected void registerItemColor() {
        this.onRegister(entry -> ColorProviderRegistry.ITEM.register((Object)((class_326)((Supplier)this.colorHandler.get()).get()), (Object[])new class_1935[]{entry}));
    }

    public ItemBuilder<T, P> defaultModel() {
        return this.model((ctx, prov) -> prov.generated(ctx::getEntry));
    }

    public ItemBuilder<T, P> model(NonNullBiConsumer<DataGenContext<class_1792, T>, RegistrateItemModelProvider> cons) {
        return (ItemBuilder)this.setData(ProviderType.ITEM_MODEL, cons);
    }

    public ItemBuilder<T, P> defaultLang() {
        return (ItemBuilder)this.lang(class_1792::method_7876);
    }

    public ItemBuilder<T, P> lang(String name) {
        return (ItemBuilder)this.lang(class_1792::method_7876, name);
    }

    public ItemBuilder<T, P> recipe(NonNullBiConsumer<DataGenContext<class_1792, T>, RegistrateRecipeProvider> cons) {
        return (ItemBuilder)this.setData(ProviderType.RECIPE, cons);
    }

    @SafeVarargs
    public final ItemBuilder<T, P> tag(class_6862<class_1792> ... tags) {
        return (ItemBuilder)this.tag(ProviderType.ITEM_TAGS, tags);
    }

    @Override
    protected T createEntry() {
        class_1792.class_1793 properties = (class_1792.class_1793)this.initialProperties.get();
        properties = this.propertiesCallback.apply(properties);
        return (T)((class_1792)this.factory.apply(properties));
    }

    @Override
    protected RegistryEntry<T> createEntryWrapper(RegistryObject<T> delegate) {
        return new ItemEntry<T>(this.getOwner(), delegate);
    }

    @Override
    public ItemEntry<T> register() {
        return (ItemEntry)super.register();
    }
}

