/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.registrate.builders;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.builders.AbstractBuilder;
import com.tterrag.registrate.builders.BlockEntityBuilder;
import com.tterrag.registrate.builders.BuilderCallback;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.fabric.EnvExecutor;
import com.tterrag.registrate.fabric.RegistryObject;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.providers.loot.RegistrateBlockLootTables;
import com.tterrag.registrate.providers.loot.RegistrateLootTableProvider;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullBiFunction;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2430;
import net.minecraft.class_2586;
import net.minecraft.class_322;
import net.minecraft.class_3614;
import net.minecraft.class_3620;
import net.minecraft.class_39;
import net.minecraft.class_4970;
import net.minecraft.class_6862;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockBuilder<T extends class_2248, P>
extends AbstractBuilder<class_2248, T, P, BlockBuilder<T, P>> {
    private final NonNullFunction<class_4970.class_2251, T> factory;
    private NonNullSupplier<class_4970.class_2251> initialProperties;
    private NonNullFunction<class_4970.class_2251, class_4970.class_2251> propertiesCallback = NonNullUnaryOperator.identity();
    private List<Supplier<Supplier<class_1921>>> renderLayers = new ArrayList<Supplier<Supplier<class_1921>>>(1);
    @Nullable
    private NonNullSupplier<Supplier<class_322>> colorHandler;

    public static <T extends class_2248, P> BlockBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, NonNullFunction<class_4970.class_2251, T> factory, class_3614 material) {
        return new BlockBuilder<T, P>(owner, parent, name, callback, factory, () -> class_4970.class_2251.method_9637((class_3614)material)).defaultBlockstate().defaultLoot().defaultLang();
    }

    protected BlockBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, NonNullFunction<class_4970.class_2251, T> factory, NonNullSupplier<class_4970.class_2251> initialProperties) {
        super(owner, parent, name, callback, class_2378.field_25105);
        this.factory = factory;
        this.initialProperties = initialProperties;
    }

    public BlockBuilder<T, P> properties(NonNullUnaryOperator<class_4970.class_2251> func) {
        this.propertiesCallback = this.propertiesCallback.andThen(func);
        return this;
    }

    public BlockBuilder<T, P> initialProperties(class_3614 material) {
        this.initialProperties = () -> class_4970.class_2251.method_9637((class_3614)material);
        return this;
    }

    public BlockBuilder<T, P> initialProperties(class_3614 material, class_1767 color) {
        this.initialProperties = () -> class_4970.class_2251.method_9617((class_3614)material, (class_1767)color);
        return this;
    }

    public BlockBuilder<T, P> initialProperties(class_3614 material, class_3620 color) {
        this.initialProperties = () -> class_4970.class_2251.method_9639((class_3614)material, (class_3620)color);
        return this;
    }

    public BlockBuilder<T, P> initialProperties(NonNullSupplier<? extends class_2248> block) {
        this.initialProperties = () -> class_4970.class_2251.method_9630((class_4970)((class_4970)block.get()));
        return this;
    }

    public BlockBuilder<T, P> addLayer(Supplier<Supplier<class_1921>> layer) {
        EnvExecutor.runWhenOn(EnvType.CLIENT, () -> () -> BlockBuilder.lambda$addLayer$5((Supplier)layer));
        if (this.renderLayers.isEmpty()) {
            this.onRegister(this::registerLayers);
        }
        this.renderLayers.add(layer);
        return this;
    }

    protected void registerLayers(T entry) {
        EnvExecutor.runWhenOn(EnvType.CLIENT, () -> () -> {
            if (this.renderLayers.size() == 1) {
                class_1921 layer = this.renderLayers.get(0).get().get();
                BlockRenderLayerMap.INSTANCE.putBlock(entry, layer);
            } else if (this.renderLayers.size() > 1) {
                Set layers = this.renderLayers.stream().map(s -> (class_1921)((Supplier)s.get()).get()).collect(Collectors.toSet());
                for (class_1921 layer : layers) {
                    BlockRenderLayerMap.INSTANCE.putBlock(entry, layer);
                }
            }
        });
    }

    public BlockBuilder<T, P> simpleItem() {
        return (BlockBuilder)this.item().build();
    }

    public ItemBuilder<class_1747, BlockBuilder<T, P>> item() {
        return this.item(class_1747::new);
    }

    public <I extends class_1792> ItemBuilder<I, BlockBuilder<T, P>> item(NonNullBiFunction<? super T, class_1792.class_1793, ? extends I> factory) {
        return ((ItemBuilder)this.getOwner().item(this, this.getName(), p -> (class_1792)factory.apply((T)this.getEntry(), (class_1792.class_1793)p)).setData(ProviderType.LANG, NonNullBiConsumer.noop())).model((ctx, prov) -> {
            Optional<String> model = this.getOwner().getDataProvider(ProviderType.BLOCKSTATE).flatMap(p -> p.getExistingVariantBuilder((class_2248)this.getEntry())).map(b -> b.getModels().get(b.partialState())).map(BlockStateProvider.ConfiguredModelList::toJSON).filter(JsonElement::isJsonObject).map(j -> j.getAsJsonObject().get("model")).map(JsonElement::getAsString);
            if (model.isPresent()) {
                prov.withExistingParent(ctx.getName(), model.get());
            } else {
                prov.blockItem(this.asSupplier());
            }
        });
    }

    public <BE extends class_2586> BlockBuilder<T, P> simpleBlockEntity(BlockEntityBuilder.BlockEntityFactory<BE> factory) {
        return (BlockBuilder)this.blockEntity(factory).build();
    }

    public <BE extends class_2586> BlockEntityBuilder<BE, BlockBuilder<T, P>> blockEntity(BlockEntityBuilder.BlockEntityFactory<BE> factory) {
        return this.getOwner().blockEntity(this, this.getName(), factory).validBlock(this.asSupplier());
    }

    public BlockBuilder<T, P> color(NonNullSupplier<Supplier<class_322>> colorHandler) {
        if (this.colorHandler == null) {
            EnvExecutor.runWhenOn(EnvType.CLIENT, () -> this::registerBlockColor);
        }
        this.colorHandler = colorHandler;
        return this;
    }

    protected void registerBlockColor() {
        this.onRegister(entry -> ColorProviderRegistry.BLOCK.register((Object)((class_322)((Supplier)this.colorHandler.get()).get()), (Object[])new class_2248[]{entry}));
    }

    public BlockBuilder<T, P> defaultBlockstate() {
        return this.blockstate((ctx, prov) -> prov.simpleBlock((class_2248)ctx.getEntry()));
    }

    public BlockBuilder<T, P> blockstate(NonNullBiConsumer<DataGenContext<class_2248, T>, RegistrateBlockstateProvider> cons) {
        return (BlockBuilder)this.setData(ProviderType.BLOCKSTATE, cons);
    }

    public BlockBuilder<T, P> defaultLang() {
        return (BlockBuilder)this.lang(class_2248::method_9539);
    }

    public BlockBuilder<T, P> lang(String name) {
        return (BlockBuilder)this.lang(class_2248::method_9539, name);
    }

    public BlockBuilder<T, P> defaultLoot() {
        return this.loot(class_2430::method_16329);
    }

    public BlockBuilder<T, P> loot(NonNullBiConsumer<RegistrateBlockLootTables, T> cons) {
        return (BlockBuilder)this.setData(ProviderType.LOOT, (ctx, prov) -> prov.addLootAction(RegistrateLootTableProvider.LootType.BLOCK, tb -> {
            if (!((class_2248)ctx.getEntry()).method_26162().equals((Object)class_39.field_844)) {
                cons.accept((RegistrateBlockLootTables)tb, (class_2248)ctx.getEntry());
            }
        }));
    }

    public BlockBuilder<T, P> recipe(NonNullBiConsumer<DataGenContext<class_2248, T>, RegistrateRecipeProvider> cons) {
        return (BlockBuilder)this.setData(ProviderType.RECIPE, cons);
    }

    @SafeVarargs
    public final BlockBuilder<T, P> tag(class_6862<class_2248> ... tags) {
        return (BlockBuilder)this.tag(ProviderType.BLOCK_TAGS, tags);
    }

    @Override
    protected T createEntry() {
        // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull class_4970.class_2251 properties = (class_4970.class_2251)this.initialProperties.get();
        properties = this.propertiesCallback.apply(properties);
        return (T)((class_2248)this.factory.apply(properties));
    }

    @Override
    protected RegistryEntry<T> createEntryWrapper(RegistryObject<T> delegate) {
        return new BlockEntry<T>(this.getOwner(), delegate);
    }

    @Override
    public BlockEntry<T> register() {
        return (BlockEntry)super.register();
    }

    private static /* synthetic */ void lambda$addLayer$5(Supplier layer) {
        Preconditions.checkArgument((boolean)class_1921.method_22720().contains(((Supplier)layer.get()).get()), (Object)("Invalid block layer: " + layer));
    }
}

