/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.registrate.builders;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.builders.Builder;
import com.tterrag.registrate.builders.BuilderCallback;
import com.tterrag.registrate.fabric.RegistryObject;
import com.tterrag.registrate.fabric.RegistryUtil;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import com.tterrag.registrate.providers.RegistrateTagsProvider;
import com.tterrag.registrate.util.entry.LazyRegistryEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullBiFunction;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import com.tterrag.registrate.util.nullness.NonnullType;
import java.util.Arrays;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_6862;

public abstract class AbstractBuilder<R, T extends R, P, S extends AbstractBuilder<R, T, P, S>>
implements Builder<R, T, P, S> {
    private final AbstractRegistrate<?> owner;
    private final P parent;
    private final String name;
    private final BuilderCallback callback;
    private final class_5321<? extends class_2378<R>> registryKey;
    private final Multimap<ProviderType<? extends RegistrateTagsProvider<?>>, class_6862<?>> tagsByType = HashMultimap.create();
    private final LazyRegistryEntry<T> safeSupplier = new LazyRegistryEntry(this);

    @Deprecated
    public AbstractBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, Class<? super R> registryType) {
        this(owner, parent, name, callback, owner.getRegistryKeyByClass(registryType));
    }

    @Override
    @Deprecated
    public Class<? super R> getRegistryType() {
        return RegistryUtil.getRegistrationClass(this.registryKey);
    }

    @NonnullType
    protected abstract T createEntry();

    @Override
    public RegistryEntry<T> register() {
        return this.callback.accept(this.name, this.registryKey, this, this::createEntry, this::createEntryWrapper);
    }

    protected RegistryEntry<T> createEntryWrapper(RegistryObject<T> delegate) {
        return new RegistryEntry<T>(this.getOwner(), delegate);
    }

    @Override
    public NonNullSupplier<T> asSupplier() {
        return this.safeSupplier;
    }

    @SafeVarargs
    public final S tag(ProviderType<? extends RegistrateTagsProvider<R>> type, class_6862<R> ... tags) {
        if (!this.tagsByType.containsKey(type)) {
            this.setData(type, (ctx, prov) -> this.tagsByType.get((Object)type).stream().map(t -> t).map(prov::method_10512).forEach(b -> b.method_26793(this.asSupplier().get())));
        }
        this.tagsByType.putAll(type, Arrays.asList(tags));
        return (S)this;
    }

    @SafeVarargs
    public final S removeTag(ProviderType<RegistrateTagsProvider<R>> type, class_6862<R> ... tags) {
        if (this.tagsByType.containsKey(type)) {
            for (class_6862<R> tag : tags) {
                this.tagsByType.remove(type, tag);
            }
        }
        return (S)this;
    }

    public S lang(NonNullFunction<T, String> langKeyProvider) {
        return this.lang(langKeyProvider, (RegistrateLangProvider p, NonNullSupplier<? extends T> t) -> p.getAutomaticName((NonNullSupplier<?>)t));
    }

    public S lang(NonNullFunction<T, String> langKeyProvider, String name) {
        return this.lang(langKeyProvider, (RegistrateLangProvider p, NonNullSupplier<? extends T> s) -> name);
    }

    private S lang(NonNullFunction<T, String> langKeyProvider, NonNullBiFunction<RegistrateLangProvider, NonNullSupplier<? extends T>, String> localizedNameProvider) {
        return (S)((AbstractBuilder)this.setData(ProviderType.LANG, (ctx, prov) -> prov.add((String)langKeyProvider.apply(ctx.getEntry()), (String)localizedNameProvider.apply((RegistrateLangProvider)prov, ctx::getEntry))));
    }

    public AbstractBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, class_5321<? extends class_2378<R>> registryKey) {
        this.owner = owner;
        this.parent = parent;
        this.name = name;
        this.callback = callback;
        this.registryKey = registryKey;
    }

    @Override
    public AbstractRegistrate<?> getOwner() {
        return this.owner;
    }

    @Override
    public P getParent() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected BuilderCallback getCallback() {
        return this.callback;
    }

    @Override
    public class_5321<? extends class_2378<R>> getRegistryKey() {
        return this.registryKey;
    }
}

