/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.SocketAddress;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.ParseException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import jdk.jfr.Configuration;
import jdk.jfr.Event;
import jdk.jfr.FlightRecorder;
import jdk.jfr.FlightRecorderListener;
import jdk.jfr.Recording;
import jdk.jfr.RecordingState;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_5321;
import net.minecraft.class_6506;
import net.minecraft.class_6507;
import net.minecraft.class_6611;
import net.minecraft.class_6613;
import net.minecraft.util.profiling.jfr.event.ChunkGenerationEvent;
import net.minecraft.util.profiling.jfr.event.NetworkSummaryEvent;
import net.minecraft.util.profiling.jfr.event.PacketReceivedEvent;
import net.minecraft.util.profiling.jfr.event.PacketSentEvent;
import net.minecraft.util.profiling.jfr.event.ServerTickTimeEvent;
import net.minecraft.util.profiling.jfr.event.WorldLoadFinishedEvent;
import org.slf4j.Logger;

public class class_6505
implements class_6611 {
    private static final Logger field_34408 = LogUtils.getLogger();
    public static final String field_34403 = "Minecraft";
    public static final String field_34404 = "World Generation";
    public static final String field_34405 = "Ticking";
    public static final String field_34406 = "Network";
    private static final List<Class<? extends Event>> field_34407 = List.of(ChunkGenerationEvent.class, PacketReceivedEvent.class, PacketSentEvent.class, NetworkSummaryEvent.class, ServerTickTimeEvent.class, WorldLoadFinishedEvent.class);
    private static final String field_34409 = "/flightrecorder-config.jfc";
    private static final DateTimeFormatter field_34410 = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd-HHmmss").toFormatter().withZone(ZoneId.systemDefault());
    private static final class_6505 field_35576 = new class_6505();
    @Nullable
    Recording field_34411;
    private float field_35577;
    private final Map<String, NetworkSummaryEvent.class_6779> field_35578 = new ConcurrentHashMap<String, NetworkSummaryEvent.class_6779>();

    private class_6505() {
        field_34407.forEach(FlightRecorder::register);
        FlightRecorder.addPeriodicEvent(ServerTickTimeEvent.class, () -> new ServerTickTimeEvent(this.field_35577).commit());
        FlightRecorder.addPeriodicEvent(NetworkSummaryEvent.class, () -> {
            Iterator<NetworkSummaryEvent.class_6779> $$0 = this.field_35578.values().iterator();
            while ($$0.hasNext()) {
                $$0.next().method_39494();
                $$0.remove();
            }
        });
    }

    public static class_6505 method_39428() {
        return field_35576;
    }

    @Override
    public boolean method_37981(class_6506 $$0) {
        boolean bl;
        URL $$1 = class_6505.class.getResource(field_34409);
        if ($$1 == null) {
            field_34408.warn("Could not find default flight recorder config at {}", (Object)field_34409);
            return false;
        }
        BufferedReader $$2 = new BufferedReader(new InputStreamReader($$1.openStream()));
        try {
            bl = this.method_37983($$2, $$0);
        }
        catch (Throwable throwable) {
            try {
                try {
                    $$2.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException $$3) {
                field_34408.warn("Failed to start flight recorder using configuration at {}", (Object)$$1, (Object)$$3);
                return false;
            }
        }
        $$2.close();
        return bl;
    }

    @Override
    public Path method_37980() {
        if (this.field_34411 == null) {
            throw new IllegalStateException("Not currently profiling");
        }
        this.field_35578.clear();
        Path $$0 = this.field_34411.getDestination();
        this.field_34411.stop();
        return $$0;
    }

    @Override
    public boolean method_37984() {
        return this.field_34411 != null;
    }

    @Override
    public boolean method_38658() {
        return FlightRecorder.isAvailable();
    }

    private boolean method_37983(Reader $$0, class_6506 $$1) {
        if (this.method_37984()) {
            field_34408.warn("Profiling already in progress");
            return false;
        }
        try {
            Configuration $$22 = Configuration.create($$0);
            String $$3 = field_34410.format(Instant.now());
            this.field_34411 = class_156.method_654(new Recording($$22), $$2 -> {
                field_34407.forEach($$2::enable);
                $$2.setDumpOnExit(true);
                $$2.setToDisk(true);
                $$2.setName("%s-%s-%s".formatted($$1.method_37986(), class_155.method_16673().getName(), $$3));
            });
            Path $$4 = Paths.get("debug/%s-%s.jfr".formatted($$1.method_37986(), $$3), new String[0]);
            if (!Files.exists($$4.getParent(), new LinkOption[0])) {
                Files.createDirectories($$4.getParent(), new FileAttribute[0]);
            }
            this.field_34411.setDestination($$4);
            this.field_34411.start();
            this.method_38660();
        }
        catch (IOException | ParseException $$5) {
            field_34408.warn("Failed to start jfr profiling", (Throwable)$$5);
            return false;
        }
        field_34408.info("Started flight recorder profiling id({}):name({}) - will dump to {} on exit or stop command", new Object[]{this.field_34411.getId(), this.field_34411.getName(), this.field_34411.getDestination()});
        return true;
    }

    private void method_38660() {
        FlightRecorder.addListener(new FlightRecorderListener(){
            final class_6507 field_34921 = new class_6507(() -> {
                class_6505.this.field_34411 = null;
            });

            @Override
            public void recordingStateChanged(Recording $$0) {
                if ($$0 != class_6505.this.field_34411 || $$0.getState() != RecordingState.STOPPED) {
                    return;
                }
                this.field_34921.method_38663($$0.getDestination());
                FlightRecorder.removeListener(this);
            }
        });
    }

    @Override
    public void method_38654(float $$0) {
        if (ServerTickTimeEvent.TYPE.isEnabled()) {
            this.field_35577 = $$0;
        }
    }

    @Override
    public void method_38656(int $$0, int $$1, SocketAddress $$2, int $$3) {
        if (PacketReceivedEvent.TYPE.isEnabled()) {
            new PacketReceivedEvent($$0, $$1, $$2, $$3).commit();
        }
        if (NetworkSummaryEvent.TYPE.isEnabled()) {
            this.method_39429($$2).method_39496($$3);
        }
    }

    @Override
    public void method_38657(int $$0, int $$1, SocketAddress $$2, int $$3) {
        if (PacketSentEvent.TYPE.isEnabled()) {
            new PacketSentEvent($$0, $$1, $$2, $$3).commit();
        }
        if (NetworkSummaryEvent.TYPE.isEnabled()) {
            this.method_39429($$2).method_39495($$3);
        }
    }

    private NetworkSummaryEvent.class_6779 method_39429(SocketAddress $$0) {
        return this.field_35578.computeIfAbsent($$0.toString(), NetworkSummaryEvent.class_6779::new);
    }

    @Override
    @Nullable
    public class_6613 method_38659() {
        if (!WorldLoadFinishedEvent.TYPE.isEnabled()) {
            return null;
        }
        WorldLoadFinishedEvent $$0 = new WorldLoadFinishedEvent();
        $$0.begin();
        return $$0::commit;
    }

    @Override
    @Nullable
    public class_6613 method_38655(class_1923 $$0, class_5321<class_1937> $$1, String $$2) {
        if (!ChunkGenerationEvent.TYPE.isEnabled()) {
            return null;
        }
        ChunkGenerationEvent $$3 = new ChunkGenerationEvent($$0, $$1, $$2);
        $$3.begin();
        return $$3::commit;
    }
}

