/*
 * Decompiled with CFR 0.152.
 */
package com.command_block.libraryferret.utils;

import java.util.Arrays;

public interface Color {
    public static final int INVISIBLE = Color.toHex(0, 0, 0, 0);
    public static final int BLACK = Color.toHex(0, 0, 0, 255);
    public static final int DARK_BLUE = Color.toHex(0, 0, 170, 255);
    public static final int DARK_GREEN = Color.toHex(0, 170, 0, 255);
    public static final int DARK_AQUA = Color.toHex(0, 170, 170, 255);
    public static final int DARK_RED = Color.toHex(170, 0, 0, 255);
    public static final int DARK_PURPLE = Color.toHex(170, 0, 170, 255);
    public static final int GOLD = Color.toHex(255, 180, 100, 255);
    public static final int GRAY = Color.toHex(170, 170, 170, 255);
    public static final int DARK_GRAY = Color.toHex(85, 85, 85, 255);
    public static final int BLUE = Color.toHex(85, 85, 255, 255);
    public static final int GREEN = Color.toHex(85, 255, 85, 255);
    public static final int AQUA = Color.toHex(85, 255, 255, 255);
    public static final int LIGHT_PURPLE = Color.toHex(255, 85, 255, 255);
    public static final int RED = Color.toHex(255, 85, 85, 255);
    public static final int YELLOW = Color.toHex(255, 255, 85, 255);
    public static final int WHITE = Color.toHex(255, 255, 255, 255);

    public static int formattingToHex(String colorName) {
        if (colorName == null) {
            return BLACK;
        }
        switch (colorName.toUpperCase().trim()) {
            case "DARK_BLUE": {
                return DARK_BLUE;
            }
            case "DARK_GREEN": {
                return DARK_GREEN;
            }
            case "DARK_AQUA": {
                return DARK_AQUA;
            }
            case "DARK_RED": {
                return DARK_RED;
            }
            case "DARK_PURPLE": {
                return DARK_PURPLE;
            }
            case "GOLD": {
                return GOLD;
            }
            case "GRAY": {
                return GRAY;
            }
            case "DARK_GRAY": {
                return DARK_GRAY;
            }
            case "BLUE": {
                return BLUE;
            }
            case "GREEN": {
                return GREEN;
            }
            case "AQUA": {
                return AQUA;
            }
            case "RED": {
                return RED;
            }
            case "LIGHT_PURPLE": {
                return LIGHT_PURPLE;
            }
            case "YELLOW": {
                return YELLOW;
            }
            case "WHITE": {
                return WHITE;
            }
        }
        return BLACK;
    }

    public static int toHex(int[] RGBA) {
        return RGBA.length == 4 ? Color.toHex(RGBA[0], RGBA[1], RGBA[2], RGBA[3]) : (RGBA.length == 3 ? Color.toHex(RGBA[0], RGBA[1], RGBA[2], 255) : (RGBA.length == 2 ? Color.toHex(RGBA[0], RGBA[1], 0, 255) : (RGBA.length == 1 ? Color.toHex(RGBA[0], 0, 0, 255) : Color.toHex(0, 0, 0, 255))));
    }

    public static int toHex(int red, int green, int blue, int alpha) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static int toHex(String RGBA) {
        return Color.toHex(Color.toRGBA(RGBA));
    }

    public static int[] toRGBA(String RGBA) {
        if (Color.isRGBorRGBA(RGBA)) {
            int[] nArray;
            int[] data;
            try {
                data = Arrays.stream(RGBA.replaceAll("\\s+", "").toLowerCase().replaceFirst("^rgb\\(|^rgba\\(", "").replaceFirst("\\)", "").split(",")).mapToInt(Integer::parseInt).toArray();
            }
            catch (Exception var3) {
                return new int[]{0, 0, 0, 255};
            }
            if (data.length == 4) {
                return new int[]{data[0], data[1], data[2], data[3]};
            }
            if (data.length == 3) {
                return new int[]{data[0], data[1], data[2], 255};
            }
            if (data.length == 2) {
                return new int[]{data[0], data[1], 0, 255};
            }
            if (data.length == 1) {
                int[] nArray2 = new int[4];
                nArray2[0] = data[0];
                nArray2[1] = 0;
                nArray2[2] = 0;
                nArray = nArray2;
                nArray2[3] = 255;
            } else {
                int[] nArray3 = new int[4];
                nArray3[0] = 0;
                nArray3[1] = 0;
                nArray3[2] = 0;
                nArray = nArray3;
                nArray3[3] = 255;
            }
            return nArray;
        }
        return new int[]{0, 0, 0, 255};
    }

    public static boolean isRGBorRGBA(String entry) {
        return entry.contains("rgba") || entry.contains("rgb");
    }

    public static String toString(int[] RGBA) {
        return RGBA.length == 4 ? Color.toString(RGBA[0], RGBA[1], RGBA[2], RGBA[3]) : (RGBA.length == 3 ? Color.toString(RGBA[0], RGBA[1], RGBA[2], 255) : (RGBA.length == 2 ? Color.toString(RGBA[0], RGBA[1], 0, 255) : (RGBA.length == 1 ? Color.toString(RGBA[0], 0, 0, 255) : "rgba(0, 0, 0, 255)")));
    }

    public static String toString(int red, int green, int blue) {
        return Color.toString(red, green, blue, 255);
    }

    public static String toString(int red, int green, int blue, int alpha) {
        return "rgba(" + red + ", " + green + ", " + blue + ", " + alpha + ")";
    }
}

