/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsbridges.world.feature;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.yungsbridges.YungsBridgesCommon;
import com.yungnickyoung.minecraft.yungsbridges.world.processor.ITemplateFeatureProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_5281;
import net.minecraft.class_5425;

public abstract class AbstractTemplateFeature<C extends class_3037>
extends class_3031<C> {
    protected List<ITemplateFeatureProcessor> processors = this.useProcessors();

    public AbstractTemplateFeature(Codec<C> codec) {
        super(codec);
    }

    protected class_3499 createTemplate(class_2960 id, class_5281 level, Random rand, class_2338 pos) {
        return this.createTemplateWithPlacement(id, level, rand, pos, new class_3492());
    }

    protected class_3499 createTemplateWithPlacement(class_2960 id, class_5281 level, Random rand, class_2338 cornerPos, class_3492 placement) {
        Optional templateOptional = level.method_8410().method_14183().method_15094(id);
        if (templateOptional.isEmpty()) {
            YungsBridgesCommon.LOGGER.warn("Failed to create invalid feature {}", (Object)id);
            return null;
        }
        class_3499 template = (class_3499)templateOptional.get();
        class_2338 centerPos = cornerPos.method_10069(template.method_15160().method_10263() / 2, 0, template.method_15160().method_10260() / 2);
        template.method_15172((class_5425)level, cornerPos, centerPos, placement, rand, 2);
        this.processors.forEach(processor -> processor.processTemplate(template, level, rand, cornerPos, centerPos, placement));
        return template;
    }

    protected List<ITemplateFeatureProcessor> useProcessors() {
        return new ArrayList<ITemplateFeatureProcessor>();
    }
}

