/*
 * Decompiled with CFR 0.152.
 */
package io.github.ladysnake.pal.impl;

import com.google.common.base.Preconditions;
import io.github.ladysnake.pal.AbilitySource;
import io.github.ladysnake.pal.AbilityTracker;
import io.github.ladysnake.pal.PlayerAbility;
import io.github.ladysnake.pal.PlayerAbilityUpdatedCallback;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public final class PalInternals {
    public static final Logger LOGGER = LogManager.getLogger((String)"PlayerAbilityLib");
    private static final Map<class_2960, PlayerAbility> abilities = new HashMap<class_2960, PlayerAbility>();
    private static final Map<class_2960, AbilitySource> sources = new HashMap<class_2960, AbilitySource>();

    public static void populate(class_1657 player, Map<PlayerAbility, AbilityTracker> map) {
        for (PlayerAbility ability : abilities.values()) {
            map.put(ability, ability.createTracker(player));
        }
    }

    @Contract(value="null -> null; !null -> _")
    @Nullable
    public static PlayerAbility getAbility(@Nullable class_2960 id) {
        return abilities.get(id);
    }

    public static synchronized PlayerAbility registerAbility(PlayerAbility ability) {
        if (abilities.containsKey(ability.getId())) {
            throw new IllegalStateException("An ability was already registered with the id " + ability);
        }
        abilities.put(ability.getId(), ability);
        return ability;
    }

    public static AbilitySource getSource(@Nullable class_2960 sourceId) {
        return sources.get(sourceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AbilitySource registerSource(class_2960 sourceId, @Nullable Integer priority, BiFunction<class_2960, Integer, AbilitySource> factory) {
        Preconditions.checkNotNull((Object)sourceId);
        AbilitySource existing = sources.get(sourceId);
        if (existing == null) {
            Map<class_2960, AbilitySource> map = sources;
            synchronized (map) {
                existing = sources.get(sourceId);
                if (existing == null) {
                    AbilitySource source = factory.apply(sourceId, priority == null ? 0 : priority);
                    sources.put(sourceId, source);
                    return source;
                }
            }
        }
        if (priority != null && existing.getPriority() != priority.intValue()) {
            throw new IllegalStateException(sourceId + " has been registered twice with differing priorities: " + existing.getPriority() + ", " + priority);
        }
        return existing;
    }

    public static boolean isAbilityRegistered(class_2960 abilityId) {
        return abilityId != null && abilities.containsKey(abilityId);
    }

    public static Event<PlayerAbilityUpdatedCallback> createUpdateEvent() {
        return EventFactory.createArrayBacked(PlayerAbilityUpdatedCallback.class, listeners -> (player, nowEnabled) -> {
            for (PlayerAbilityUpdatedCallback listener : listeners) {
                listener.onAbilityUpdated(player, nowEnabled);
            }
        });
    }
}

