/*
 * Decompiled with CFR 0.152.
 */
package dev.stashy.extrasounds.debug;

import dev.stashy.extrasounds.mapping.SoundPackLoader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Collectors;
import net.minecraft.class_1291;
import net.minecraft.class_3414;
import net.minecraft.class_4081;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DebugUtils {
    public static final String debugVar = "extrasounds.debug";
    public static final String debugPathVar = "extrasounds.debug.path";
    public static final String noCacheVar = "extrasounds.nocache";
    public static final boolean debug = System.getProperties().containsKey("extrasounds.debug") && System.getProperty("extrasounds.debug").equals("true");
    public static final String debugPath = System.getProperties().containsKey("extrasounds.debug.path") ? System.getProperty("extrasounds.debug.path") : "debug/";
    public static final boolean noCache = System.getProperties().containsKey("extrasounds.nocache") && System.getProperties().get("extrasounds.nocache").equals("true");
    private static final Logger LOGGER = LogManager.getLogger();

    public static void init() {
        if (!debug) {
            return;
        }
        LOGGER.info("ExtraSounds: DEBUG mode enabled.");
        LOGGER.info("Debug path: " + Path.of(debugPath, new String[0]).toAbsolutePath());
    }

    public static void exportSoundsJson(byte[] jsonData) {
        if (!debug) {
            return;
        }
        try {
            Path p = Path.of(debugPath, new String[0]).resolve("sounds.json");
            DebugUtils.createFile(p);
            Files.write(p, jsonData, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void exportGenerators() {
        if (!debug) {
            return;
        }
        Path p = Path.of(debugPath, new String[0]).resolve("generators.txt");
        DebugUtils.createFile(p);
        try {
            Files.write(p, (Iterable<? extends CharSequence>)SoundPackLoader.mappers.keySet().stream().map(it -> {
                Class<?> clazz = SoundPackLoader.mappers.get(it).itemSoundGenerator().getClass();
                return "namespace: " + it + "; class: " + (clazz == null ? "none" : clazz.getName());
            }).collect(Collectors.toList()), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void soundLog(class_3414 snd) {
        if (!debug) {
            return;
        }
        LOGGER.info("Playing sound: " + snd.method_14833());
    }

    public static void effectLog(class_1291 effect, boolean add) {
        if (!debug) {
            return;
        }
        boolean positive = !effect.method_18792().equals((Object)class_4081.field_18272);
        LOGGER.info((positive ? "Positive" : "Negative") + " effect " + (add ? "added" : "removed") + ": " + effect.method_5560().getString());
    }

    public static void genericLog(String message) {
        if (!debug) {
            return;
        }
        LOGGER.info(message);
    }

    private static void createFile(Path p) {
        try {
            if (!Files.isDirectory(Path.of(debugPath, new String[0]), new LinkOption[0])) {
                Files.createDirectory(Path.of(debugPath, new String[0]), new FileAttribute[0]);
            }
            if (!Files.exists(p, new LinkOption[0])) {
                Files.createFile(p, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            LOGGER.error("Unable to create file: " + p);
            e.printStackTrace();
        }
    }
}

