/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.vendored.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.text.NumberFormat;
import net.coderbot.iris.vendored.joml.Math;
import net.coderbot.iris.vendored.joml.Matrix4fc;
import net.coderbot.iris.vendored.joml.Matrix4x3fc;
import net.coderbot.iris.vendored.joml.MemUtil;
import net.coderbot.iris.vendored.joml.Options;
import net.coderbot.iris.vendored.joml.Quaternionfc;
import net.coderbot.iris.vendored.joml.Runtime;
import net.coderbot.iris.vendored.joml.Vector2fc;
import net.coderbot.iris.vendored.joml.Vector2ic;
import net.coderbot.iris.vendored.joml.Vector3f;
import net.coderbot.iris.vendored.joml.Vector3fc;
import net.coderbot.iris.vendored.joml.Vector3ic;
import net.coderbot.iris.vendored.joml.Vector4d;
import net.coderbot.iris.vendored.joml.Vector4dc;
import net.coderbot.iris.vendored.joml.Vector4fc;
import net.coderbot.iris.vendored.joml.Vector4i;
import net.coderbot.iris.vendored.joml.Vector4ic;

public class Vector4f
implements Externalizable,
Cloneable,
Vector4fc {
    private static final long serialVersionUID = 1L;
    public float x;
    public float y;
    public float z;
    public float w;

    public Vector4f() {
        this.w = 1.0f;
    }

    public Vector4f(Vector4fc vector4fc) {
        this.x = vector4fc.x();
        this.y = vector4fc.y();
        this.z = vector4fc.z();
        this.w = vector4fc.w();
    }

    public Vector4f(Vector4ic vector4ic) {
        this.x = vector4ic.x();
        this.y = vector4ic.y();
        this.z = vector4ic.z();
        this.w = vector4ic.w();
    }

    public Vector4f(Vector3fc vector3fc, float f) {
        this.x = vector3fc.x();
        this.y = vector3fc.y();
        this.z = vector3fc.z();
        this.w = f;
    }

    public Vector4f(Vector3ic vector3ic, float f) {
        this.x = vector3ic.x();
        this.y = vector3ic.y();
        this.z = vector3ic.z();
        this.w = f;
    }

    public Vector4f(Vector2fc vector2fc, float f, float f2) {
        this.x = vector2fc.x();
        this.y = vector2fc.y();
        this.z = f;
        this.w = f2;
    }

    public Vector4f(Vector2ic vector2ic, float f, float f2) {
        this.x = vector2ic.x();
        this.y = vector2ic.y();
        this.z = f;
        this.w = f2;
    }

    public Vector4f(float f) {
        this.x = f;
        this.y = f;
        this.z = f;
        this.w = f;
    }

    public Vector4f(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.z = f3;
        this.w = f4;
    }

    public Vector4f(float[] fArray) {
        this.x = fArray[0];
        this.y = fArray[1];
        this.z = fArray[2];
        this.w = fArray[3];
    }

    public Vector4f(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
    }

    public Vector4f(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n, byteBuffer);
    }

    public Vector4f(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.get(this, floatBuffer.position(), floatBuffer);
    }

    public Vector4f(int n, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.get(this, n, floatBuffer);
    }

    @Override
    public float x() {
        return this.x;
    }

    @Override
    public float y() {
        return this.y;
    }

    @Override
    public float z() {
        return this.z;
    }

    @Override
    public float w() {
        return this.w;
    }

    public Vector4f set(Vector4fc vector4fc) {
        this.x = vector4fc.x();
        this.y = vector4fc.y();
        this.z = vector4fc.z();
        this.w = vector4fc.w();
        return this;
    }

    public Vector4f set(Vector4ic vector4ic) {
        this.x = vector4ic.x();
        this.y = vector4ic.y();
        this.z = vector4ic.z();
        this.w = vector4ic.w();
        return this;
    }

    public Vector4f set(Vector4dc vector4dc) {
        this.x = (float)vector4dc.x();
        this.y = (float)vector4dc.y();
        this.z = (float)vector4dc.z();
        this.w = (float)vector4dc.w();
        return this;
    }

    public Vector4f set(Vector3fc vector3fc, float f) {
        this.x = vector3fc.x();
        this.y = vector3fc.y();
        this.z = vector3fc.z();
        this.w = f;
        return this;
    }

    public Vector4f set(Vector3ic vector3ic, float f) {
        this.x = vector3ic.x();
        this.y = vector3ic.y();
        this.z = vector3ic.z();
        this.w = f;
        return this;
    }

    public Vector4f set(Vector2fc vector2fc, float f, float f2) {
        this.x = vector2fc.x();
        this.y = vector2fc.y();
        this.z = f;
        this.w = f2;
        return this;
    }

    public Vector4f set(Vector2ic vector2ic, float f, float f2) {
        this.x = vector2ic.x();
        this.y = vector2ic.y();
        this.z = f;
        this.w = f2;
        return this;
    }

    public Vector4f set(float f) {
        this.x = f;
        this.y = f;
        this.z = f;
        this.w = f;
        return this;
    }

    public Vector4f set(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.z = f3;
        this.w = f4;
        return this;
    }

    public Vector4f set(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
        return this;
    }

    public Vector4f set(double d) {
        this.x = (float)d;
        this.y = (float)d;
        this.z = (float)d;
        this.w = (float)d;
        return this;
    }

    public Vector4f set(double d, double d2, double d3, double d4) {
        this.x = (float)d;
        this.y = (float)d2;
        this.z = (float)d3;
        this.w = (float)d4;
        return this;
    }

    public Vector4f set(float[] fArray) {
        this.x = fArray[0];
        this.y = fArray[1];
        this.z = fArray[2];
        this.w = fArray[3];
        return this;
    }

    public Vector4f set(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
        return this;
    }

    public Vector4f set(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n, byteBuffer);
        return this;
    }

    public Vector4f set(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.get(this, floatBuffer.position(), floatBuffer);
        return this;
    }

    public Vector4f set(int n, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.get(this, n, floatBuffer);
        return this;
    }

    public Vector4f setComponent(int n, float f) throws IllegalArgumentException {
        switch (n) {
            case 0: {
                this.x = f;
                break;
            }
            case 1: {
                this.y = f;
                break;
            }
            case 2: {
                this.z = f;
                break;
            }
            case 3: {
                this.w = f;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this;
    }

    @Override
    public FloatBuffer get(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.put(this, floatBuffer.position(), floatBuffer);
        return floatBuffer;
    }

    @Override
    public FloatBuffer get(int n, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.put(this, n, floatBuffer);
        return floatBuffer;
    }

    @Override
    public ByteBuffer get(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, byteBuffer.position(), byteBuffer);
        return byteBuffer;
    }

    @Override
    public ByteBuffer get(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, n, byteBuffer);
        return byteBuffer;
    }

    public Vector4f sub(Vector4fc vector4fc) {
        this.x -= vector4fc.x();
        this.y -= vector4fc.y();
        this.z -= vector4fc.z();
        this.w -= vector4fc.w();
        return this;
    }

    public Vector4f sub(float f, float f2, float f3, float f4) {
        this.x -= f;
        this.y -= f2;
        this.z -= f3;
        this.w -= f4;
        return this;
    }

    @Override
    public Vector4f sub(Vector4fc vector4fc, Vector4f vector4f) {
        vector4f.x = this.x - vector4fc.x();
        vector4f.y = this.y - vector4fc.y();
        vector4f.z = this.z - vector4fc.z();
        vector4f.w = this.w - vector4fc.w();
        return vector4f;
    }

    @Override
    public Vector4f sub(float f, float f2, float f3, float f4, Vector4f vector4f) {
        vector4f.x = this.x - f;
        vector4f.y = this.y - f2;
        vector4f.z = this.z - f3;
        vector4f.w = this.w - f4;
        return vector4f;
    }

    public Vector4f add(Vector4fc vector4fc) {
        this.x += vector4fc.x();
        this.y += vector4fc.y();
        this.z += vector4fc.z();
        this.w += vector4fc.w();
        return this;
    }

    @Override
    public Vector4f add(Vector4fc vector4fc, Vector4f vector4f) {
        vector4f.x = this.x + vector4fc.x();
        vector4f.y = this.y + vector4fc.y();
        vector4f.z = this.z + vector4fc.z();
        vector4f.w = this.w + vector4fc.w();
        return vector4f;
    }

    public Vector4f add(float f, float f2, float f3, float f4) {
        this.x += f;
        this.y += f2;
        this.z += f3;
        this.w += f4;
        return this;
    }

    @Override
    public Vector4f add(float f, float f2, float f3, float f4, Vector4f vector4f) {
        vector4f.x = this.x + f;
        vector4f.y = this.y + f2;
        vector4f.z = this.z + f3;
        vector4f.w = this.w + f4;
        return vector4f;
    }

    public Vector4f fma(Vector4fc vector4fc, Vector4fc vector4fc2) {
        this.x = Math.fma(vector4fc.x(), vector4fc2.x(), this.x);
        this.y = Math.fma(vector4fc.y(), vector4fc2.y(), this.y);
        this.z = Math.fma(vector4fc.z(), vector4fc2.z(), this.z);
        this.w = Math.fma(vector4fc.w(), vector4fc2.w(), this.w);
        return this;
    }

    public Vector4f fma(float f, Vector4fc vector4fc) {
        this.x = Math.fma(f, vector4fc.x(), this.x);
        this.y = Math.fma(f, vector4fc.y(), this.y);
        this.z = Math.fma(f, vector4fc.z(), this.z);
        this.w = Math.fma(f, vector4fc.w(), this.w);
        return this;
    }

    @Override
    public Vector4f fma(Vector4fc vector4fc, Vector4fc vector4fc2, Vector4f vector4f) {
        vector4f.x = Math.fma(vector4fc.x(), vector4fc2.x(), this.x);
        vector4f.y = Math.fma(vector4fc.y(), vector4fc2.y(), this.y);
        vector4f.z = Math.fma(vector4fc.z(), vector4fc2.z(), this.z);
        vector4f.w = Math.fma(vector4fc.w(), vector4fc2.w(), this.w);
        return vector4f;
    }

    @Override
    public Vector4f fma(float f, Vector4fc vector4fc, Vector4f vector4f) {
        vector4f.x = Math.fma(f, vector4fc.x(), this.x);
        vector4f.y = Math.fma(f, vector4fc.y(), this.y);
        vector4f.z = Math.fma(f, vector4fc.z(), this.z);
        vector4f.w = Math.fma(f, vector4fc.w(), this.w);
        return vector4f;
    }

    public Vector4f mulAdd(Vector4fc vector4fc, Vector4fc vector4fc2) {
        this.x = Math.fma(this.x, vector4fc.x(), vector4fc2.x());
        this.y = Math.fma(this.y, vector4fc.y(), vector4fc2.y());
        this.z = Math.fma(this.z, vector4fc.z(), vector4fc2.z());
        return this;
    }

    public Vector4f mulAdd(float f, Vector4fc vector4fc) {
        this.x = Math.fma(this.x, f, vector4fc.x());
        this.y = Math.fma(this.y, f, vector4fc.y());
        this.z = Math.fma(this.z, f, vector4fc.z());
        return this;
    }

    @Override
    public Vector4f mulAdd(Vector4fc vector4fc, Vector4fc vector4fc2, Vector4f vector4f) {
        vector4f.x = Math.fma(this.x, vector4fc.x(), vector4fc2.x());
        vector4f.y = Math.fma(this.y, vector4fc.y(), vector4fc2.y());
        vector4f.z = Math.fma(this.z, vector4fc.z(), vector4fc2.z());
        return vector4f;
    }

    @Override
    public Vector4f mulAdd(float f, Vector4fc vector4fc, Vector4f vector4f) {
        vector4f.x = Math.fma(this.x, f, vector4fc.x());
        vector4f.y = Math.fma(this.y, f, vector4fc.y());
        vector4f.z = Math.fma(this.z, f, vector4fc.z());
        return vector4f;
    }

    public Vector4f mul(Vector4fc vector4fc) {
        this.x *= vector4fc.x();
        this.y *= vector4fc.y();
        this.z *= vector4fc.z();
        this.w *= vector4fc.w();
        return this;
    }

    @Override
    public Vector4f mul(Vector4fc vector4fc, Vector4f vector4f) {
        vector4f.x = this.x * vector4fc.x();
        vector4f.y = this.y * vector4fc.y();
        vector4f.z = this.z * vector4fc.z();
        vector4f.w = this.w * vector4fc.w();
        return vector4f;
    }

    public Vector4f div(Vector4fc vector4fc) {
        this.x /= vector4fc.x();
        this.y /= vector4fc.y();
        this.z /= vector4fc.z();
        this.w /= vector4fc.w();
        return this;
    }

    @Override
    public Vector4f div(Vector4fc vector4fc, Vector4f vector4f) {
        vector4f.x = this.x / vector4fc.x();
        vector4f.y = this.y / vector4fc.y();
        vector4f.z = this.z / vector4fc.z();
        vector4f.w = this.w / vector4fc.w();
        return vector4f;
    }

    public Vector4f mul(Matrix4fc matrix4fc) {
        if ((matrix4fc.properties() & 2) != 0) {
            return this.mulAffine(matrix4fc, this);
        }
        return this.mulGeneric(matrix4fc, this);
    }

    @Override
    public Vector4f mul(Matrix4fc matrix4fc, Vector4f vector4f) {
        if ((matrix4fc.properties() & 2) != 0) {
            return this.mulAffine(matrix4fc, vector4f);
        }
        return this.mulGeneric(matrix4fc, vector4f);
    }

    public Vector4f mulTranspose(Matrix4fc matrix4fc) {
        if ((matrix4fc.properties() & 2) != 0) {
            return this.mulAffineTranspose(matrix4fc, this);
        }
        return this.mulGenericTranspose(matrix4fc, this);
    }

    @Override
    public Vector4f mulTranspose(Matrix4fc matrix4fc, Vector4f vector4f) {
        if ((matrix4fc.properties() & 2) != 0) {
            return this.mulAffineTranspose(matrix4fc, vector4f);
        }
        return this.mulGenericTranspose(matrix4fc, vector4f);
    }

    @Override
    public Vector4f mulAffine(Matrix4fc matrix4fc, Vector4f vector4f) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        float f4 = this.w;
        vector4f.x = Math.fma(matrix4fc.m00(), f, Math.fma(matrix4fc.m10(), f2, Math.fma(matrix4fc.m20(), f3, matrix4fc.m30() * f4)));
        vector4f.y = Math.fma(matrix4fc.m01(), f, Math.fma(matrix4fc.m11(), f2, Math.fma(matrix4fc.m21(), f3, matrix4fc.m31() * f4)));
        vector4f.z = Math.fma(matrix4fc.m02(), f, Math.fma(matrix4fc.m12(), f2, Math.fma(matrix4fc.m22(), f3, matrix4fc.m32() * f4)));
        vector4f.w = f4;
        return vector4f;
    }

    private Vector4f mulGeneric(Matrix4fc matrix4fc, Vector4f vector4f) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        float f4 = this.w;
        vector4f.x = Math.fma(matrix4fc.m00(), f, Math.fma(matrix4fc.m10(), f2, Math.fma(matrix4fc.m20(), f3, matrix4fc.m30() * f4)));
        vector4f.y = Math.fma(matrix4fc.m01(), f, Math.fma(matrix4fc.m11(), f2, Math.fma(matrix4fc.m21(), f3, matrix4fc.m31() * f4)));
        vector4f.z = Math.fma(matrix4fc.m02(), f, Math.fma(matrix4fc.m12(), f2, Math.fma(matrix4fc.m22(), f3, matrix4fc.m32() * f4)));
        vector4f.w = Math.fma(matrix4fc.m03(), f, Math.fma(matrix4fc.m13(), f2, Math.fma(matrix4fc.m23(), f3, matrix4fc.m33() * f4)));
        return vector4f;
    }

    @Override
    public Vector4f mulAffineTranspose(Matrix4fc matrix4fc, Vector4f vector4f) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        float f4 = this.w;
        vector4f.x = Math.fma(matrix4fc.m00(), f, Math.fma(matrix4fc.m01(), f2, matrix4fc.m02() * f3));
        vector4f.y = Math.fma(matrix4fc.m10(), f, Math.fma(matrix4fc.m11(), f2, matrix4fc.m12() * f3));
        vector4f.z = Math.fma(matrix4fc.m20(), f, Math.fma(matrix4fc.m21(), f2, matrix4fc.m22() * f3));
        vector4f.w = Math.fma(matrix4fc.m30(), f, Math.fma(matrix4fc.m31(), f2, matrix4fc.m32() * f3 + f4));
        return vector4f;
    }

    private Vector4f mulGenericTranspose(Matrix4fc matrix4fc, Vector4f vector4f) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        float f4 = this.w;
        vector4f.x = Math.fma(matrix4fc.m00(), f, Math.fma(matrix4fc.m01(), f2, Math.fma(matrix4fc.m02(), f3, matrix4fc.m03() * f4)));
        vector4f.y = Math.fma(matrix4fc.m10(), f, Math.fma(matrix4fc.m11(), f2, Math.fma(matrix4fc.m12(), f3, matrix4fc.m13() * f4)));
        vector4f.z = Math.fma(matrix4fc.m20(), f, Math.fma(matrix4fc.m21(), f2, Math.fma(matrix4fc.m22(), f3, matrix4fc.m23() * f4)));
        vector4f.w = Math.fma(matrix4fc.m30(), f, Math.fma(matrix4fc.m31(), f2, Math.fma(matrix4fc.m32(), f3, matrix4fc.m33() * f4)));
        return vector4f;
    }

    public Vector4f mul(Matrix4x3fc matrix4x3fc) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        float f4 = this.w;
        this.x = Math.fma(matrix4x3fc.m00(), f, Math.fma(matrix4x3fc.m10(), f2, Math.fma(matrix4x3fc.m20(), f3, matrix4x3fc.m30() * f4)));
        this.y = Math.fma(matrix4x3fc.m01(), f, Math.fma(matrix4x3fc.m11(), f2, Math.fma(matrix4x3fc.m21(), f3, matrix4x3fc.m31() * f4)));
        this.z = Math.fma(matrix4x3fc.m02(), f, Math.fma(matrix4x3fc.m12(), f2, Math.fma(matrix4x3fc.m22(), f3, matrix4x3fc.m32() * f4)));
        this.w = f4;
        return this;
    }

    @Override
    public Vector4f mul(Matrix4x3fc matrix4x3fc, Vector4f vector4f) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        float f4 = this.w;
        vector4f.x = Math.fma(matrix4x3fc.m00(), f, Math.fma(matrix4x3fc.m10(), f2, Math.fma(matrix4x3fc.m20(), f3, matrix4x3fc.m30() * f4)));
        vector4f.y = Math.fma(matrix4x3fc.m01(), f, Math.fma(matrix4x3fc.m11(), f2, Math.fma(matrix4x3fc.m21(), f3, matrix4x3fc.m31() * f4)));
        vector4f.z = Math.fma(matrix4x3fc.m02(), f, Math.fma(matrix4x3fc.m12(), f2, Math.fma(matrix4x3fc.m22(), f3, matrix4x3fc.m32() * f4)));
        vector4f.w = f4;
        return vector4f;
    }

    @Override
    public Vector4f mulProject(Matrix4fc matrix4fc, Vector4f vector4f) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        float f4 = this.w;
        float f5 = 1.0f / Math.fma(matrix4fc.m03(), f, Math.fma(matrix4fc.m13(), f2, Math.fma(matrix4fc.m23(), f3, matrix4fc.m33() * f4)));
        vector4f.x = Math.fma(matrix4fc.m00(), f, Math.fma(matrix4fc.m10(), f2, Math.fma(matrix4fc.m20(), f3, matrix4fc.m30() * f4))) * f5;
        vector4f.y = Math.fma(matrix4fc.m01(), f, Math.fma(matrix4fc.m11(), f2, Math.fma(matrix4fc.m21(), f3, matrix4fc.m31() * f4))) * f5;
        vector4f.z = Math.fma(matrix4fc.m02(), f, Math.fma(matrix4fc.m12(), f2, Math.fma(matrix4fc.m22(), f3, matrix4fc.m32() * f4))) * f5;
        vector4f.w = 1.0f;
        return vector4f;
    }

    public Vector4f mulProject(Matrix4fc matrix4fc) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        float f4 = this.w;
        float f5 = 1.0f / Math.fma(matrix4fc.m03(), f, Math.fma(matrix4fc.m13(), f2, Math.fma(matrix4fc.m23(), f3, matrix4fc.m33() * f4)));
        this.x = Math.fma(matrix4fc.m00(), f, Math.fma(matrix4fc.m10(), f2, Math.fma(matrix4fc.m20(), f3, matrix4fc.m30() * f4))) * f5;
        this.y = Math.fma(matrix4fc.m01(), f, Math.fma(matrix4fc.m11(), f2, Math.fma(matrix4fc.m21(), f3, matrix4fc.m31() * f4))) * f5;
        this.z = Math.fma(matrix4fc.m02(), f, Math.fma(matrix4fc.m12(), f2, Math.fma(matrix4fc.m22(), f3, matrix4fc.m32() * f4))) * f5;
        this.w = 1.0f;
        return this;
    }

    @Override
    public Vector3f mulProject(Matrix4fc matrix4fc, Vector3f vector3f) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        float f4 = this.w;
        float f5 = 1.0f / Math.fma(matrix4fc.m03(), f, Math.fma(matrix4fc.m13(), f2, Math.fma(matrix4fc.m23(), f3, matrix4fc.m33() * f4)));
        vector3f.x = Math.fma(matrix4fc.m00(), f, Math.fma(matrix4fc.m10(), f2, Math.fma(matrix4fc.m20(), f3, matrix4fc.m30() * f4))) * f5;
        vector3f.y = Math.fma(matrix4fc.m01(), f, Math.fma(matrix4fc.m11(), f2, Math.fma(matrix4fc.m21(), f3, matrix4fc.m31() * f4))) * f5;
        vector3f.z = Math.fma(matrix4fc.m02(), f, Math.fma(matrix4fc.m12(), f2, Math.fma(matrix4fc.m22(), f3, matrix4fc.m32() * f4))) * f5;
        return vector3f;
    }

    public Vector4f mul(float f) {
        this.x *= f;
        this.y *= f;
        this.z *= f;
        this.w *= f;
        return this;
    }

    @Override
    public Vector4f mul(float f, Vector4f vector4f) {
        vector4f.x = this.x * f;
        vector4f.y = this.y * f;
        vector4f.z = this.z * f;
        vector4f.w = this.w * f;
        return vector4f;
    }

    public Vector4f mul(float f, float f2, float f3, float f4) {
        this.x *= f;
        this.y *= f2;
        this.z *= f3;
        this.w *= f4;
        return this;
    }

    @Override
    public Vector4f mul(float f, float f2, float f3, float f4, Vector4f vector4f) {
        vector4f.x = this.x * f;
        vector4f.y = this.y * f2;
        vector4f.z = this.z * f3;
        vector4f.w = this.w * f4;
        return vector4f;
    }

    public Vector4f div(float f) {
        float f2 = 1.0f / f;
        this.x *= f2;
        this.y *= f2;
        this.z *= f2;
        this.w *= f2;
        return this;
    }

    @Override
    public Vector4f div(float f, Vector4f vector4f) {
        float f2 = 1.0f / f;
        vector4f.x = this.x * f2;
        vector4f.y = this.y * f2;
        vector4f.z = this.z * f2;
        vector4f.w = this.w * f2;
        return vector4f;
    }

    public Vector4f div(float f, float f2, float f3, float f4) {
        this.x /= f;
        this.y /= f2;
        this.z /= f3;
        this.w /= f4;
        return this;
    }

    @Override
    public Vector4f div(float f, float f2, float f3, float f4, Vector4f vector4f) {
        vector4f.x = this.x / f;
        vector4f.y = this.y / f2;
        vector4f.z = this.z / f3;
        vector4f.w = this.w / f4;
        return vector4f;
    }

    public Vector4f rotate(Quaternionfc quaternionfc) {
        return quaternionfc.transform(this, this);
    }

    @Override
    public Vector4f rotate(Quaternionfc quaternionfc, Vector4f vector4f) {
        return quaternionfc.transform(this, vector4f);
    }

    public Vector4f rotateAbout(float f, float f2, float f3, float f4) {
        if (f3 == 0.0f && f4 == 0.0f && Math.absEqualsOne(f2)) {
            return this.rotateX(f2 * f, this);
        }
        if (f2 == 0.0f && f4 == 0.0f && Math.absEqualsOne(f3)) {
            return this.rotateY(f3 * f, this);
        }
        if (f2 == 0.0f && f3 == 0.0f && Math.absEqualsOne(f4)) {
            return this.rotateZ(f4 * f, this);
        }
        return this.rotateAxisInternal(f, f2, f3, f4, this);
    }

    @Override
    public Vector4f rotateAxis(float f, float f2, float f3, float f4, Vector4f vector4f) {
        if (f3 == 0.0f && f4 == 0.0f && Math.absEqualsOne(f2)) {
            return this.rotateX(f2 * f, vector4f);
        }
        if (f2 == 0.0f && f4 == 0.0f && Math.absEqualsOne(f3)) {
            return this.rotateY(f3 * f, vector4f);
        }
        if (f2 == 0.0f && f3 == 0.0f && Math.absEqualsOne(f4)) {
            return this.rotateZ(f4 * f, vector4f);
        }
        return this.rotateAxisInternal(f, f2, f3, f4, vector4f);
    }

    private Vector4f rotateAxisInternal(float f, float f2, float f3, float f4, Vector4f vector4f) {
        float f5 = f * 0.5f;
        float f6 = Math.sin(f5);
        float f7 = f2 * f6;
        float f8 = f3 * f6;
        float f9 = f4 * f6;
        float f10 = Math.cosFromSin(f6, f5);
        float f11 = f10 * f10;
        float f12 = f7 * f7;
        float f13 = f8 * f8;
        float f14 = f9 * f9;
        float f15 = f9 * f10;
        float f16 = f7 * f8;
        float f17 = f7 * f9;
        float f18 = f8 * f10;
        float f19 = f8 * f9;
        float f20 = f7 * f10;
        float f21 = this.x;
        float f22 = this.y;
        float f23 = this.z;
        vector4f.x = (f11 + f12 - f14 - f13) * f21 + (-f15 + f16 - f15 + f16) * f22 + (f18 + f17 + f17 + f18) * f23;
        vector4f.y = (f16 + f15 + f15 + f16) * f21 + (f13 - f14 + f11 - f12) * f22 + (f19 + f19 - f20 - f20) * f23;
        vector4f.z = (f17 - f18 + f17 - f18) * f21 + (f19 + f19 + f20 + f20) * f22 + (f14 - f13 - f12 + f11) * f23;
        return vector4f;
    }

    public Vector4f rotateX(float f) {
        float f2 = Math.sin(f);
        float f3 = Math.cosFromSin(f2, f);
        float f4 = this.y * f3 - this.z * f2;
        float f5 = this.y * f2 + this.z * f3;
        this.y = f4;
        this.z = f5;
        return this;
    }

    @Override
    public Vector4f rotateX(float f, Vector4f vector4f) {
        float f2 = Math.sin(f);
        float f3 = Math.cosFromSin(f2, f);
        float f4 = this.y * f3 - this.z * f2;
        float f5 = this.y * f2 + this.z * f3;
        vector4f.x = this.x;
        vector4f.y = f4;
        vector4f.z = f5;
        vector4f.w = this.w;
        return vector4f;
    }

    public Vector4f rotateY(float f) {
        float f2 = Math.sin(f);
        float f3 = Math.cosFromSin(f2, f);
        float f4 = this.x * f3 + this.z * f2;
        float f5 = -this.x * f2 + this.z * f3;
        this.x = f4;
        this.z = f5;
        return this;
    }

    @Override
    public Vector4f rotateY(float f, Vector4f vector4f) {
        float f2 = Math.sin(f);
        float f3 = Math.cosFromSin(f2, f);
        float f4 = this.x * f3 + this.z * f2;
        float f5 = -this.x * f2 + this.z * f3;
        vector4f.x = f4;
        vector4f.y = this.y;
        vector4f.z = f5;
        vector4f.w = this.w;
        return vector4f;
    }

    public Vector4f rotateZ(float f) {
        float f2 = Math.sin(f);
        float f3 = Math.cosFromSin(f2, f);
        float f4 = this.x * f3 - this.y * f2;
        float f5 = this.x * f2 + this.y * f3;
        this.x = f4;
        this.y = f5;
        return this;
    }

    @Override
    public Vector4f rotateZ(float f, Vector4f vector4f) {
        float f2 = Math.sin(f);
        float f3 = Math.cosFromSin(f2, f);
        float f4 = this.x * f3 - this.y * f2;
        float f5 = this.x * f2 + this.y * f3;
        vector4f.x = f4;
        vector4f.y = f5;
        vector4f.z = this.z;
        vector4f.w = this.w;
        return vector4f;
    }

    @Override
    public float lengthSquared() {
        return Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w)));
    }

    public static float lengthSquared(float f, float f2, float f3, float f4) {
        return Math.fma(f, f, Math.fma(f2, f2, Math.fma(f3, f3, f4 * f4)));
    }

    public static float lengthSquared(int n, int n2, int n3, int n4) {
        return Math.fma(n, n, Math.fma(n2, n2, Math.fma(n3, n3, n4 * n4)));
    }

    @Override
    public float length() {
        return Math.sqrt(Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w))));
    }

    public static float length(float f, float f2, float f3, float f4) {
        return Math.sqrt(Math.fma(f, f, Math.fma(f2, f2, Math.fma(f3, f3, f4 * f4))));
    }

    public Vector4f normalize() {
        float f = 1.0f / this.length();
        this.x *= f;
        this.y *= f;
        this.z *= f;
        this.w *= f;
        return this;
    }

    @Override
    public Vector4f normalize(Vector4f vector4f) {
        float f = 1.0f / this.length();
        vector4f.x = this.x * f;
        vector4f.y = this.y * f;
        vector4f.z = this.z * f;
        vector4f.w = this.w * f;
        return vector4f;
    }

    public Vector4f normalize(float f) {
        float f2 = 1.0f / this.length() * f;
        this.x *= f2;
        this.y *= f2;
        this.z *= f2;
        this.w *= f2;
        return this;
    }

    @Override
    public Vector4f normalize(float f, Vector4f vector4f) {
        float f2 = 1.0f / this.length() * f;
        vector4f.x = this.x * f2;
        vector4f.y = this.y * f2;
        vector4f.z = this.z * f2;
        vector4f.w = this.w * f2;
        return vector4f;
    }

    public Vector4f normalize3() {
        float f = Math.invsqrt(Math.fma(this.x, this.x, Math.fma(this.y, this.y, this.z * this.z)));
        this.x *= f;
        this.y *= f;
        this.z *= f;
        this.w *= f;
        return this;
    }

    @Override
    public Vector4f normalize3(Vector4f vector4f) {
        float f = Math.invsqrt(Math.fma(this.x, this.x, Math.fma(this.y, this.y, this.z * this.z)));
        vector4f.x = this.x * f;
        vector4f.y = this.y * f;
        vector4f.z = this.z * f;
        vector4f.w = this.w * f;
        return vector4f;
    }

    @Override
    public float distance(Vector4fc vector4fc) {
        float f = this.x - vector4fc.x();
        float f2 = this.y - vector4fc.y();
        float f3 = this.z - vector4fc.z();
        float f4 = this.w - vector4fc.w();
        return Math.sqrt(Math.fma(f, f, Math.fma(f2, f2, Math.fma(f3, f3, f4 * f4))));
    }

    @Override
    public float distance(float f, float f2, float f3, float f4) {
        float f5 = this.x - f;
        float f6 = this.y - f2;
        float f7 = this.z - f3;
        float f8 = this.w - f4;
        return Math.sqrt(Math.fma(f5, f5, Math.fma(f6, f6, Math.fma(f7, f7, f8 * f8))));
    }

    @Override
    public float distanceSquared(Vector4fc vector4fc) {
        float f = this.x - vector4fc.x();
        float f2 = this.y - vector4fc.y();
        float f3 = this.z - vector4fc.z();
        float f4 = this.w - vector4fc.w();
        return Math.fma(f, f, Math.fma(f2, f2, Math.fma(f3, f3, f4 * f4)));
    }

    @Override
    public float distanceSquared(float f, float f2, float f3, float f4) {
        float f5 = this.x - f;
        float f6 = this.y - f2;
        float f7 = this.z - f3;
        float f8 = this.w - f4;
        return Math.fma(f5, f5, Math.fma(f6, f6, Math.fma(f7, f7, f8 * f8)));
    }

    public static float distance(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float f9 = f - f5;
        float f10 = f2 - f6;
        float f11 = f3 - f7;
        float f12 = f4 - f8;
        return Math.sqrt(Math.fma(f9, f9, Math.fma(f10, f10, Math.fma(f11, f11, f12 * f12))));
    }

    public static float distanceSquared(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float f9 = f - f5;
        float f10 = f2 - f6;
        float f11 = f3 - f7;
        float f12 = f4 - f8;
        return Math.fma(f9, f9, Math.fma(f10, f10, Math.fma(f11, f11, f12 * f12)));
    }

    @Override
    public float dot(Vector4fc vector4fc) {
        return Math.fma(this.x, vector4fc.x(), Math.fma(this.y, vector4fc.y(), Math.fma(this.z, vector4fc.z(), this.w * vector4fc.w())));
    }

    @Override
    public float dot(float f, float f2, float f3, float f4) {
        return Math.fma(this.x, f, Math.fma(this.y, f2, Math.fma(this.z, f3, this.w * f4)));
    }

    @Override
    public float angleCos(Vector4fc vector4fc) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        float f4 = this.w;
        float f5 = Math.fma(f, f, Math.fma(f2, f2, Math.fma(f3, f3, f4 * f4)));
        float f6 = Math.fma(vector4fc.x(), vector4fc.x(), Math.fma(vector4fc.y(), vector4fc.y(), Math.fma(vector4fc.z(), vector4fc.z(), vector4fc.w() * vector4fc.w())));
        float f7 = Math.fma(f, vector4fc.x(), Math.fma(f2, vector4fc.y(), Math.fma(f3, vector4fc.z(), f4 * vector4fc.w())));
        return f7 / Math.sqrt(f5 * f6);
    }

    @Override
    public float angle(Vector4fc vector4fc) {
        float f = this.angleCos(vector4fc);
        f = f < 1.0f ? f : 1.0f;
        f = f > -1.0f ? f : -1.0f;
        return Math.acos(f);
    }

    public Vector4f zero() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        this.w = 0.0f;
        return this;
    }

    public Vector4f negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        this.w = -this.w;
        return this;
    }

    @Override
    public Vector4f negate(Vector4f vector4f) {
        vector4f.x = -this.x;
        vector4f.y = -this.y;
        vector4f.z = -this.z;
        vector4f.w = -this.w;
        return vector4f;
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat numberFormat) {
        return "(" + Runtime.format(this.x, numberFormat) + " " + Runtime.format(this.y, numberFormat) + " " + Runtime.format(this.z, numberFormat) + " " + Runtime.format(this.w, numberFormat) + ")";
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeFloat(this.x);
        objectOutput.writeFloat(this.y);
        objectOutput.writeFloat(this.z);
        objectOutput.writeFloat(this.w);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.set(objectInput.readFloat(), objectInput.readFloat(), objectInput.readFloat(), objectInput.readFloat());
    }

    public Vector4f min(Vector4fc vector4fc) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        float f4 = this.w;
        this.x = f < vector4fc.x() ? f : vector4fc.x();
        this.y = f2 < vector4fc.y() ? f2 : vector4fc.y();
        this.z = f3 < vector4fc.z() ? f3 : vector4fc.z();
        this.w = f4 < vector4fc.w() ? f4 : vector4fc.w();
        return this;
    }

    @Override
    public Vector4f min(Vector4fc vector4fc, Vector4f vector4f) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        float f4 = this.w;
        vector4f.x = f < vector4fc.x() ? f : vector4fc.x();
        vector4f.y = f2 < vector4fc.y() ? f2 : vector4fc.y();
        vector4f.z = f3 < vector4fc.z() ? f3 : vector4fc.z();
        vector4f.w = f4 < vector4fc.w() ? f4 : vector4fc.w();
        return vector4f;
    }

    public Vector4f max(Vector4fc vector4fc) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        float f4 = this.w;
        this.x = f > vector4fc.x() ? f : vector4fc.x();
        this.y = f2 > vector4fc.y() ? f2 : vector4fc.y();
        this.z = f3 > vector4fc.z() ? f3 : vector4fc.z();
        this.w = f4 > vector4fc.w() ? f4 : vector4fc.w();
        return this;
    }

    @Override
    public Vector4f max(Vector4fc vector4fc, Vector4f vector4f) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        float f4 = this.w;
        vector4f.x = f > vector4fc.x() ? f : vector4fc.x();
        vector4f.y = f2 > vector4fc.y() ? f2 : vector4fc.y();
        vector4f.z = f3 > vector4fc.z() ? f3 : vector4fc.z();
        vector4f.w = f4 > vector4fc.w() ? f4 : vector4fc.w();
        return vector4f;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + Float.floatToIntBits(this.w);
        n = 31 * n + Float.floatToIntBits(this.x);
        n = 31 * n + Float.floatToIntBits(this.y);
        n = 31 * n + Float.floatToIntBits(this.z);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Vector4f vector4f = (Vector4f)object;
        if (Float.floatToIntBits(this.w) != Float.floatToIntBits(vector4f.w)) {
            return false;
        }
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(vector4f.x)) {
            return false;
        }
        if (Float.floatToIntBits(this.y) != Float.floatToIntBits(vector4f.y)) {
            return false;
        }
        return Float.floatToIntBits(this.z) == Float.floatToIntBits(vector4f.z);
    }

    @Override
    public boolean equals(Vector4fc vector4fc, float f) {
        if (this == vector4fc) {
            return true;
        }
        if (vector4fc == null) {
            return false;
        }
        if (!(vector4fc instanceof Vector4fc)) {
            return false;
        }
        if (!Runtime.equals(this.x, vector4fc.x(), f)) {
            return false;
        }
        if (!Runtime.equals(this.y, vector4fc.y(), f)) {
            return false;
        }
        if (!Runtime.equals(this.z, vector4fc.z(), f)) {
            return false;
        }
        return Runtime.equals(this.w, vector4fc.w(), f);
    }

    @Override
    public boolean equals(float f, float f2, float f3, float f4) {
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(f)) {
            return false;
        }
        if (Float.floatToIntBits(this.y) != Float.floatToIntBits(f2)) {
            return false;
        }
        if (Float.floatToIntBits(this.z) != Float.floatToIntBits(f3)) {
            return false;
        }
        return Float.floatToIntBits(this.w) == Float.floatToIntBits(f4);
    }

    @Override
    public Vector4f smoothStep(Vector4fc vector4fc, float f, Vector4f vector4f) {
        float f2 = f * f;
        float f3 = f2 * f;
        float f4 = this.x;
        float f5 = this.y;
        float f6 = this.z;
        float f7 = this.w;
        vector4f.x = (f4 + f4 - vector4fc.x() - vector4fc.x()) * f3 + (3.0f * vector4fc.x() - 3.0f * f4) * f2 + f4 * f + f4;
        vector4f.y = (f5 + f5 - vector4fc.y() - vector4fc.y()) * f3 + (3.0f * vector4fc.y() - 3.0f * f5) * f2 + f5 * f + f5;
        vector4f.z = (f6 + f6 - vector4fc.z() - vector4fc.z()) * f3 + (3.0f * vector4fc.z() - 3.0f * f6) * f2 + f6 * f + f6;
        vector4f.w = (f7 + f7 - vector4fc.w() - vector4fc.w()) * f3 + (3.0f * vector4fc.w() - 3.0f * f7) * f2 + f7 * f + f7;
        return vector4f;
    }

    @Override
    public Vector4f hermite(Vector4fc vector4fc, Vector4fc vector4fc2, Vector4fc vector4fc3, float f, Vector4f vector4f) {
        float f2 = f * f;
        float f3 = f2 * f;
        float f4 = this.x;
        float f5 = this.y;
        float f6 = this.z;
        float f7 = this.w;
        vector4f.x = (f4 + f4 - vector4fc2.x() - vector4fc2.x() + vector4fc3.x() + vector4fc.x()) * f3 + (3.0f * vector4fc2.x() - 3.0f * f4 - vector4fc.x() - vector4fc.x() - vector4fc3.x()) * f2 + f4 * f + f4;
        vector4f.y = (f5 + f5 - vector4fc2.y() - vector4fc2.y() + vector4fc3.y() + vector4fc.y()) * f3 + (3.0f * vector4fc2.y() - 3.0f * f5 - vector4fc.y() - vector4fc.y() - vector4fc3.y()) * f2 + f5 * f + f5;
        vector4f.z = (f6 + f6 - vector4fc2.z() - vector4fc2.z() + vector4fc3.z() + vector4fc.z()) * f3 + (3.0f * vector4fc2.z() - 3.0f * f6 - vector4fc.z() - vector4fc.z() - vector4fc3.z()) * f2 + f6 * f + f6;
        vector4f.w = (f7 + f7 - vector4fc2.w() - vector4fc2.w() + vector4fc3.w() + vector4fc.w()) * f3 + (3.0f * vector4fc2.w() - 3.0f * f7 - vector4fc.w() - vector4fc.w() - vector4fc3.w()) * f2 + f7 * f + f7;
        return vector4f;
    }

    public Vector4f lerp(Vector4fc vector4fc, float f) {
        this.x = Math.fma(vector4fc.x() - this.x, f, this.x);
        this.y = Math.fma(vector4fc.y() - this.y, f, this.y);
        this.z = Math.fma(vector4fc.z() - this.z, f, this.z);
        this.w = Math.fma(vector4fc.w() - this.w, f, this.w);
        return this;
    }

    @Override
    public Vector4f lerp(Vector4fc vector4fc, float f, Vector4f vector4f) {
        vector4f.x = Math.fma(vector4fc.x() - this.x, f, this.x);
        vector4f.y = Math.fma(vector4fc.y() - this.y, f, this.y);
        vector4f.z = Math.fma(vector4fc.z() - this.z, f, this.z);
        vector4f.w = Math.fma(vector4fc.w() - this.w, f, this.w);
        return vector4f;
    }

    @Override
    public float get(int n) throws IllegalArgumentException {
        switch (n) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
            case 3: {
                return this.w;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Vector4i get(int n, Vector4i vector4i) {
        vector4i.x = Math.roundUsing(this.x(), n);
        vector4i.y = Math.roundUsing(this.y(), n);
        vector4i.z = Math.roundUsing(this.z(), n);
        vector4i.w = Math.roundUsing(this.w(), n);
        return vector4i;
    }

    @Override
    public Vector4f get(Vector4f vector4f) {
        vector4f.x = this.x();
        vector4f.y = this.y();
        vector4f.z = this.z();
        vector4f.w = this.w();
        return vector4f;
    }

    @Override
    public Vector4d get(Vector4d vector4d) {
        vector4d.x = this.x();
        vector4d.y = this.y();
        vector4d.z = this.z();
        vector4d.w = this.w();
        return vector4d;
    }

    @Override
    public int maxComponent() {
        float f = Math.abs(this.x);
        float f2 = Math.abs(this.y);
        float f3 = Math.abs(this.z);
        float f4 = Math.abs(this.w);
        if (f >= f2 && f >= f3 && f >= f4) {
            return 0;
        }
        if (f2 >= f3 && f2 >= f4) {
            return 1;
        }
        if (f3 >= f4) {
            return 2;
        }
        return 3;
    }

    @Override
    public int minComponent() {
        float f = Math.abs(this.x);
        float f2 = Math.abs(this.y);
        float f3 = Math.abs(this.z);
        float f4 = Math.abs(this.w);
        if (f < f2 && f < f3 && f < f4) {
            return 0;
        }
        if (f2 < f3 && f2 < f4) {
            return 1;
        }
        if (f3 < f4) {
            return 2;
        }
        return 3;
    }

    public Vector4f floor() {
        this.x = Math.floor(this.x);
        this.y = Math.floor(this.y);
        this.z = Math.floor(this.z);
        this.w = Math.floor(this.w);
        return this;
    }

    @Override
    public Vector4f floor(Vector4f vector4f) {
        vector4f.x = Math.floor(this.x);
        vector4f.y = Math.floor(this.y);
        vector4f.z = Math.floor(this.z);
        vector4f.w = Math.floor(this.w);
        return vector4f;
    }

    public Vector4f ceil() {
        this.x = Math.ceil(this.x);
        this.y = Math.ceil(this.y);
        this.z = Math.ceil(this.z);
        this.w = Math.ceil(this.w);
        return this;
    }

    @Override
    public Vector4f ceil(Vector4f vector4f) {
        vector4f.x = Math.ceil(this.x);
        vector4f.y = Math.ceil(this.y);
        vector4f.z = Math.ceil(this.z);
        vector4f.w = Math.ceil(this.w);
        return vector4f;
    }

    public Vector4f round() {
        this.x = Math.round(this.x);
        this.y = Math.round(this.y);
        this.z = Math.round(this.z);
        this.w = Math.round(this.w);
        return this;
    }

    @Override
    public Vector4f round(Vector4f vector4f) {
        vector4f.x = Math.round(this.x);
        vector4f.y = Math.round(this.y);
        vector4f.z = Math.round(this.z);
        vector4f.w = Math.round(this.w);
        return vector4f;
    }

    @Override
    public boolean isFinite() {
        return Math.isFinite(this.x) && Math.isFinite(this.y) && Math.isFinite(this.z) && Math.isFinite(this.w);
    }

    public Vector4f absolute() {
        this.x = Math.abs(this.x);
        this.y = Math.abs(this.y);
        this.z = Math.abs(this.z);
        this.w = Math.abs(this.w);
        return this;
    }

    @Override
    public Vector4f absolute(Vector4f vector4f) {
        vector4f.x = Math.abs(this.x);
        vector4f.y = Math.abs(this.y);
        vector4f.z = Math.abs(this.z);
        vector4f.w = Math.abs(this.w);
        return vector4f;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

