/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.texture.pbr.loader;

import com.mojang.datafixers.util.Pair;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.coderbot.iris.Iris;
import net.coderbot.iris.mixin.texture.AnimatedTextureAccessor;
import net.coderbot.iris.mixin.texture.AnimationMetadataSectionAccessor;
import net.coderbot.iris.mixin.texture.FrameInfoAccessor;
import net.coderbot.iris.mixin.texture.TextureAtlasAccessor;
import net.coderbot.iris.mixin.texture.TextureAtlasSpriteAccessor;
import net.coderbot.iris.texture.TextureInfoCache;
import net.coderbot.iris.texture.format.TextureFormat;
import net.coderbot.iris.texture.format.TextureFormatLoader;
import net.coderbot.iris.texture.mipmap.ChannelMipmapGenerator;
import net.coderbot.iris.texture.mipmap.CustomMipmapGenerator;
import net.coderbot.iris.texture.mipmap.LinearBlendFunction;
import net.coderbot.iris.texture.pbr.PBRAtlasTexture;
import net.coderbot.iris.texture.pbr.PBRSpriteHolder;
import net.coderbot.iris.texture.pbr.PBRType;
import net.coderbot.iris.texture.pbr.TextureAtlasSpriteExtension;
import net.coderbot.iris.texture.pbr.loader.PBRTextureLoader;
import net.coderbot.iris.texture.util.ImageManipulationUtil;
import net.minecraft.class_1011;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1061;
import net.minecraft.class_1079;
import net.minecraft.class_2960;
import net.minecraft.class_3270;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.jetbrains.annotations.Nullable;

public class AtlasPBRLoader
implements PBRTextureLoader<class_1059> {
    public static final ChannelMipmapGenerator LINEAR_MIPMAP_GENERATOR = new ChannelMipmapGenerator(LinearBlendFunction.INSTANCE, LinearBlendFunction.INSTANCE, LinearBlendFunction.INSTANCE, LinearBlendFunction.INSTANCE);

    @Override
    public void load(class_1059 class_10592, class_3300 class_33002, PBRTextureLoader.PBRTextureConsumer pBRTextureConsumer) {
        TextureInfoCache.TextureInfo textureInfo = TextureInfoCache.INSTANCE.getInfo(class_10592.method_4624());
        int n = textureInfo.getWidth();
        int n2 = textureInfo.getHeight();
        int n3 = AtlasPBRLoader.fetchAtlasMipLevel(class_10592);
        PBRAtlasTexture pBRAtlasTexture = null;
        PBRAtlasTexture pBRAtlasTexture2 = null;
        for (class_1058 class_10582 : ((TextureAtlasAccessor)class_10592).getTexturesByName().values()) {
            PBRSpriteHolder pBRSpriteHolder;
            if (class_10582 instanceof class_1047) continue;
            class_1058 class_10583 = this.createPBRSprite(class_10582, class_33002, class_10592, n, n2, n3, PBRType.NORMAL);
            class_1058 class_10584 = this.createPBRSprite(class_10582, class_33002, class_10592, n, n2, n3, PBRType.SPECULAR);
            if (class_10583 != null) {
                if (pBRAtlasTexture == null) {
                    pBRAtlasTexture = new PBRAtlasTexture(class_10592, PBRType.NORMAL);
                }
                pBRAtlasTexture.addSprite(class_10583);
                pBRSpriteHolder = ((TextureAtlasSpriteExtension)class_10582).getOrCreatePBRHolder();
                pBRSpriteHolder.setNormalSprite(class_10583);
            }
            if (class_10584 == null) continue;
            if (pBRAtlasTexture2 == null) {
                pBRAtlasTexture2 = new PBRAtlasTexture(class_10592, PBRType.SPECULAR);
            }
            pBRAtlasTexture2.addSprite(class_10584);
            pBRSpriteHolder = ((TextureAtlasSpriteExtension)class_10582).getOrCreatePBRHolder();
            pBRSpriteHolder.setSpecularSprite(class_10584);
        }
        if (pBRAtlasTexture != null && pBRAtlasTexture.tryUpload(n, n2, n3)) {
            pBRTextureConsumer.acceptNormalTexture(pBRAtlasTexture);
        }
        if (pBRAtlasTexture2 != null && pBRAtlasTexture2.tryUpload(n, n2, n3)) {
            pBRTextureConsumer.acceptSpecularTexture(pBRAtlasTexture2);
        }
    }

    protected static int fetchAtlasMipLevel(class_1059 class_10592) {
        class_1058 class_10582 = class_10592.method_4608(class_1047.method_4539());
        return ((TextureAtlasSpriteAccessor)class_10582).getMainImage().length - 1;
    }

    @Nullable
    protected class_1058 createPBRSprite(class_1058 class_10582, class_3300 class_33002, class_1059 class_10592, int n, int n2, int n3, PBRType pBRType) {
        class_2960 class_29602 = class_10582.method_4598();
        class_2960 class_29603 = ((TextureAtlasAccessor)class_10592).callGetResourceLocation(class_29602);
        class_2960 class_29604 = pBRType.appendToFileLocation(class_29603);
        PBRTextureAtlasSprite pBRTextureAtlasSprite = null;
        try (class_3298 class_32982 = class_33002.method_14486(class_29604);){
            int n4;
            int n5;
            class_1011 class_10112 = class_1011.method_4309((InputStream)class_32982.method_14482());
            class_1079 class_10792 = (class_1079)class_32982.method_14481((class_3270)class_1079.field_5337);
            if (class_10792 == null) {
                class_10792 = class_1079.field_21768;
            }
            Pair pair = class_10792.method_24141(class_10112.method_4307(), class_10112.method_4323());
            int n6 = (Integer)pair.getFirst();
            int n7 = (Integer)pair.getSecond();
            int n8 = class_10582.method_4578();
            int n9 = class_10582.method_4595();
            if (n6 != n8 || n7 != n9) {
                int n10 = class_10112.method_4307();
                int n11 = class_10112.method_4323();
                n5 = n10 / n6 * n8;
                n4 = n11 / n7 * n9;
                class_1011 class_10113 = n5 % n10 == 0 && n4 % n11 == 0 ? ImageManipulationUtil.scaleNearestNeighbor(class_10112, n5, n4) : ImageManipulationUtil.scaleBilinear(class_10112, n5, n4);
                class_10112.close();
                class_10112 = class_10113;
                n6 = n8;
                n7 = n9;
                if (class_10792 != class_1079.field_21768) {
                    AnimationMetadataSectionAccessor animationMetadataSectionAccessor = (AnimationMetadataSectionAccessor)class_10792;
                    int n12 = animationMetadataSectionAccessor.getFrameWidth();
                    int n13 = animationMetadataSectionAccessor.getFrameHeight();
                    if (n12 != -1) {
                        animationMetadataSectionAccessor.setFrameWidth(n6);
                    }
                    if (n13 != -1) {
                        animationMetadataSectionAccessor.setFrameHeight(n7);
                    }
                }
            }
            class_2960 class_29605 = new class_2960(class_29602.method_12836(), class_29602.method_12832() + pBRType.getSuffix());
            PBRTextureAtlasSpriteInfo pBRTextureAtlasSpriteInfo = new PBRTextureAtlasSpriteInfo(class_29605, n6, n7, class_10792, pBRType);
            n5 = ((TextureAtlasSpriteAccessor)class_10582).getX();
            n4 = ((TextureAtlasSpriteAccessor)class_10582).getY();
            pBRTextureAtlasSprite = new PBRTextureAtlasSprite(class_10592, pBRTextureAtlasSpriteInfo, n3, n, n2, n5, n4, class_10112);
            this.syncAnimation(class_10582, pBRTextureAtlasSprite);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (RuntimeException runtimeException) {
            Iris.logger.error("Unable to parse metadata from {} : {}", class_29604, runtimeException);
        }
        catch (IOException iOException) {
            Iris.logger.error("Unable to load {} : {}", class_29604, iOException);
        }
        return pBRTextureAtlasSprite;
    }

    protected void syncAnimation(class_1058 class_10582, class_1058 class_10583) {
        int n;
        int n2;
        class_1061 class_10612 = class_10582.method_33443();
        class_1061 class_10613 = class_10583.method_33443();
        if (!(class_10612 instanceof AnimatedTextureAccessor) || !(class_10613 instanceof AnimatedTextureAccessor)) {
            return;
        }
        AnimatedTextureAccessor animatedTextureAccessor = (AnimatedTextureAccessor)class_10612;
        int n3 = 0;
        for (int i = 0; i < animatedTextureAccessor.getFrame(); ++i) {
            n3 += ((FrameInfoAccessor)animatedTextureAccessor.getFrames().get(i)).getTime();
        }
        AnimatedTextureAccessor animatedTextureAccessor2 = (AnimatedTextureAccessor)class_10613;
        List<Object> list = animatedTextureAccessor2.getFrames();
        int n4 = 0;
        int n5 = list.size();
        for (n2 = 0; n2 < n5; ++n2) {
            n4 += ((FrameInfoAccessor)list.get(n2)).getTime();
        }
        n3 %= n4;
        n2 = 0;
        while (n3 >= (n = ((FrameInfoAccessor)list.get(n2)).getTime())) {
            ++n2;
            n3 -= n;
        }
        animatedTextureAccessor2.setFrame(n2);
        animatedTextureAccessor2.setSubFrame(n3 + animatedTextureAccessor.getSubFrame());
    }

    protected static class PBRTextureAtlasSpriteInfo
    extends class_1058.class_4727 {
        protected final PBRType pbrType;

        public PBRTextureAtlasSpriteInfo(class_2960 class_29602, int n, int n2, class_1079 class_10792, PBRType pBRType) {
            super(class_29602, n, n2, class_10792);
            this.pbrType = pBRType;
        }
    }

    public static class PBRTextureAtlasSprite
    extends class_1058
    implements CustomMipmapGenerator.Provider {
        protected PBRTextureAtlasSprite(class_1059 class_10592, class_1058.class_4727 class_47272, int n, int n2, int n3, int n4, int n5, class_1011 class_10112) {
            super(class_10592, class_47272, n, n2, n3, n4, n5, class_10112);
        }

        @Override
        public CustomMipmapGenerator getMipmapGenerator(class_1058.class_4727 class_47272, int n, int n2) {
            if (class_47272 instanceof PBRTextureAtlasSpriteInfo) {
                CustomMipmapGenerator customMipmapGenerator;
                PBRType pBRType = ((PBRTextureAtlasSpriteInfo)class_47272).pbrType;
                TextureFormat textureFormat = TextureFormatLoader.getFormat();
                if (textureFormat != null && (customMipmapGenerator = textureFormat.getMipmapGenerator(pBRType)) != null) {
                    return customMipmapGenerator;
                }
            }
            return LINEAR_MIPMAP_GENERATOR;
        }
    }
}

