/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.texture.format;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.texture.mipmap.CustomMipmapGenerator;
import net.coderbot.iris.texture.pbr.PBRType;
import net.minecraft.class_1044;
import org.jetbrains.annotations.Nullable;

public interface TextureFormat {
    public String getName();

    @Nullable
    public String getVersion();

    default public List<String> getDefines() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.getName().toUpperCase(Locale.ROOT).replaceAll("-", "_");
        String string2 = "MC_TEXTURE_FORMAT_" + string;
        arrayList.add(string2);
        String string3 = this.getVersion();
        if (string3 != null) {
            String string4 = string3.replaceAll("[.-]", "_");
            String string5 = string2 + "_" + string4;
            arrayList.add(string5);
        }
        return arrayList;
    }

    public boolean canInterpolateValues(PBRType var1);

    default public void setupTextureParameters(PBRType pBRType, class_1044 class_10442) {
        if (!this.canInterpolateValues(pBRType)) {
            class_10442.method_23207();
            int n = IrisRenderSystem.getTexParameteri(3553, 10241);
            boolean bl = (n & 0x100) == 1;
            GlStateManager._texParameter((int)3553, (int)10241, (int)(bl ? 9984 : 9728));
            GlStateManager._texParameter((int)3553, (int)10240, (int)9728);
        }
    }

    @Nullable
    public CustomMipmapGenerator getMipmapGenerator(PBRType var1);

    public static interface Factory {
        public TextureFormat createFormat(String var1, @Nullable String var2);
    }
}

