/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shadow;

import java.nio.FloatBuffer;
import net.minecraft.class_1159;
import net.minecraft.class_1160;

public class ShadowMatrices {
    private static final float NEAR = 0.05f;
    private static final float FAR = 256.0f;

    public static float[] createOrthoMatrix(float f) {
        return new float[]{1.0f / f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f / f, 0.0f, 0.0f, 0.0f, 0.0f, -0.007814026f, 0.0f, 0.0f, 0.0f, -1.0003906f, 1.0f};
    }

    public static float[] createPerspectiveMatrix(float f) {
        float f2 = (float)(1.0 / Math.tan(Math.toRadians(f) * 0.5));
        return new float[]{f2, 0.0f, 0.0f, 0.0f, 0.0f, f2, 0.0f, 0.0f, 0.0f, 0.0f, -1.0003906f, -1.0f, 0.0f, 0.0f, -0.10001954f, 1.0f};
    }

    public static void createBaselineModelViewMatrix(class_1159 class_11592, float f, float f2) {
        float f3 = f < 0.25f ? f + 0.75f : f - 0.25f;
        class_11592.method_22668();
        class_11592.method_22672(class_1159.method_24021((float)0.0f, (float)0.0f, (float)-100.0f));
        class_11592.method_22670(class_1160.field_20703.method_23214(90.0f));
        class_11592.method_22670(class_1160.field_20707.method_23214(f3 * -360.0f));
        class_11592.method_22670(class_1160.field_20703.method_23214(f2));
    }

    public static void snapModelViewToGrid(class_1159 class_11592, float f, double d, double d2, double d3) {
        if (Math.abs(f) == 0.0f) {
            return;
        }
        float f2 = (float)d % f;
        float f3 = (float)d2 % f;
        float f4 = (float)d3 % f;
        float f5 = f / 2.0f;
        class_11592.method_22672(class_1159.method_24021((float)(f2 -= f5), (float)(f3 -= f5), (float)(f4 -= f5)));
    }

    public static void createModelViewMatrix(class_1159 class_11592, float f, float f2, float f3, double d, double d2, double d3) {
        ShadowMatrices.createBaselineModelViewMatrix(class_11592, f, f3);
        ShadowMatrices.snapModelViewToGrid(class_11592, f2, d, d2, d3);
    }

    private static final class Tests {
        private Tests() {
        }

        public static void main(String[] stringArray) {
            float[] fArray = new float[]{0.03125f, 0.0f, 0.0f, 0.0f, 0.0f, 0.03125f, 0.0f, 0.0f, 0.0f, 0.0f, -0.007814026f, 0.0f, 0.0f, 0.0f, -1.0003906f, 1.0f};
            Tests.test("ortho projection hpl=32", fArray, ShadowMatrices.createOrthoMatrix(32.0f));
            float[] fArray2 = new float[]{0.009090909f, 0.0f, 0.0f, 0.0f, 0.0f, 0.009090909f, 0.0f, 0.0f, 0.0f, 0.0f, -0.007814026f, 0.0f, 0.0f, 0.0f, -1.0003906f, 1.0f};
            Tests.test("ortho projection hpl=110", fArray2, ShadowMatrices.createOrthoMatrix(110.0f));
            float[] fArray3 = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0003906f, -1.0f, 0.0f, 0.0f, -0.10001954f, 0.0f};
            Tests.test("perspective projection fov=90", fArray3, ShadowMatrices.createPerspectiveMatrix(90.0f));
            float[] fArray4 = new float[]{0.2154504f, 5.8204815E-8f, 0.9765147f, 0.0f, -0.97651476f, 1.2841845E-8f, 0.21545039f, 0.0f, 0.0f, -0.99999994f, 5.9604645E-8f, 0.0f, 0.3800215f, 1.0264281f, -100.44631f, 1.0f};
            class_1159 class_11592 = new class_1159();
            ShadowMatrices.createModelViewMatrix(class_11592, 0.03451777f, 2.0f, 0.0f, 0.646045982837677, 82.53274536132812, -514.0264282226562);
            Tests.test("model view at dawn", fArray4, Tests.toFloatArray(class_11592));
        }

        private static float[] toFloatArray(class_1159 class_11592) {
            FloatBuffer floatBuffer = FloatBuffer.allocate(16);
            class_11592.method_4932(floatBuffer);
            return floatBuffer.array();
        }

        private static void test(String string, float[] fArray, float[] fArray2) {
            if (!Tests.areMatricesEqualWithinEpsilon(fArray, fArray2)) {
                System.err.println("test " + string + " failed: ");
                System.err.println("    expected: ");
                System.err.print(Tests.printMatrix(fArray, 8));
                System.err.println("    created: ");
                System.err.print(Tests.printMatrix(fArray2, 8));
            } else {
                System.out.println("test " + string + " passed");
            }
        }

        private static boolean areMatricesEqualWithinEpsilon(float[] fArray, float[] fArray2) {
            for (int i = 0; i < 16; ++i) {
                if (!(Math.abs(fArray[i] - fArray2[i]) > 5.0E-4f)) continue;
                return false;
            }
            return true;
        }

        private static String printMatrix(float[] fArray, int n) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < 4; ++i) {
                int n2;
                for (n2 = 0; n2 < n; ++n2) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append('[');
                for (n2 = 0; n2 < 4; ++n2) {
                    stringBuilder.append(' ');
                    stringBuilder.append(fArray[n2 * 4 + i]);
                }
                stringBuilder.append(" ]");
                stringBuilder.append('\n');
            }
            return stringBuilder.toString();
        }
    }
}

