/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.postprocess;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.program.Program;
import net.coderbot.iris.gl.program.ProgramBuilder;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.program.ProgramUniforms;
import net.coderbot.iris.gl.sampler.SamplerLimits;
import net.coderbot.iris.gl.shader.ShaderType;
import net.coderbot.iris.pipeline.newshader.FogMode;
import net.coderbot.iris.pipeline.newshader.TriforcePatcher;
import net.coderbot.iris.postprocess.BufferFlipper;
import net.coderbot.iris.postprocess.CenterDepthSampler;
import net.coderbot.iris.postprocess.FullScreenQuadRenderer;
import net.coderbot.iris.rendertarget.RenderTarget;
import net.coderbot.iris.rendertarget.RenderTargets;
import net.coderbot.iris.samplers.IrisImages;
import net.coderbot.iris.samplers.IrisSamplers;
import net.coderbot.iris.shaderpack.PackDirectives;
import net.coderbot.iris.shaderpack.PackRenderTargetDirectives;
import net.coderbot.iris.shaderpack.ProgramDirectives;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.shadows.ShadowRenderTargets;
import net.coderbot.iris.uniforms.CommonUniforms;
import net.coderbot.iris.uniforms.FrameUpdateNotifier;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_276;
import net.minecraft.class_310;

public class CompositeRenderer {
    private final RenderTargets renderTargets;
    private final ImmutableList<Pass> passes;
    private final IntSupplier noiseTexture;
    private final FrameUpdateNotifier updateNotifier;
    private final CenterDepthSampler centerDepthSampler;
    private final Object2ObjectMap<String, IntSupplier> customTextureIds;
    private final ImmutableSet<Integer> flippedAtLeastOnceFinal;

    public CompositeRenderer(PackDirectives packDirectives, ProgramSource[] programSourceArray, RenderTargets renderTargets, IntSupplier intSupplier, FrameUpdateNotifier frameUpdateNotifier, CenterDepthSampler centerDepthSampler, BufferFlipper bufferFlipper, Supplier<ShadowRenderTargets> supplier, Object2ObjectMap<String, IntSupplier> object2ObjectMap, ImmutableMap<Integer, Boolean> immutableMap) {
        this.noiseTexture = intSupplier;
        this.updateNotifier = frameUpdateNotifier;
        this.centerDepthSampler = centerDepthSampler;
        this.renderTargets = renderTargets;
        this.customTextureIds = object2ObjectMap;
        PackRenderTargetDirectives packRenderTargetDirectives = packDirectives.getRenderTargetDirectives();
        Map<Integer, PackRenderTargetDirectives.RenderTargetSettings> map = packRenderTargetDirectives.getRenderTargetSettings();
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableSet.Builder builder2 = new ImmutableSet.Builder();
        immutableMap.forEach((n, bl) -> {
            if (bl.booleanValue()) {
                bufferFlipper.flip((int)n);
            }
        });
        for (ProgramSource programSource : programSourceArray) {
            if (programSource == null || !programSource.isValid()) continue;
            Pass pass = new Pass();
            ProgramDirectives programDirectives = programSource.getDirectives();
            ImmutableSet<Integer> immutableSet = bufferFlipper.snapshot();
            ImmutableSet immutableSet2 = builder2.build();
            pass.program = this.createProgram(programSource, immutableSet, (ImmutableSet<Integer>)immutableSet2, supplier);
            int[] nArray = programDirectives.getDrawBuffers();
            GlFramebuffer glFramebuffer = renderTargets.createColorFramebuffer(immutableSet, nArray);
            pass.stageReadsFromAlt = immutableSet;
            pass.framebuffer = glFramebuffer;
            pass.viewportScale = programDirectives.getViewportScale();
            pass.mipmappedBuffers = programDirectives.getMipmappedBuffers();
            pass.flippedAtLeastOnce = immutableSet2;
            builder.add((Object)pass);
            ImmutableMap<Integer, Boolean> immutableMap2 = programDirectives.getExplicitFlips();
            for (int n2 : nArray) {
                if (immutableMap2.get((Object)n2) == Boolean.FALSE) continue;
                bufferFlipper.flip(n2);
                builder2.add((Object)n2);
            }
            immutableMap2.forEach((n, bl) -> {
                if (bl.booleanValue()) {
                    bufferFlipper.flip((int)n);
                    builder2.add(n);
                }
            });
        }
        this.passes = builder.build();
        this.flippedAtLeastOnceFinal = builder2.build();
        GlStateManager._glBindFramebuffer((int)36008, (int)0);
    }

    public ImmutableSet<Integer> getFlippedAtLeastOnceFinal() {
        return this.flippedAtLeastOnceFinal;
    }

    public void renderAll() {
        RenderSystem.disableBlend();
        class_276 class_2762 = class_310.method_1551().method_1522();
        int n = class_2762.field_1482;
        int n2 = class_2762.field_1481;
        FullScreenQuadRenderer.INSTANCE.begin();
        for (Pass pass : this.passes) {
            if (!pass.mipmappedBuffers.isEmpty()) {
                RenderSystem.activeTexture((int)33984);
                UnmodifiableIterator unmodifiableIterator = pass.mipmappedBuffers.iterator();
                while (unmodifiableIterator.hasNext()) {
                    int n3 = (Integer)unmodifiableIterator.next();
                    CompositeRenderer.setupMipmapping(this.renderTargets.get(n3), pass.stageReadsFromAlt.contains((Object)n3));
                }
            }
            float f = (float)n * pass.viewportScale;
            float f2 = (float)n2 * pass.viewportScale;
            RenderSystem.viewport((int)0, (int)0, (int)((int)f), (int)((int)f2));
            pass.framebuffer.bind();
            pass.program.use();
            FullScreenQuadRenderer.INSTANCE.renderQuad();
            RenderSystem.viewport((int)0, (int)0, (int)n, (int)n2);
        }
        FullScreenQuadRenderer.INSTANCE.end();
        class_2762.method_1235(true);
        ProgramUniforms.clearActiveUniforms();
        ProgramSamplers.clearActiveSamplers();
        GlStateManager._glUseProgram((int)0);
        for (int i = 0; i < SamplerLimits.get().getMaxTextureUnits(); ++i) {
            RenderSystem.activeTexture((int)(33984 + i));
            RenderSystem.bindTexture((int)0);
        }
        RenderSystem.activeTexture((int)33984);
    }

    private static void setupMipmapping(RenderTarget renderTarget, boolean bl) {
        RenderSystem.bindTexture((int)(bl ? renderTarget.getAltTexture() : renderTarget.getMainTexture()));
        IrisRenderSystem.generateMipmaps(3553);
        RenderSystem.texParameter((int)3553, (int)10241, (int)9987);
    }

    private Program createProgram(ProgramSource programSource, ImmutableSet<Integer> immutableSet, ImmutableSet<Integer> immutableSet2, Supplier<ShadowRenderTargets> supplier) {
        ProgramBuilder programBuilder;
        String string = TriforcePatcher.patchComposite(programSource.getVertexSource().orElseThrow(RuntimeException::new), ShaderType.VERTEX);
        String string2 = null;
        if (programSource.getGeometrySource().isPresent()) {
            string2 = TriforcePatcher.patchComposite(programSource.getGeometrySource().orElseThrow(RuntimeException::new), ShaderType.GEOMETRY);
        }
        String string3 = TriforcePatcher.patchComposite(programSource.getFragmentSource().orElseThrow(RuntimeException::new), ShaderType.FRAGMENT);
        try {
            programBuilder = ProgramBuilder.begin(programSource.getName(), string, string2, string3, IrisSamplers.COMPOSITE_RESERVED_TEXTURE_UNITS);
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeException("Shader compilation failed!", runtimeException);
        }
        ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(programBuilder, this.customTextureIds, immutableSet2);
        CommonUniforms.addCommonUniforms(programBuilder, programSource.getParent().getPack().getIdMap(), programSource.getParent().getPackDirectives(), this.updateNotifier, FogMode.OFF);
        IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, () -> immutableSet, this.renderTargets, true);
        IrisImages.addRenderTargetImages(programBuilder, () -> immutableSet, this.renderTargets);
        IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.noiseTexture);
        IrisSamplers.addCompositeSamplers(customTextureSamplerInterceptor, this.renderTargets);
        if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor)) {
            IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, supplier.get());
            IrisImages.addShadowColorImages(programBuilder, supplier.get());
        }
        programBuilder.addDynamicSampler(this.centerDepthSampler::getCenterDepthTexture, "iris_centerDepthSmooth");
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            Path path = FabricLoader.getInstance().getGameDir().resolve("patched_shaders");
            try {
                Files.write(path.resolve(programSource.getName() + ".vsh"), string.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                if (programSource.getGeometrySource().isPresent()) {
                    Files.write(path.resolve(programSource.getName() + ".gsh"), string2.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
                Files.write(path.resolve(programSource.getName() + ".fsh"), string3.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            catch (IOException iOException) {
                Iris.logger.warn("Failed to write debug patched shader source", iOException);
            }
        }
        return programBuilder.build();
    }

    public void destroy() {
        for (Pass pass : this.passes) {
            pass.destroy();
        }
    }

    private static final class Pass {
        Program program;
        GlFramebuffer framebuffer;
        ImmutableSet<Integer> flippedAtLeastOnce;
        ImmutableSet<Integer> stageReadsFromAlt;
        ImmutableSet<Integer> mipmappedBuffers;
        float viewportScale;

        private Pass() {
        }

        private void destroy() {
            this.program.destroy();
        }
    }
}

