/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.postprocess;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.program.Program;
import net.coderbot.iris.gl.program.ProgramBuilder;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.program.ProgramUniforms;
import net.coderbot.iris.gl.texture.DepthCopyStrategy;
import net.coderbot.iris.gl.texture.InternalTextureFormat;
import net.coderbot.iris.gl.texture.PixelType;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.postprocess.FullScreenQuadRenderer;
import net.coderbot.iris.rendertarget.RenderTargets;
import net.coderbot.iris.uniforms.SystemTimeUniforms;
import net.coderbot.iris.vendored.joml.Matrix4f;
import net.minecraft.class_310;
import org.apache.commons.io.IOUtils;

public class CenterDepthSampler {
    private static final double LN2 = Math.log(2.0);
    private final Program program;
    private final GlFramebuffer framebuffer;
    private final int texture = GlStateManager._genTexture();
    private final int altTexture = GlStateManager._genTexture();
    private boolean hasFirstSample;
    private boolean everRetrieved;

    public CenterDepthSampler(RenderTargets renderTargets, float f) {
        ProgramBuilder programBuilder;
        this.framebuffer = new GlFramebuffer();
        InternalTextureFormat internalTextureFormat = InternalTextureFormat.R32F;
        RenderSystem.bindTexture((int)this.texture);
        this.setupColorTexture(internalTextureFormat);
        RenderSystem.bindTexture((int)this.altTexture);
        this.setupColorTexture(internalTextureFormat);
        RenderSystem.bindTexture((int)0);
        this.framebuffer.addColorAttachment(0, this.texture);
        try {
            String string = new String(IOUtils.toByteArray((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("/centerDepth.fsh"))), StandardCharsets.UTF_8);
            String string2 = new String(IOUtils.toByteArray((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("/centerDepth.vsh"))), StandardCharsets.UTF_8);
            programBuilder = ProgramBuilder.begin("centerDepthSmooth", string2, null, string, (ImmutableSet<Integer>)ImmutableSet.of());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        programBuilder.addDynamicSampler(renderTargets::getDepthTexture, "depth");
        programBuilder.addDynamicSampler(() -> this.altTexture, "altDepth");
        programBuilder.uniform1f(UniformUpdateFrequency.PER_FRAME, "lastFrameTime", SystemTimeUniforms.TIMER::getLastFrameTime);
        programBuilder.uniform1f(UniformUpdateFrequency.ONCE, "decay", () -> 1.0 / ((double)f * 0.1 / LN2));
        programBuilder.uniformJomlMatrix(UniformUpdateFrequency.ONCE, "projection", () -> new Matrix4f(2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, -1.0f, 0.0f, 1.0f));
        this.program = programBuilder.build();
    }

    public void sampleCenterDepth() {
        if (this.hasFirstSample && !this.everRetrieved) {
            return;
        }
        this.hasFirstSample = true;
        this.framebuffer.bind();
        this.program.use();
        RenderSystem.viewport((int)0, (int)0, (int)1, (int)1);
        FullScreenQuadRenderer.INSTANCE.render();
        ProgramUniforms.clearActiveUniforms();
        ProgramSamplers.clearActiveSamplers();
        GlStateManager._glUseProgram((int)0);
        this.framebuffer.bind();
        GlStateManager._bindTexture((int)this.altTexture);
        DepthCopyStrategy.fastest(false).copy(this.framebuffer, this.texture, null, this.altTexture, 1, 1);
        GlStateManager._bindTexture((int)0);
        class_310.method_1551().method_1522().method_1235(true);
    }

    public void setupColorTexture(InternalTextureFormat internalTextureFormat) {
        RenderSystem.texParameter((int)3553, (int)10241, (int)9729);
        RenderSystem.texParameter((int)3553, (int)10240, (int)9729);
        RenderSystem.texParameter((int)3553, (int)10242, (int)33071);
        RenderSystem.texParameter((int)3553, (int)10243, (int)33071);
        GlStateManager._texImage2D((int)3553, (int)0, (int)internalTextureFormat.getGlFormat(), (int)1, (int)1, (int)0, (int)internalTextureFormat.getPixelFormat().getGlFormat(), (int)PixelType.FLOAT.getGlFormat(), null);
    }

    public int getCenterDepthTexture() {
        this.everRetrieved = true;
        return this.altTexture;
    }

    public void destroy() {
        GlStateManager._deleteTexture((int)this.texture);
        GlStateManager._deleteTexture((int)this.altTexture);
        this.framebuffer.destroy();
        this.program.destroy();
    }
}

