/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.function.IntSupplier;
import net.coderbot.iris.Iris;
import net.coderbot.iris.mixin.GlStateManagerAccessor;
import net.coderbot.iris.mixin.LightTextureAccessor;
import net.coderbot.iris.rendertarget.NativeImageBackedCustomTexture;
import net.coderbot.iris.rendertarget.NativeImageBackedNoiseTexture;
import net.coderbot.iris.shaderpack.PackDirectives;
import net.coderbot.iris.shaderpack.texture.CustomTextureData;
import net.coderbot.iris.shaderpack.texture.TextureStage;
import net.coderbot.iris.texture.format.TextureFormat;
import net.coderbot.iris.texture.format.TextureFormatLoader;
import net.coderbot.iris.texture.pbr.PBRTextureHolder;
import net.coderbot.iris.texture.pbr.PBRTextureManager;
import net.coderbot.iris.texture.pbr.PBRType;
import net.minecraft.class_1044;
import net.minecraft.class_1047;
import net.minecraft.class_1060;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.apache.commons.io.FilenameUtils;

public class CustomTextureManager {
    private final EnumMap<TextureStage, Object2ObjectMap<String, IntSupplier>> customTextureIdMap = new EnumMap(TextureStage.class);
    private final IntSupplier noise;
    private final List<class_1044> ownedTextures = new ArrayList<class_1044>();

    public CustomTextureManager(PackDirectives packDirectives, EnumMap<TextureStage, Object2ObjectMap<String, CustomTextureData>> enumMap, Optional<CustomTextureData> optional) {
        enumMap.forEach((textureStage, object2ObjectMap) -> {
            Object2ObjectOpenHashMap object2ObjectOpenHashMap = new Object2ObjectOpenHashMap();
            object2ObjectMap.forEach((arg_0, arg_1) -> this.lambda$new$0((Object2ObjectMap)object2ObjectOpenHashMap, textureStage, arg_0, arg_1));
            this.customTextureIdMap.put((TextureStage)((Object)textureStage), (Object2ObjectMap<String, IntSupplier>)object2ObjectOpenHashMap);
        });
        this.noise = optional.flatMap(customTextureData -> {
            try {
                return Optional.of(this.createCustomTexture((CustomTextureData)customTextureData));
            }
            catch (IOException | class_151 throwable) {
                Iris.logger.error("Unable to parse the image data for the custom noise texture", throwable);
                return Optional.empty();
            }
        }).orElseGet(() -> {
            int n = packDirectives.getNoiseTextureResolution();
            NativeImageBackedNoiseTexture nativeImageBackedNoiseTexture = new NativeImageBackedNoiseTexture(n);
            this.ownedTextures.add((class_1044)nativeImageBackedNoiseTexture);
            return () -> ((class_1044)nativeImageBackedNoiseTexture).method_4624();
        });
    }

    private IntSupplier createCustomTexture(CustomTextureData customTextureData) throws IOException, class_151 {
        if (customTextureData instanceof CustomTextureData.PngData) {
            NativeImageBackedCustomTexture nativeImageBackedCustomTexture = new NativeImageBackedCustomTexture((CustomTextureData.PngData)customTextureData);
            this.ownedTextures.add((class_1044)nativeImageBackedCustomTexture);
            return () -> ((class_1044)nativeImageBackedCustomTexture).method_4624();
        }
        if (customTextureData instanceof CustomTextureData.LightmapMarker) {
            return () -> ((LightTextureAccessor)class_310.method_1551().field_1773.method_22974()).getLightTexture().method_4624();
        }
        if (customTextureData instanceof CustomTextureData.ResourceData) {
            CustomTextureData.ResourceData resourceData = (CustomTextureData.ResourceData)customTextureData;
            String string = resourceData.getNamespace();
            Object object = resourceData.getLocation();
            int n = FilenameUtils.indexOfExtension((String)object);
            Object object2 = n != -1 ? ((String)object).substring(0, n) : object;
            PBRType pBRType = PBRType.fromFileLocation((String)object2);
            class_1060 class_10602 = class_310.method_1551().method_1531();
            if (pBRType == null) {
                class_2960 class_29602 = new class_2960(string, (String)object);
                return () -> {
                    class_1044 class_10442 = class_10602.method_4619(class_29602);
                    return class_10442 != null ? class_10442.method_4624() : class_1047.method_4540().method_4624();
                };
            }
            object = ((String)object).substring(0, n - pBRType.getSuffix().length()) + ((String)object).substring(n);
            class_2960 class_29603 = new class_2960(string, (String)object);
            return () -> {
                class_1044 class_10442 = class_10602.method_4619(class_29603);
                if (class_10442 != null) {
                    int n = class_10442.method_4624();
                    PBRTextureHolder pBRTextureHolder = PBRTextureManager.INSTANCE.getOrLoadHolder(n);
                    class_1044 class_10443 = switch (pBRType) {
                        case PBRType.NORMAL -> pBRTextureHolder.getNormalTexture();
                        case PBRType.SPECULAR -> pBRTextureHolder.getSpecularTexture();
                        default -> throw new Error("Unknown PBRType '" + pBRType + "'");
                    };
                    TextureFormat textureFormat = TextureFormatLoader.getFormat();
                    if (textureFormat != null) {
                        int n2 = RenderSystem.getTextureId((int)GlStateManagerAccessor.getActiveTexture());
                        GlStateManager._bindTexture((int)class_10443.method_4624());
                        textureFormat.setupTextureParameters(pBRType, class_10443);
                        GlStateManager._bindTexture((int)n2);
                    }
                    return class_10443.method_4624();
                }
                return class_1047.method_4540().method_4624();
            };
        }
        throw new IllegalArgumentException("Unable to handle custom texture data " + customTextureData);
    }

    public EnumMap<TextureStage, Object2ObjectMap<String, IntSupplier>> getCustomTextureIdMap() {
        return this.customTextureIdMap;
    }

    public Object2ObjectMap<String, IntSupplier> getCustomTextureIdMap(TextureStage textureStage) {
        return this.customTextureIdMap.getOrDefault((Object)textureStage, (Object2ObjectMap<String, IntSupplier>)Object2ObjectMaps.emptyMap());
    }

    public IntSupplier getNoiseTexture() {
        return this.noise;
    }

    public void destroy() {
        this.ownedTextures.forEach(class_1044::close);
    }

    private /* synthetic */ void lambda$new$0(Object2ObjectMap object2ObjectMap, TextureStage textureStage, String string, CustomTextureData customTextureData) {
        try {
            object2ObjectMap.put((Object)string, (Object)this.createCustomTexture(customTextureData));
        }
        catch (IOException | class_151 throwable) {
            Iris.logger.error("Unable to parse the image data for the custom texture on stage " + textureStage + ", sampler " + string, throwable);
        }
    }
}

