/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.blending;

import java.util.Optional;

public enum AlphaTestFunction {
    NEVER(512, null),
    LESS(513, "<"),
    EQUAL(514, "=="),
    LEQUAL(515, "<="),
    GREATER(516, ">"),
    NOTEQUAL(517, "!="),
    GEQUAL(518, ">="),
    ALWAYS(519, null);

    private final int glId;
    private final String expression;

    private AlphaTestFunction(int n2, String string2) {
        this.glId = n2;
        this.expression = string2;
    }

    public static Optional<AlphaTestFunction> fromGlId(int n) {
        switch (n) {
            case 512: {
                return Optional.of(NEVER);
            }
            case 513: {
                return Optional.of(LESS);
            }
            case 514: {
                return Optional.of(EQUAL);
            }
            case 515: {
                return Optional.of(LEQUAL);
            }
            case 516: {
                return Optional.of(GREATER);
            }
            case 517: {
                return Optional.of(NOTEQUAL);
            }
            case 518: {
                return Optional.of(GEQUAL);
            }
            case 519: {
                return Optional.of(ALWAYS);
            }
        }
        return Optional.empty();
    }

    public static Optional<AlphaTestFunction> fromString(String string) {
        if ("GL_ALWAYS".equals(string)) {
            return Optional.of(ALWAYS);
        }
        try {
            return Optional.of(AlphaTestFunction.valueOf(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Optional.empty();
        }
    }

    public int getGlId() {
        return this.glId;
    }

    public String getExpression() {
        return this.expression;
    }
}

