/*
 * Decompiled with CFR 0.152.
 */
package link.infra.indium.renderer.render;

import java.util.function.Function;
import link.infra.indium.other.SpriteFinderCache;
import link.infra.indium.renderer.mesh.MutableQuadViewImpl;
import link.infra.indium.renderer.render.BaseQuadRenderer;
import me.jellysquid.mods.sodium.client.render.texture.SpriteUtil;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.minecraft.class_1058;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1921;
import net.minecraft.class_4581;
import net.minecraft.class_4588;

public abstract class VertexConsumerQuadBufferer
implements BaseQuadRenderer.QuadBufferer {
    protected final Function<class_1921, class_4588> bufferFunc;
    protected final class_1160 normalVec = new class_1160();

    protected abstract class_1159 matrix();

    protected abstract class_4581 normalMatrix();

    protected abstract int overlay();

    VertexConsumerQuadBufferer(Function<class_1921, class_4588> bufferFunc) {
        this.bufferFunc = bufferFunc;
    }

    @Override
    public void bufferQuad(MutableQuadViewImpl quad, class_1921 renderLayer) {
        VertexConsumerQuadBufferer.bufferQuad(this.bufferFunc.apply(renderLayer), quad, this.matrix(), this.overlay(), this.normalMatrix(), this.normalVec);
    }

    public static void bufferQuad(class_4588 buff, MutableQuadViewImpl quad, class_1159 matrix, int overlay, class_4581 normalMatrix, class_1160 normalVec) {
        boolean useNormals = quad.hasVertexNormals();
        if (useNormals) {
            quad.populateMissingNormals();
        } else {
            class_1160 faceNormal = quad.faceNormal();
            normalVec.method_4949(faceNormal.method_4943(), faceNormal.method_4945(), faceNormal.method_4947());
            normalVec.method_23215(normalMatrix);
        }
        for (int i = 0; i < 4; ++i) {
            buff.method_22918(matrix, quad.x(i), quad.y(i), quad.z(i));
            int color = quad.spriteColor(i, 0);
            buff.method_1336(color & 0xFF, color >> 8 & 0xFF, color >> 16 & 0xFF, color >> 24 & 0xFF);
            buff.method_22913(quad.spriteU(i, 0), quad.spriteV(i, 0));
            buff.method_22922(overlay);
            buff.method_22916(quad.lightmap(i));
            if (useNormals) {
                normalVec.method_4949(quad.normalX(i), quad.normalY(i), quad.normalZ(i));
                normalVec.method_23215(normalMatrix);
            }
            buff.method_22914(normalVec.method_4943(), normalVec.method_4945(), normalVec.method_4947());
            buff.method_1344();
        }
        class_1058 sprite = quad.cachedSprite();
        if (sprite == null) {
            sprite = SpriteFinderCache.forBlockAtlas().find((QuadView)quad, 0);
        }
        SpriteUtil.markSpriteActive((class_1058)sprite);
    }
}

