/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.handler;

import java.util.function.BiFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_437;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.handler.ItemGuiCreator;
import team.creative.creativecore.common.gui.integration.GuiScreenIntegration;
import team.creative.creativecore.common.gui.packet.OpenGuiPacket;
import team.creative.creativecore.common.util.registry.NamedHandlerRegistry;

public abstract class GuiCreator {
    public static final NamedHandlerRegistry<GuiCreator> REGISTRY = new NamedHandlerRegistry<Object>(null);
    public static final GuiCreatorItem ITEM_OPENER = GuiCreator.register("item", new GuiCreatorItem());
    public final BiFunction<class_2487, class_1657, GuiLayer> function;
    String name;

    public GuiCreator(BiFunction<class_2487, class_1657, GuiLayer> function) {
        this.function = function;
    }

    public static <T extends GuiCreator> T register(String name, T creator) {
        creator.name = name;
        REGISTRY.register(name, creator);
        return creator;
    }

    @Environment(value=EnvType.CLIENT)
    public static void openClientSide(GuiLayer layer) {
        class_310.method_1551().method_29970((class_437)new GuiScreenIntegration(layer));
    }

    public String getName() {
        return this.name;
    }

    protected void openGui(class_2487 nbt, class_1657 player) {
        if (player.field_6002.field_9236) {
            CreativeCore.NETWORK.sendToServer(new OpenGuiPacket(this.name, nbt));
        } else {
            OpenGuiPacket.openGuiOnServer(this, nbt, (class_3222)player);
        }
    }

    public static class GuiCreatorItem
    extends GuiCreator {
        public GuiCreatorItem() {
            super((nbt, player) -> {
                class_1268 hand = nbt.method_10577("main_hand") ? class_1268.field_5808 : class_1268.field_5810;
                class_1799 stack = player.method_5998(hand);
                class_1792 patt2791$temp = stack.method_7909();
                if (patt2791$temp instanceof ItemGuiCreator) {
                    ItemGuiCreator item = (ItemGuiCreator)patt2791$temp;
                    return item.create((class_2487)nbt, (class_1657)player);
                }
                return null;
            });
        }

        public void open(class_1657 player, class_1268 hand) {
            this.open(new class_2487(), player, hand);
        }

        public void open(class_2487 nbt, class_1657 player, class_1268 hand) {
            nbt.method_10556("main_hand", hand == class_1268.field_5808);
        }
    }

    public static class GuiCreatorBasic
    extends GuiCreator {
        public GuiCreatorBasic(BiFunction<class_2487, class_1657, GuiLayer> function) {
            super(function);
        }

        public void open(class_1657 player) {
            this.openGui(new class_2487(), player);
        }

        public void open(class_2487 nbt, class_1657 player) {
            this.openGui(nbt, player);
        }
    }
}

