/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.collection;

import java.util.ArrayList;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2189;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.controls.collection.GuiStackSelectorExtension;
import team.creative.creativecore.common.gui.controls.simple.GuiLabel;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.text.TextBuilder;
import team.creative.creativecore.common.util.type.map.HashMapList;

public class GuiStackSelector
extends GuiLabel {
    public StackCollector collector;
    public boolean extensionLostFocus;
    public class_1657 player;
    public boolean searchBar;
    protected GuiStackSelectorExtension extension;
    protected HashMapList<String, class_1799> stacks;
    protected class_1799 selected = class_1799.field_8037;

    public GuiStackSelector(String name, class_1657 player, StackCollector collector, boolean searchBar) {
        super(name);
        this.searchBar = searchBar;
        this.player = player;
        this.collector = collector;
        this.updateCollectedStacks();
        this.selectFirst();
        this.setAlign(Align.CENTER);
    }

    public GuiStackSelector(String name, int width, class_1657 player, StackCollector collector, boolean searchBar) {
        super(name, width, 14);
        this.searchBar = searchBar;
        this.player = player;
        this.collector = collector;
        this.updateCollectedStacks();
        this.selectFirst();
        this.setAlign(Align.CENTER);
    }

    public GuiStackSelector(String name, int width, class_1657 player, StackCollector collector) {
        this(name, width, player, collector, true);
    }

    public GuiStackSelector(String name, class_1657 player, StackCollector collector) {
        this(name, player, collector, true);
    }

    public static boolean contains(String search, class_1799 stack) {
        if (search.equals("")) {
            return true;
        }
        if (GuiStackSelector.getItemName(stack).toLowerCase().contains(search)) {
            return true;
        }
        for (class_2561 line : stack.method_7950(null, (class_1836)class_1836.class_1837.field_8934)) {
            if (!line.getString().toLowerCase().contains(search)) continue;
            return true;
        }
        return false;
    }

    public static String getItemName(class_1799 stack) {
        String itemName = "";
        try {
            itemName = stack.method_7954().getString();
        }
        catch (Exception e) {
            itemName = class_2378.field_11142.method_10221((Object)stack.method_7909()).toString();
        }
        return itemName;
    }

    @Override
    public boolean mouseClicked(Rect rect, double x, double y, int button) {
        if (this.extension == null) {
            this.openBox(rect);
        } else {
            this.closeBox();
        }
        GuiStackSelector.playSound(class_3417.field_15015);
        return true;
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.CLICKABLE;
    }

    public boolean selectFirst() {
        class_1799 first;
        if (this.stacks != null && (first = this.stacks.getFirst()) != null) {
            this.setSelected(first);
            return true;
        }
        return false;
    }

    @Override
    public class_1657 getPlayer() {
        return this.player;
    }

    public void updateCollectedStacks() {
        this.stacks = this.collector.collect(this.player);
    }

    public boolean setSelectedForce(class_1799 stack) {
        this.setTitle(new TextBuilder().stack(stack).add(stack.method_7964()).build());
        this.selected = stack;
        this.raiseEvent(new GuiControlChangedEvent(this));
        return true;
    }

    public boolean setSelected(class_1799 stack) {
        if (this.stacks.contains(stack)) {
            this.setTitle(new TextBuilder().stack(stack).add(stack.method_7964()).build());
            this.selected = stack;
            this.raiseEvent(new GuiControlChangedEvent(this));
            return true;
        }
        return false;
    }

    public HashMapList<String, class_1799> getStacks() {
        return this.stacks;
    }

    public class_1799 getSelected() {
        return this.selected;
    }

    public void openBox(Rect rect) {
        this.extension = this.createBox();
        GuiLayer layer = this.getLayer();
        GuiChildControl child = layer.addHover(this.extension);
        this.extension.init();
        child.setX((int)rect.minX);
        child.setY((int)rect.maxY);
        child.setWidth((int)rect.getWidth());
        child.flowX();
        child.setHeight(child.getPreferredHeight());
        child.flowY();
        if (child.getY() + child.getHeight() > layer.getHeight() && rect.minY >= (double)child.getHeight()) {
            child.setY(child.getY() - (int)rect.getHeight() + child.getHeight());
        }
    }

    public void closeBox() {
        if (this.extension != null) {
            this.getLayer().remove(this.extension);
            this.extension = null;
        }
    }

    protected GuiStackSelectorExtension createBox() {
        return new GuiStackSelectorExtension(this.name + "extension", this.getPlayer(), this);
    }

    public boolean select(String line) {
        return false;
    }

    @Override
    public void looseFocus() {
        if (this.extensionLostFocus && this.extension != null) {
            this.closeBox();
        }
    }

    public static abstract class StackCollector {
        public StackSelector selector;

        public StackCollector(StackSelector selector) {
            this.selector = selector;
        }

        public abstract HashMapList<String, class_1799> collect(class_1657 var1);
    }

    public static class GuiBlockSelector
    extends SearchSelector {
        @Override
        public boolean allow(class_1799 stack) {
            if (super.allow(stack)) {
                return class_2248.method_9503((class_1792)stack.method_7909()) != null && !(class_2248.method_9503((class_1792)stack.method_7909()) instanceof class_2189);
            }
            return false;
        }
    }

    public static class SearchSelector
    extends StackSelector {
        public String search = "";

        @Override
        public boolean allow(class_1799 stack) {
            return GuiStackSelector.contains(this.search, stack);
        }
    }

    public static abstract class StackSelector {
        public abstract boolean allow(class_1799 var1);
    }

    public static class CreativeCollector
    extends InventoryCollector {
        public CreativeCollector(StackSelector selector) {
            super(selector);
        }

        @Override
        public HashMapList<String, class_1799> collect(class_1657 player) {
            HashMapList<String, class_1799> stacks = super.collect(player);
            class_2371 tempStacks = class_2371.method_10211();
            for (class_1792 item : class_2378.field_11142) {
                item.method_7850(class_1761.field_7915, tempStacks);
            }
            ArrayList<class_1799> newStacks = new ArrayList<class_1799>();
            for (class_1799 stack : tempStacks) {
                if (stack.method_7960() || !this.selector.allow(stack)) continue;
                newStacks.add(stack);
            }
            stacks.add("collector.all", (class_1799)newStacks);
            return stacks;
        }
    }

    public static class InventoryCollector
    extends StackCollector {
        public InventoryCollector(StackSelector selector) {
            super(selector);
        }

        @Override
        public HashMapList<String, class_1799> collect(class_1657 player) {
            HashMapList<String, class_1799> stacks = new HashMapList<String, class_1799>();
            if (player != null) {
                ArrayList<class_1799> tempStacks = new ArrayList<class_1799>();
                for (class_1799 stack : player.field_7498.method_7602()) {
                    if (stack.method_7960() || !this.selector.allow(stack)) continue;
                    tempStacks.add(stack.method_7972());
                }
                stacks.add("collector.inventory", (class_1799)tempStacks);
            }
            return stacks;
        }
    }
}

