/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.event;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Logger;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.Side;
import team.creative.creativecore.common.config.holder.ConfigKey;
import team.creative.creativecore.common.config.holder.CreativeConfigRegistry;
import team.creative.creativecore.common.config.holder.ICreativeConfigHolder;
import team.creative.creativecore.common.config.sync.ConfigurationClientPacket;
import team.creative.creativecore.common.config.sync.ConfigurationPacket;
import team.creative.creativecore.common.util.mc.JsonUtils;

public class ConfigEventHandler {
    private final DecimalFormat df = this.generateFormat();
    private final File CONFIG_DIRECTORY;
    private final Logger LOGGER;
    private final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public ConfigEventHandler(File CONFIG_DIRECTORY, Logger LOGGER) {
        this.CONFIG_DIRECTORY = CONFIG_DIRECTORY;
        this.LOGGER = LOGGER;
        ServerPlayConnectionEvents.JOIN.register(this::playerLoggedIn);
        ServerHandler.INSTANCE.register(this);
    }

    public static List<String> loadClientFieldList(ICreativeConfigHolder holder) {
        ArrayList<String> enabled = new ArrayList<String>();
        for (ConfigKey configKey : holder.fields()) {
            if (!configKey.isWithoutForce(Side.CLIENT)) continue;
            ConfigEventHandler.loadClientFieldList(holder, configKey, enabled);
        }
        return enabled;
    }

    private static List<String> loadClientFieldList(ICreativeConfigHolder parent, ConfigKey field, List<String> list) {
        if (field.forceSynchronization) {
            list.add((String)(parent.path().length > 0 ? String.join((CharSequence)".", parent.path()) + "." : "") + field.name);
            return list;
        }
        if (field.get() instanceof ICreativeConfigHolder) {
            ICreativeConfigHolder holder = (ICreativeConfigHolder)field.get();
            for (ConfigKey configKey : holder.fields()) {
                if (!configKey.isWithoutForce(Side.CLIENT)) continue;
                ConfigEventHandler.loadClientFieldList(holder, configKey, list);
            }
        }
        return list;
    }

    public static void saveClientFieldList(ICreativeConfigHolder holder, List<String> enabled) {
        for (ConfigKey configKey : holder.fields()) {
            if (!configKey.isWithoutForce(Side.CLIENT)) continue;
            ConfigEventHandler.saveClientFieldList(String.join((CharSequence)".", holder.path()), configKey, enabled);
        }
    }

    private static void saveClientFieldList(String path, ConfigKey field, List<String> enabled) {
        if (!((String)path).isEmpty()) {
            path = (String)path + ".";
        }
        if (enabled.contains(path = (String)path + field.name)) {
            ConfigEventHandler.enable(field);
        } else {
            field.forceSynchronization = false;
            Object object = field.get();
            if (object instanceof ICreativeConfigHolder) {
                for (ConfigKey configKey : ((ICreativeConfigHolder)object).fields()) {
                    if (!configKey.isWithoutForce(Side.CLIENT)) continue;
                    ConfigEventHandler.saveClientFieldList((String)path, configKey, enabled);
                }
            }
        }
    }

    private static void enable(ConfigKey field) {
        field.forceSynchronization = true;
        Object object = field.get();
        if (object instanceof ICreativeConfigHolder) {
            for (ConfigKey configKey : ((ICreativeConfigHolder)object).fields()) {
                if (!configKey.isWithoutForce(Side.CLIENT)) continue;
                ConfigEventHandler.enable(configKey);
            }
        }
    }

    private DecimalFormat generateFormat() {
        DecimalFormat df = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        df.setMaximumFractionDigits(340);
        return df;
    }

    public void playerLoggedIn(class_3244 handler, PacketSender sender, MinecraftServer server) {
        if (!server.method_3724() || !this.isOwner(server)) {
            CreativeCore.NETWORK.sendToClient(new ConfigurationClientPacket(CreativeConfigRegistry.ROOT), handler.method_32311());
            CreativeCore.NETWORK.sendToClient(new ConfigurationPacket(CreativeConfigRegistry.ROOT, false), handler.method_32311());
        }
    }

    @Environment(value=EnvType.CLIENT)
    public boolean isOwner(MinecraftServer server) {
        return server.method_3811().equals(class_310.method_1551().method_1548().method_1676());
    }

    public void sync(ICreativeConfigHolder holder, MinecraftServer server) {
        CreativeCore.NETWORK.sendToClientAll(server, new ConfigurationPacket(holder, true));
    }

    public void sync(ICreativeConfigHolder holder, class_3222 player) {
        CreativeCore.NETWORK.sendToClient(new ConfigurationPacket(holder, true), player);
    }

    public void syncAll(MinecraftServer server) {
        this.sync((ICreativeConfigHolder)CreativeConfigRegistry.ROOT, server);
    }

    public void syncAll(class_3222 player) {
        this.sync((ICreativeConfigHolder)CreativeConfigRegistry.ROOT, player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveClientFields() {
        File config = new File(this.CONFIG_DIRECTORY, "client-fields.json");
        List<String> enabled = ConfigEventHandler.loadClientFieldList(CreativeConfigRegistry.ROOT);
        if (enabled.isEmpty()) {
            config.delete();
            return;
        }
        JsonArray array = new JsonArray();
        for (int i = 0; i < enabled.size(); ++i) {
            array.add(enabled.get(i));
        }
        try (FileWriter writer = new FileWriter(config);){
            this.GSON.toJson((JsonElement)array, (Appendable)writer);
        }
        catch (IOException e) {
            this.LOGGER.error("Failed to save client field config file {0}", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String modid, Side side) {
        block7: {
            try {
                Object object = CreativeConfigRegistry.ROOT.get(modid);
                File config = new File(this.CONFIG_DIRECTORY, modid + (side.isClient() ? "-client" : "") + ".json");
                if (object instanceof ICreativeConfigHolder || object == null) {
                    ICreativeConfigHolder holder = (ICreativeConfigHolder)object;
                    JsonObject json = holder.save(true, false, side);
                    JsonUtils.cleanUp(json);
                    if (json.size() <= 0) break block7;
                    FileWriter writer = new FileWriter(config);
                    JsonWriter jsonWriter = new JsonWriter(writer){

                        public JsonWriter value(double value) throws IOException {
                            if (Double.isNaN(value) || Double.isInfinite(value)) {
                                throw new IllegalArgumentException("Numeric values must be finite, but was " + value);
                            }
                            return this.jsonValue(ConfigEventHandler.this.df.format(value));
                        }

                        public JsonWriter value(Number value) throws IOException {
                            if (value instanceof Double || value.getClass() == Double.TYPE) {
                                return this.value((Double)value);
                            }
                            return super.value(value);
                        }
                    };
                    jsonWriter.setIndent("  ");
                    try {
                        this.GSON.toJson((JsonElement)json, jsonWriter);
                        break block7;
                    }
                    finally {
                        writer.close();
                    }
                }
                if (config.exists()) {
                    config.delete();
                }
            }
            catch (IOException e) {
                this.LOGGER.error("Failed to save config file of '{0}', {1}", (Object)modid, (Object)e);
            }
        }
    }

    public void save(Side side) {
        for (String modid : CreativeConfigRegistry.ROOT.names()) {
            this.save(modid, side);
        }
    }

    public void loadClientFields() {
        ArrayList<String> list;
        block6: {
            File config = new File(this.CONFIG_DIRECTORY, "client-fields.json");
            if (config.exists()) {
                try {
                    FileReader reader = new FileReader(config);
                    JsonArray array = (JsonArray)this.GSON.fromJson((Reader)reader, JsonArray.class);
                    if (array != null) {
                        list = new ArrayList<String>(array.size());
                        for (int i = 0; i < array.size(); ++i) {
                            JsonElement element = array.get(i);
                            if (!element.isJsonPrimitive() || !((JsonPrimitive)element).isString()) continue;
                            list.add(element.getAsString());
                        }
                        break block6;
                    }
                    list = Collections.EMPTY_LIST;
                }
                catch (FileNotFoundException e) {
                    list = Collections.EMPTY_LIST;
                    this.LOGGER.error("Failed to load client fields config file, {0}", (Throwable)e);
                }
            } else {
                list = Collections.EMPTY_LIST;
            }
        }
        ConfigEventHandler.saveClientFieldList(CreativeConfigRegistry.ROOT, (List<String>)list);
    }

    public void load(String modid, Side side) {
        Object object = CreativeConfigRegistry.ROOT.get(modid);
        if (object instanceof ICreativeConfigHolder) {
            ICreativeConfigHolder holder = (ICreativeConfigHolder)object;
            File config = new File(this.CONFIG_DIRECTORY, modid + (side.isClient() ? "-client" : "") + ".json");
            if (config.exists()) {
                try {
                    FileReader reader = new FileReader(config);
                    JsonObject json = null;
                    try {
                        json = (JsonObject)this.GSON.fromJson((Reader)reader, JsonObject.class);
                    }
                    catch (JsonSyntaxException e) {
                        e.printStackTrace();
                    }
                    if (json == null) {
                        json = new JsonObject();
                    }
                    holder.load(true, false, json, side);
                }
                catch (FileNotFoundException e) {
                    this.LOGGER.error("Failed to load config file of '{0}', {1}", (Object)modid, (Object)e);
                }
            } else {
                holder.restoreDefault(side, false);
            }
        }
    }

    public void load(Side side) {
        this.loadClientFields();
        for (String modid : CreativeConfigRegistry.ROOT.names()) {
            this.load(modid, side);
        }
        this.save(side);
    }

    public boolean isSynchronizedWithServer(String key) {
        String[] path = key.split(".");
        ConfigKey config = CreativeConfigRegistry.ROOT.findKey(path);
        if (config != null) {
            return config.is(Side.SERVER);
        }
        return false;
    }

    public boolean modFileExist(String modid, EnvType side) {
        File config = new File(this.CONFIG_DIRECTORY, modid + (side == EnvType.CLIENT ? "-client" : "") + ".json");
        return config.exists();
    }

    private static class ServerHandler {
        public static ServerHandler INSTANCE = new ClientHandler();

        private ServerHandler() {
        }

        public void register(ConfigEventHandler handler) {
            ServerLifecycleEvents.SERVER_STARTING.register(server -> handler.load(Side.SERVER));
        }
    }

    private static class ClientHandler
    extends ServerHandler {
        private ClientHandler() {
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        public void register(ConfigEventHandler handler) {
            ClientLifecycleEvents.CLIENT_STARTED.register((Object)new Handler(handler));
        }

        @Environment(value=EnvType.CLIENT)
        private static class Handler
        implements ClientLifecycleEvents.ClientStarted {
            private final ConfigEventHandler configEventHandler;

            Handler(ConfigEventHandler configEventHandler) {
                this.configEventHandler = configEventHandler;
            }

            public void onClientStarted(class_310 client) {
                this.configEventHandler.load(Side.CLIENT);
            }
        }
    }
}

