/*
 * Decompiled with CFR 0.152.
 */
package com.chocohead.mm;

import java.util.Map;
import java.util.function.Consumer;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.ext.IExtension;
import org.spongepowered.asm.mixin.transformer.ext.ITargetClassContext;

final class Extension
implements IExtension {
    private final String mixinPackage;
    private final Map<String, Consumer<ClassNode>> classReplacers;

    Extension(String mixinPackage, Map<String, Consumer<ClassNode>> classReplacers) {
        this.mixinPackage = mixinPackage;
        this.classReplacers = classReplacers;
    }

    public boolean checkActive(MixinEnvironment environment) {
        return true;
    }

    public void preApply(ITargetClassContext context) {
        Consumer<ClassNode> replacer;
        ClassInfo info = context.getClassInfo();
        if (!info.isMixin() && (replacer = this.classReplacers.get(info.getName())) != null) {
            replacer.accept(context.getClassNode());
        }
    }

    public void postApply(ITargetClassContext context) {
        ClassInfo info = context.getClassInfo();
        if (!info.isMixin()) {
            ClassNode node = context.getClassNode();
            if (node.signature.contains(this.mixinPackage + info.getName())) {
                node.signature = node.signature.replace('L' + this.mixinPackage + info.getName() + ';', "");
            }
        }
    }

    public void export(MixinEnvironment env, String name, boolean force, ClassNode classNode) {
    }
}

