/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Set;
import net.coderbot.iris.Iris;
import net.coderbot.iris.shaderpack.CloudSetting;
import net.coderbot.iris.shaderpack.DirectiveHolder;
import net.coderbot.iris.shaderpack.PackRenderTargetDirectives;
import net.coderbot.iris.shaderpack.PackShadowDirectives;
import net.coderbot.iris.shaderpack.ShaderProperties;

public class PackDirectives {
    private int noiseTextureResolution = 256;
    private float sunPathRotation = 0.0f;
    private float ambientOcclusionLevel = 1.0f;
    private float wetnessHalfLife = 600.0f;
    private float drynessHalfLife = 200.0f;
    private float eyeBrightnessHalfLife = 10.0f;
    private float centerDepthHalfLife = 1.0f;
    private CloudSetting cloudSetting;
    private boolean underwaterOverlay;
    private boolean vignette;
    private boolean sun;
    private boolean moon;
    private boolean rainDepth;
    private boolean separateAo;
    private boolean oldLighting;
    private boolean oldHandLight;
    private boolean particlesBeforeDeferred;
    private boolean prepareBeforeShadow;
    private Object2ObjectMap<String, Object2BooleanMap<String>> explicitFlips = new Object2ObjectOpenHashMap();
    private final PackRenderTargetDirectives renderTargetDirectives;
    private final PackShadowDirectives shadowDirectives;

    private PackDirectives(Set<Integer> set, PackShadowDirectives packShadowDirectives) {
        this.renderTargetDirectives = new PackRenderTargetDirectives(set);
        this.shadowDirectives = packShadowDirectives;
    }

    PackDirectives(Set<Integer> set, ShaderProperties shaderProperties) {
        this(set, new PackShadowDirectives(shaderProperties));
        this.cloudSetting = shaderProperties.getCloudSetting();
        this.underwaterOverlay = shaderProperties.getUnderwaterOverlay().orElse(false);
        this.vignette = shaderProperties.getVignette().orElse(false);
        this.sun = shaderProperties.getSun().orElse(true);
        this.moon = shaderProperties.getMoon().orElse(true);
        this.rainDepth = shaderProperties.getRainDepth().orElse(false);
        this.separateAo = shaderProperties.getSeparateAo().orElse(false);
        this.oldLighting = shaderProperties.getOldLighting().orElse(false);
        this.oldHandLight = shaderProperties.getOldHandLight().orElse(true);
        this.explicitFlips = shaderProperties.getExplicitFlips();
        this.particlesBeforeDeferred = shaderProperties.getParticlesBeforeDeferred().orElse(false);
        this.prepareBeforeShadow = shaderProperties.getPrepareBeforeShadow().orElse(false);
    }

    PackDirectives(Set<Integer> set, PackDirectives packDirectives) {
        this(set, new PackShadowDirectives(packDirectives.getShadowDirectives()));
        this.cloudSetting = packDirectives.cloudSetting;
        this.separateAo = packDirectives.separateAo;
        this.oldLighting = packDirectives.oldLighting;
        this.explicitFlips = packDirectives.explicitFlips;
        this.particlesBeforeDeferred = packDirectives.particlesBeforeDeferred;
        this.prepareBeforeShadow = packDirectives.prepareBeforeShadow;
    }

    public int getNoiseTextureResolution() {
        return this.noiseTextureResolution;
    }

    public float getSunPathRotation() {
        return this.sunPathRotation;
    }

    public float getAmbientOcclusionLevel() {
        return this.ambientOcclusionLevel;
    }

    public float getWetnessHalfLife() {
        return this.wetnessHalfLife;
    }

    public float getDrynessHalfLife() {
        return this.drynessHalfLife;
    }

    public float getEyeBrightnessHalfLife() {
        return this.eyeBrightnessHalfLife;
    }

    public float getCenterDepthHalfLife() {
        return this.centerDepthHalfLife;
    }

    public CloudSetting getCloudSetting() {
        return this.cloudSetting;
    }

    public boolean underwaterOverlay() {
        return this.underwaterOverlay;
    }

    public boolean vignette() {
        return this.vignette;
    }

    public boolean shouldRenderSun() {
        return this.sun;
    }

    public boolean shouldRenderMoon() {
        return this.moon;
    }

    public boolean rainDepth() {
        return this.rainDepth;
    }

    public boolean shouldUseSeparateAo() {
        return this.separateAo;
    }

    public boolean isOldLighting() {
        return this.oldLighting;
    }

    public boolean isOldHandLight() {
        return this.oldHandLight;
    }

    public boolean areParticlesBeforeDeferred() {
        return this.particlesBeforeDeferred;
    }

    public boolean isPrepareBeforeShadow() {
        return this.prepareBeforeShadow;
    }

    public PackRenderTargetDirectives getRenderTargetDirectives() {
        return this.renderTargetDirectives;
    }

    public PackShadowDirectives getShadowDirectives() {
        return this.shadowDirectives;
    }

    private static float clamp(float f, float f2, float f3) {
        return Math.max(f2, Math.min(f3, f));
    }

    public void acceptDirectivesFrom(DirectiveHolder directiveHolder) {
        this.renderTargetDirectives.acceptDirectives(directiveHolder);
        this.shadowDirectives.acceptDirectives(directiveHolder);
        directiveHolder.acceptConstIntDirective("noiseTextureResolution", n -> {
            this.noiseTextureResolution = n;
        });
        directiveHolder.acceptConstFloatDirective("sunPathRotation", f -> {
            this.sunPathRotation = f;
        });
        directiveHolder.acceptConstFloatDirective("ambientOcclusionLevel", f -> {
            this.ambientOcclusionLevel = PackDirectives.clamp(f, 0.0f, 1.0f);
        });
        directiveHolder.acceptConstFloatDirective("wetnessHalflife", f -> {
            this.wetnessHalfLife = f;
        });
        directiveHolder.acceptConstFloatDirective("drynessHalflife", f -> {
            this.wetnessHalfLife = f;
        });
        directiveHolder.acceptConstFloatDirective("eyeBrightnessHalflife", f -> {
            this.eyeBrightnessHalfLife = f;
        });
        directiveHolder.acceptConstFloatDirective("centerDepthHalflife", f -> {
            this.centerDepthHalfLife = f;
        });
    }

    public ImmutableMap<Integer, Boolean> getExplicitFlips(String string) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Object2BooleanMap object2BooleanMap = (Object2BooleanMap)this.explicitFlips.get((Object)string);
        if (object2BooleanMap == null) {
            object2BooleanMap = Object2BooleanMaps.emptyMap();
        }
        object2BooleanMap.forEach((string2, bl) -> {
            int n = PackRenderTargetDirectives.LEGACY_RENDER_TARGETS.indexOf(string2);
            if (n == -1 && string2.startsWith("colortex")) {
                String string3 = string2.substring("colortex".length());
                try {
                    n = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (n != -1) {
                builder.put((Object)n, bl);
            } else {
                Iris.logger.warn("Unknown buffer with ID " + string2 + " specified in flip directive for pass " + string);
            }
        });
        return builder.build();
    }
}

