/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.patcher;

import net.coderbot.iris.gbuffer_overrides.matching.InputAvailability;
import net.coderbot.iris.gl.shader.ShaderType;
import net.coderbot.iris.shaderpack.transform.StringTransformations;
import net.coderbot.iris.shaderpack.transform.Transformations;

public class AttributeShaderTransformer {
    public static String patch(String string, ShaderType shaderType, boolean bl, InputAvailability inputAvailability) {
        if (string.contains("iris_")) {
            throw new IllegalStateException("Shader is attempting to exploit internal Iris code!");
        }
        StringTransformations stringTransformations = new StringTransformations(string);
        if (!inputAvailability.lightmap) {
            stringTransformations.replaceExact("gl_MultiTexCoord1", "vec4(240.0, 240.0, 0.0, 1.0)");
            stringTransformations.replaceExact("gl_MultiTexCoord2", "vec4(240.0, 240.0, 0.0, 1.0)");
        } else {
            stringTransformations.replaceExact("gl_MultiTexCoord1", "gl_MultiTexCoord2");
        }
        if (!inputAvailability.texture) {
            stringTransformations.define("gl_MultiTexCoord0", "vec4(240.0, 240.0, 0.0, 1.0)");
        }
        AttributeShaderTransformer.patchTextureMatrices(stringTransformations, inputAvailability.lightmap);
        if (inputAvailability.overlay) {
            AttributeShaderTransformer.patchOverlayColor(stringTransformations, shaderType, bl);
        }
        if (stringTransformations.contains("gl_MultiTexCoord3") && !stringTransformations.contains("mc_midTexCoord") && shaderType == ShaderType.VERTEX) {
            stringTransformations.replaceExact("gl_MultiTexCoord3", "mc_midTexCoord");
            stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "attribute vec4 mc_midTexCoord;");
        }
        return stringTransformations.toString();
    }

    public static void patchOverlayColor(StringTransformations stringTransformations, ShaderType shaderType, boolean bl) {
        if (shaderType == ShaderType.VERTEX) {
            stringTransformations.replaceRegex("uniform\\s+vec4\\s+entityColor;", "");
            stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "uniform sampler2D iris_overlay;");
            stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "out vec4 entityColor;");
            stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "out vec4 iris_vertexColor;");
            if (stringTransformations.contains("irisMain_overlayColor")) {
                throw new IllegalStateException("Shader already contains \"irisMain_overlayColor\"???");
            }
            stringTransformations.replaceExact("main", "irisMain_overlayColor");
            stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "in ivec2 iris_UV1;\n");
            stringTransformations.injectLine(Transformations.InjectionPoint.END, "void main() {\n\tvec4 overlayColor = texelFetch(iris_overlay, iris_UV1, 0);\n\tentityColor = vec4(overlayColor.rgb, 1.0 - overlayColor.a);\n\tiris_vertexColor = iris_Color;\n\tentityColor.rgb *= float(entityColor.a != 0.0);\n\n    irisMain_overlayColor();\n}");
        } else if (shaderType == ShaderType.GEOMETRY) {
            stringTransformations.replaceRegex("uniform\\s+vec4\\s+entityColor;", "");
            stringTransformations.replaceExact("entityColor", "entityColor[0]");
            stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "out vec4 entityColorGS;");
            stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "in vec4 entityColor[];");
            stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "out vec4 iris_vertexColorGS;");
            stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "in vec4 iris_vertexColor[];");
            if (stringTransformations.contains("irisMain")) {
                throw new IllegalStateException("Shader already contains \"irisMain\"???");
            }
            stringTransformations.replaceExact("main", "irisMain");
            stringTransformations.injectLine(Transformations.InjectionPoint.END, "void main() {\n\t entityColorGS = entityColor[0];\n\t iris_vertexColorGS = iris_vertexColor[0];\n    irisMain();\n}");
        } else if (shaderType == ShaderType.FRAGMENT) {
            stringTransformations.replaceRegex("uniform\\s+vec4\\s+entityColor;", "in vec4 entityColor;");
            stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "in vec4 iris_vertexColor;");
            if (bl) {
                stringTransformations.replaceExact("entityColor", "entityColorGS");
                stringTransformations.replaceExact("iris_vertexColor", "iris_vertexColorGS");
            }
        }
    }

    private static void patchTextureMatrices(StringTransformations stringTransformations, boolean bl) {
        stringTransformations.replaceExact("gl_TextureMatrix", "iris_TextureMatrix");
        stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "const float iris_ONE_OVER_256 = 0.00390625;\n");
        stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "const float iris_ONE_OVER_32 = iris_ONE_OVER_256 * 8;\n");
        if (bl) {
            stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "mat4 iris_LightmapTextureMatrix = gl_TextureMatrix[2];\n");
        } else {
            stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "mat4 iris_LightmapTextureMatrix =mat4(iris_ONE_OVER_256, 0.0, 0.0, 0.0,     0.0, iris_ONE_OVER_256, 0.0, 0.0,     0.0, 0.0, iris_ONE_OVER_256, 0.0,     iris_ONE_OVER_32, iris_ONE_OVER_32, iris_ONE_OVER_32, iris_ONE_OVER_256);");
        }
        stringTransformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "mat4 iris_TextureMatrix[8] = mat4[8](gl_TextureMatrix[0],iris_LightmapTextureMatrix,mat4(1.0),mat4(1.0),mat4(1.0),mat4(1.0),mat4(1.0),mat4(1.0));\n");
    }
}

