/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.uniform;

import java.util.function.Supplier;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.uniform.Uniform;
import net.coderbot.iris.vendored.joml.Vector3d;
import net.coderbot.iris.vendored.joml.Vector3f;
import net.coderbot.iris.vendored.joml.Vector4f;

public class Vector3Uniform
extends Uniform {
    private final Vector3f cachedValue = new Vector3f();
    private final Supplier<Vector3f> value;

    Vector3Uniform(int n, Supplier<Vector3f> supplier) {
        super(n);
        this.value = supplier;
    }

    static Vector3Uniform converted(int n, Supplier<Vector3d> supplier) {
        Vector3f vector3f = new Vector3f();
        return new Vector3Uniform(n, () -> {
            Vector3d vector3d = (Vector3d)supplier.get();
            vector3f.set((float)vector3d.x, (float)vector3d.y, (float)vector3d.z);
            return vector3f;
        });
    }

    static Vector3Uniform truncated(int n, Supplier<Vector4f> supplier) {
        Vector3f vector3f = new Vector3f();
        return new Vector3Uniform(n, () -> {
            Vector4f vector4f = (Vector4f)supplier.get();
            vector3f.set(vector4f.x(), vector4f.y(), vector4f.z());
            return vector3f;
        });
    }

    @Override
    public void update() {
        Vector3f vector3f = this.value.get();
        if (!vector3f.equals(this.cachedValue)) {
            this.cachedValue.set(vector3f.x(), vector3f.y(), vector3f.z());
            IrisRenderSystem.uniform3f(this.location, this.cachedValue.x(), this.cachedValue.y(), this.cachedValue.z());
        }
    }
}

