/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.forge.mixins;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.seibel.lod.core.api.ClientApi;
import com.seibel.lod.core.objects.math.Mat4f;
import forge.com.seibel.lod.common.Config;
import forge.com.seibel.lod.common.wrappers.McObjectConverter;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public class MixinWorldRenderer {
    private static float previousPartialTicks = 0.0f;

    public MixinWorldRenderer() {
        throw new NullPointerException("Null cannot be cast to non-null type.");
    }

    @Inject(method={"renderClouds"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderClouds(PoseStack poseStack, Matrix4f projectionMatrix, float tickDelta, double cameraX, double cameraY, double cameraZ, CallbackInfo ci) {
        previousPartialTicks = tickDelta;
    }

    @Inject(at={@At(value="HEAD")}, method={"renderChunkLayer(Lnet/minecraft/client/renderer/RenderType;Lcom/mojang/blaze3d/vertex/PoseStack;DDDLcom/mojang/math/Matrix4f;)V"}, cancellable=true)
    private void renderChunkLayer(RenderType renderType, PoseStack modelViewMatrixStack, double cameraXBlockPos, double cameraYBlockPos, double cameraZBlockPos, Matrix4f projectionMatrix, CallbackInfo callback) {
        if (renderType.equals(RenderType.m_110451_())) {
            Mat4f mcModelViewMatrix = McObjectConverter.Convert(modelViewMatrixStack.m_85850_().m_85861_());
            Mat4f mcProjectionMatrix = McObjectConverter.Convert(projectionMatrix);
            ClientApi.INSTANCE.renderLods(mcModelViewMatrix, mcProjectionMatrix, previousPartialTicks);
        }
        if (Config.Client.Advanced.lodOnlyMode) {
            callback.cancel();
        }
    }
}

