/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.util.gridList;

import java.util.ArrayList;
import java.util.function.Consumer;

@Deprecated
public class MovableCenteredGridList<T>
extends ArrayList<T> {
    private int centerX;
    private int centerY;
    public final int gridCentreToEdge;
    public final int gridSize;

    public MovableCenteredGridList(MovableCenteredGridList<T> other) {
        super(other);
        this.centerX = other.centerX;
        this.centerY = other.centerY;
        this.gridCentreToEdge = other.gridCentreToEdge;
        this.gridSize = other.gridSize;
    }

    public MovableCenteredGridList(int gridCentreToEdge, int centerX, int centerY) {
        super((gridCentreToEdge * 2 + 1) * (gridCentreToEdge * 2 + 1));
        this.gridSize = gridCentreToEdge * 2 + 1;
        this.gridCentreToEdge = gridCentreToEdge;
        this.centerX = centerX;
        this.centerY = centerY;
        this.clear();
    }

    @Override
    public void clear() {
        super.clear();
        super.ensureCapacity(this.gridSize * this.gridSize);
        for (int i = 0; i < this.gridSize * this.gridSize; ++i) {
            super.add(null);
        }
    }

    public void clear(Consumer<? super T> d) {
        super.forEach((? super E t) -> {
            if (t != null) {
                d.accept(t);
            }
        });
        super.clear();
        super.ensureCapacity(this.gridSize * this.gridSize);
        for (int i = 0; i < this.gridSize * this.gridSize; ++i) {
            super.add(null);
        }
    }

    public int getCenterX() {
        return this.centerX;
    }

    public int getCenterY() {
        return this.centerY;
    }

    public T get(int x, int y) {
        x = x - this.centerX + this.gridCentreToEdge;
        y = y - this.centerY + this.gridCentreToEdge;
        return this._getDirect(x, y);
    }

    public boolean set(int x, int y, T t) {
        x = x - this.centerX + this.gridCentreToEdge;
        y = y - this.centerY + this.gridCentreToEdge;
        return this._setDirect(x, y, t);
    }

    public T setAndGet(int x, int y, T t) {
        return (T)(this._setDirect(x = x - this.centerX + this.gridCentreToEdge, y = y - this.centerY + this.gridCentreToEdge, t) ? t : null);
    }

    public T swap(int x, int y, T t) {
        x = x - this.centerX + this.gridCentreToEdge;
        y = y - this.centerY + this.gridCentreToEdge;
        return this._swapDirect(x, y, t);
    }

    public boolean inRange(int x, int y) {
        x = x - this.centerX + this.gridCentreToEdge;
        y = y - this.centerY + this.gridCentreToEdge;
        return x >= 0 && x < this.gridSize && y >= 0 && y < this.gridSize;
    }

    private T _getDirect(int x, int y) {
        if (x < 0 || x >= this.gridSize || y < 0 || y >= this.gridSize) {
            return null;
        }
        return (T)super.get(x + y * this.gridSize);
    }

    private boolean _setDirect(int x, int y, T t) {
        if (x < 0 || x >= this.gridSize || y < 0 || y >= this.gridSize) {
            return false;
        }
        super.set(x + y * this.gridSize, t);
        return true;
    }

    private T _swapDirect(int x, int y, T t) {
        if (x < 0 || x >= this.gridSize || y < 0 || y >= this.gridSize) {
            return null;
        }
        return super.set(x + y * this.gridSize, t);
    }

    public boolean move(int newCenterX, int newCenterY) {
        if (this.centerX == newCenterX && this.centerY == newCenterY) {
            return false;
        }
        int deltaX = newCenterX - this.centerX;
        int deltaY = newCenterY - this.centerY;
        if (Math.abs(deltaX) >= this.gridSize || Math.abs(deltaY) >= this.gridSize) {
            this.clear();
            this.centerX = newCenterX;
            this.centerY = newCenterY;
            return true;
        }
        this.centerX = newCenterX;
        this.centerY = newCenterY;
        if (deltaX >= 0 && deltaY >= 0) {
            for (int x = 0; x < this.gridSize; ++x) {
                for (int y = 0; y < this.gridSize; ++y) {
                    this._setDirect(x, y, this._getDirect(x + deltaX, y + deltaY));
                }
            }
        } else if (deltaX < 0 && deltaY >= 0) {
            for (int x = this.gridSize - 1; x >= 0; --x) {
                for (int y = 0; y < this.gridSize; ++y) {
                    this._setDirect(x, y, this._getDirect(x + deltaX, y + deltaY));
                }
            }
        } else if (deltaX >= 0 && deltaY < 0) {
            for (int x = 0; x < this.gridSize; ++x) {
                for (int y = this.gridSize - 1; y >= 0; --y) {
                    this._setDirect(x, y, this._getDirect(x + deltaX, y + deltaY));
                }
            }
        } else {
            for (int x = this.gridSize - 1; x >= 0; --x) {
                for (int y = this.gridSize - 1; y >= 0; --y) {
                    this._setDirect(x, y, this._getDirect(x + deltaX, y + deltaY));
                }
            }
        }
        return true;
    }

    public boolean move(int newCenterX, int newCenterY, Consumer<? super T> d) {
        int y;
        int x;
        if (this.centerX == newCenterX && this.centerY == newCenterY) {
            return false;
        }
        int deltaX = newCenterX - this.centerX;
        int deltaY = newCenterY - this.centerY;
        if (Math.abs(deltaX) >= this.gridSize || Math.abs(deltaY) >= this.gridSize) {
            this.clear(d);
            this.centerX = newCenterX;
            this.centerY = newCenterY;
            return true;
        }
        this.centerX = newCenterX;
        this.centerY = newCenterY;
        for (x = 0; x < this.gridSize; ++x) {
            for (y = 0; y < this.gridSize; ++y) {
                T t;
                if (x - deltaX >= 0 && y - deltaY >= 0 && x - deltaX < this.gridSize && y - deltaY < this.gridSize || (t = this._getDirect(x, y)) == null) continue;
                d.accept(t);
            }
        }
        if (deltaX >= 0 && deltaY >= 0) {
            for (x = 0; x < this.gridSize; ++x) {
                for (y = 0; y < this.gridSize; ++y) {
                    this._setDirect(x, y, this._getDirect(x + deltaX, y + deltaY));
                }
            }
        } else if (deltaX < 0 && deltaY >= 0) {
            for (x = this.gridSize - 1; x >= 0; --x) {
                for (y = 0; y < this.gridSize; ++y) {
                    this._setDirect(x, y, this._getDirect(x + deltaX, y + deltaY));
                }
            }
        } else if (deltaX >= 0 && deltaY < 0) {
            for (x = 0; x < this.gridSize; ++x) {
                for (y = this.gridSize - 1; y >= 0; --y) {
                    this._setDirect(x, y, this._getDirect(x + deltaX, y + deltaY));
                }
            }
        } else {
            for (x = this.gridSize - 1; x >= 0; --x) {
                for (y = this.gridSize - 1; y >= 0; --y) {
                    this._setDirect(x, y, this._getDirect(x + deltaX, y + deltaY));
                }
            }
        }
        return true;
    }

    @Override
    public String toString() {
        return "MovableGridList[" + this.centerX + "," + this.centerY + "] " + this.gridSize + "*" + this.gridSize + "[" + this.size() + "]";
    }

    public String toDetailString() {
        StringBuilder str = new StringBuilder("\n");
        int i = 0;
        str.append(this);
        str.append("\n");
        for (Object t : this) {
            str.append(t != null ? t.toString() : "NULL");
            str.append(", ");
            if (++i % this.gridSize != 0) continue;
            str.append("\n");
        }
        return str.toString();
    }
}

