/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.render.objects;

import com.seibel.lod.core.api.ApiShared;
import com.seibel.lod.core.enums.config.GpuUploadMethod;
import com.seibel.lod.core.render.GLProxy;
import com.seibel.lod.core.render.objects.GLElementBuffer;
import com.seibel.lod.core.render.objects.GLEnums;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class QuadElementBuffer
extends GLElementBuffer {
    public QuadElementBuffer() {
        super(GLProxy.getInstance().bufferStorageSupported);
    }

    public int getCapacity() {
        return super.getSize() / GLEnums.getTypeSize(this.getType());
    }

    private static void buildBufferByte(int quadCount, ByteBuffer buffer) {
        for (int i = 0; i < quadCount; ++i) {
            int vIndex = i * 4;
            buffer.put((byte)vIndex);
            buffer.put((byte)(vIndex + 1));
            buffer.put((byte)(vIndex + 2));
            buffer.put((byte)(vIndex + 2));
            buffer.put((byte)(vIndex + 3));
            buffer.put((byte)vIndex);
        }
        if (buffer.hasRemaining()) {
            throw new IllegalStateException("QuadElementBuffer is not full somehow after building");
        }
        buffer.rewind();
    }

    private static void buildBufferShort(int quadCount, ByteBuffer buffer) {
        for (int i = 0; i < quadCount; ++i) {
            int vIndex = i * 4;
            buffer.putShort((short)vIndex);
            buffer.putShort((short)(vIndex + 1));
            buffer.putShort((short)(vIndex + 2));
            buffer.putShort((short)(vIndex + 2));
            buffer.putShort((short)(vIndex + 3));
            buffer.putShort((short)vIndex);
        }
        if (buffer.hasRemaining()) {
            throw new IllegalStateException("QuadElementBuffer is not full somehow after building");
        }
        buffer.rewind();
    }

    private static void buildBufferInt(int quadCount, ByteBuffer buffer) {
        for (int i = 0; i < quadCount; ++i) {
            int vIndex = i * 4;
            buffer.putInt(vIndex);
            buffer.putInt(vIndex + 1);
            buffer.putInt(vIndex + 2);
            buffer.putInt(vIndex + 2);
            buffer.putInt(vIndex + 3);
            buffer.putInt(vIndex);
        }
        if (buffer.hasRemaining()) {
            throw new IllegalStateException("QuadElementBuffer is not full somehow after building");
        }
        buffer.rewind();
    }

    private static void buildBuffer(int quadCount, ByteBuffer buffer, int type) {
        switch (type) {
            case 5121: {
                QuadElementBuffer.buildBufferByte(quadCount, buffer);
                break;
            }
            case 5123: {
                QuadElementBuffer.buildBufferShort(quadCount, buffer);
                break;
            }
            case 5125: {
                QuadElementBuffer.buildBufferInt(quadCount, buffer);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown type: " + type);
            }
        }
    }

    public void reserve(int quadCount) {
        if (quadCount < 0) {
            throw new IllegalArgumentException("quadCount must be greater than 0");
        }
        if (quadCount == 0) {
            return;
        }
        this.indicesCount = quadCount * 6;
        if (this.indicesCount >= this.getCapacity() && (double)this.indicesCount < (double)this.getCapacity() * 1.6900000000000002) {
            return;
        }
        int vertexCount = quadCount * 4;
        GLProxy gl = GLProxy.getInstance();
        this.type = vertexCount < 255 ? 5121 : (vertexCount < 65535 ? 5123 : 5125);
        ApiShared.LOGGER.info("Quad IBO Resizing from [" + this.getCapacity() + "] to [" + quadCount + "] with type: " + GLEnums.getString(this.type));
        ByteBuffer buffer = ByteBuffer.allocateDirect(this.indicesCount * GLEnums.getTypeSize(this.type)).order(ByteOrder.nativeOrder());
        QuadElementBuffer.buildBuffer(quadCount, buffer, this.type);
        if (!gl.bufferStorageSupported) {
            this.bind();
            super.uploadBuffer(buffer, GpuUploadMethod.DATA, this.indicesCount * GLEnums.getTypeSize(this.type), 35044);
        } else {
            this.bind();
            super.uploadBuffer(buffer, GpuUploadMethod.BUFFER_STORAGE, this.indicesCount * GLEnums.getTypeSize(this.type), 0);
        }
    }
}

