/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.render.objects;

import com.seibel.lod.core.enums.config.GpuUploadMethod;
import com.seibel.lod.core.render.objects.GLBuffer;
import java.nio.ByteBuffer;

public class GLVertexBuffer
extends GLBuffer {
    protected int vertexCount = 0;

    public int getVertexCount() {
        return this.vertexCount;
    }

    public void setVertexCount(int vertexCount) {
        this.vertexCount = vertexCount;
    }

    public GLVertexBuffer(boolean isBufferStorage) {
        super(isBufferStorage);
    }

    @Override
    public void destroy(boolean async) {
        super.destroy(async);
        this.vertexCount = 0;
    }

    @Override
    public int getBufferBindingTarget() {
        return 34962;
    }

    public void uploadBuffer(ByteBuffer bb, int vertCount, GpuUploadMethod uploadMethod, int maxExpensionSize) {
        if (vertCount < 0) {
            throw new IllegalArgumentException("VertCount is negative!");
        }
        if (bb.limit() - bb.position() != 0) {
            boolean useBuffStorage = uploadMethod.useBufferStorage;
            super.uploadBuffer(bb, uploadMethod, maxExpensionSize, useBuffStorage ? 0 : 35044);
        }
        this.vertexCount = vertCount;
    }

    public ByteBuffer mapBuffer(int targetSize, GpuUploadMethod uploadMethod, int maxExpensionSize) {
        return super.mapBuffer(targetSize, uploadMethod, maxExpensionSize, uploadMethod.useBufferStorage ? 2 : (uploadMethod.useEarlyMapping ? 35048 : 35044), 42);
    }
}

