/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.render.objects;

import com.seibel.lod.core.api.ApiShared;
import com.seibel.lod.core.enums.config.GpuUploadMethod;
import com.seibel.lod.core.enums.rendering.GLProxyContext;
import com.seibel.lod.core.render.GLProxy;
import com.seibel.lod.core.util.UnitBytes;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import org.lwjgl.opengl.GL32;
import org.lwjgl.opengl.GL44;

public class GLBuffer
implements AutoCloseable {
    public static final double BUFFER_EXPANSION_MULTIPLIER = 1.3;
    public static final double BUFFER_SHRINK_TRIGGER = 1.6900000000000002;
    public static AtomicInteger count = new AtomicInteger(0);
    protected int id;
    protected int size = 0;
    protected boolean bufferStorage;
    protected boolean isMapped = false;

    public final int getId() {
        return this.id;
    }

    public int getSize() {
        return this.size;
    }

    public final boolean isBufferStorage() {
        return this.bufferStorage;
    }

    public GLBuffer(boolean isBufferStorage) {
        this.create(isBufferStorage);
    }

    public int getBufferBindingTarget() {
        return 36662;
    }

    public void bind() {
        GL32.glBindBuffer((int)this.getBufferBindingTarget(), (int)this.id);
    }

    public void unbind() {
        GL32.glBindBuffer((int)this.getBufferBindingTarget(), (int)0);
    }

    protected void create(boolean asBufferStorage) {
        if (GLProxy.getInstance().getGlContext() == GLProxyContext.NONE) {
            throw new IllegalStateException("Thread [" + Thread.currentThread().getName() + "] tried to create a GLBuffer outside a OpenGL context.");
        }
        this.id = GL32.glGenBuffers();
        this.bufferStorage = asBufferStorage;
        count.getAndIncrement();
    }

    protected void destroy(boolean async) {
        if (this.id == 0) {
            throw new IllegalStateException("Buffer double close!");
        }
        if (async && GLProxy.getInstance().getGlContext() != GLProxyContext.PROXY_WORKER) {
            GLProxy.getInstance().recordOpenGlCall(() -> this.destroy(false));
        } else {
            GL32.glDeleteBuffers((int)this.id);
            this.id = 0;
            this.size = 0;
            if (count.decrementAndGet() == 0) {
                ApiShared.LOGGER.info("All GLBuffer is freed.");
            }
        }
    }

    protected void uploadBufferStorage(ByteBuffer bb, int bufferStorageHint) {
        if (!this.bufferStorage) {
            throw new IllegalStateException("Buffer is not bufferStorage but its trying to use bufferStorage upload method!");
        }
        int bbSize = bb.limit() - bb.position();
        this.destroy(false);
        this.create(true);
        this.bind();
        GL44.glBufferStorage((int)this.getBufferBindingTarget(), (ByteBuffer)bb, (int)bufferStorageHint);
        this.size = bbSize;
    }

    protected void uploadBufferData(ByteBuffer bb, int bufferDataHint) {
        if (this.bufferStorage) {
            throw new IllegalStateException("Buffer is bufferStorage but its trying to use Data upload method!");
        }
        int bbSize = bb.limit() - bb.position();
        GL32.glBufferData((int)this.getBufferBindingTarget(), (ByteBuffer)bb, (int)bufferDataHint);
        this.size = bbSize;
    }

    protected void uploadSubData(ByteBuffer bb, int maxExpansionSize, int bufferDataHint) {
        if (this.bufferStorage) {
            throw new IllegalStateException("Buffer is bufferStorage but its trying to use SubData upload method!");
        }
        int bbSize = bb.limit() - bb.position();
        if (this.size < bbSize || (double)this.size > (double)bbSize * 1.6900000000000002) {
            int newSize = (int)((double)bbSize * 1.3);
            if (newSize > maxExpansionSize) {
                newSize = maxExpansionSize;
            }
            GL32.glBufferData((int)this.getBufferBindingTarget(), (long)newSize, (int)bufferDataHint);
            this.size = newSize;
        }
        GL32.glBufferSubData((int)this.getBufferBindingTarget(), (long)0L, (ByteBuffer)bb);
    }

    public void uploadBuffer(ByteBuffer bb, GpuUploadMethod uploadMethod, int maxExpansionSize, int bufferHint) {
        if (uploadMethod.useEarlyMapping) {
            throw new IllegalArgumentException("UploadMethod signal that this should use Mapping instead of uploadBuffer!");
        }
        int bbSize = bb.limit() - bb.position();
        if (bbSize > maxExpansionSize) {
            throw new IllegalArgumentException("maxExpansionSize is " + maxExpansionSize + " but buffer size is " + bbSize + "!");
        }
        GLProxy.GL_LOGGER.debug("Uploading buffer with {}.", new UnitBytes(bbSize));
        if (bbSize == 0) {
            return;
        }
        boolean useBuffStorage = uploadMethod.useBufferStorage;
        if (useBuffStorage != this.bufferStorage) {
            this.destroy(false);
            this.create(useBuffStorage);
            this.bind();
        }
        switch (uploadMethod) {
            case AUTO: {
                throw new IllegalArgumentException("GpuUploadMethod AUTO must be resolved before call to uploadBuffer()!");
            }
            case BUFFER_STORAGE: {
                this.uploadBufferStorage(bb, bufferHint);
                break;
            }
            case DATA: {
                this.uploadBufferData(bb, bufferHint);
                break;
            }
            case SUB_DATA: {
                this.uploadSubData(bb, maxExpansionSize, bufferHint);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid GpuUploadMethod enum");
            }
        }
    }

    public ByteBuffer mapBuffer(int targetSize, GpuUploadMethod uploadMethod, int maxExpensionSize, int bufferHint, int mapFlags) {
        if (targetSize == 0) {
            throw new IllegalArgumentException("MapBuffer targetSize is 0!");
        }
        if (!uploadMethod.useEarlyMapping) {
            throw new IllegalStateException("Upload method must be one that use mappings in order to call mapBuffer!");
        }
        if (this.isMapped) {
            throw new IllegalStateException("Map Buffer called but buffer is already mapped!");
        }
        boolean useBuffStorage = uploadMethod.useBufferStorage;
        if (useBuffStorage != this.bufferStorage) {
            this.destroy(false);
            this.create(useBuffStorage);
        }
        this.bind();
        if (this.size < targetSize || (double)this.size > (double)targetSize * 1.6900000000000002) {
            int newSize = (int)((double)targetSize * 1.3);
            if (newSize > maxExpensionSize) {
                newSize = maxExpensionSize;
            }
            this.size = newSize;
            if (this.bufferStorage) {
                GL32.glDeleteBuffers((int)this.id);
                this.id = GL32.glGenBuffers();
                GL32.glBindBuffer((int)this.getBufferBindingTarget(), (int)this.id);
                GL32.glBindBuffer((int)this.getBufferBindingTarget(), (int)this.id);
                GL44.glBufferStorage((int)this.getBufferBindingTarget(), (long)newSize, (int)bufferHint);
            } else {
                GL32.glBufferData((int)34962, (long)newSize, (int)bufferHint);
            }
        }
        ByteBuffer vboBuffer = GL32.glMapBufferRange((int)34962, (long)0L, (long)targetSize, (int)mapFlags);
        this.isMapped = true;
        return vboBuffer;
    }

    public void unmapBuffer() {
        if (!this.isMapped) {
            throw new IllegalStateException("Unmap Buffer called but buffer is already not mapped!");
        }
        this.bind();
        GL32.glUnmapBuffer((int)this.getBufferBindingTarget());
        this.isMapped = false;
    }

    @Override
    public void close() {
        this.destroy(true);
    }

    public String toString() {
        return (this.bufferStorage ? "" : "Static-") + this.getClass().getSimpleName() + "[id:" + this.id + ",size:" + this.size + (this.isMapped ? ",MAPPED" : "") + "]";
    }
}

