/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.builders.lodBuilding.bufferBuilding;

import com.seibel.lod.core.builders.lodBuilding.bufferBuilding.LodQuadBuilder;
import com.seibel.lod.core.enums.rendering.DebugMode;
import com.seibel.lod.core.handlers.dependencyInjection.SingletonHandler;
import com.seibel.lod.core.objects.opengl.LodBox;
import com.seibel.lod.core.util.ColorUtil;
import com.seibel.lod.core.util.DataPointUtil;
import com.seibel.lod.core.util.LevelPosUtil;
import com.seibel.lod.core.util.LodUtil;
import com.seibel.lod.core.wrapperInterfaces.config.ILodConfigWrapperSingleton;

public class CubicLodTemplate {
    private static final ILodConfigWrapperSingleton CONFIG = SingletonHandler.get(ILodConfigWrapperSingleton.class);

    public static void addLodToBuffer(long data, long topData, long botData, long[][][] adjData, boolean[] adjFillBlack, byte detailLevel, int offsetPosX, int offsetOosZ, LodQuadBuilder quadBuilder, DebugMode debugging) {
        int color;
        short width = (short)(1 << detailLevel);
        short x = (short)LevelPosUtil.convert(detailLevel, offsetPosX, (byte)0);
        short y = DataPointUtil.getDepth(data);
        short z = (short)LevelPosUtil.convert(detailLevel, offsetOosZ, (byte)0);
        short dy = (short)(DataPointUtil.getHeight(data) - y);
        if (dy == 0) {
            return;
        }
        if (dy < 0) {
            throw new IllegalArgumentException("Negative y size for the data! Data: " + DataPointUtil.toString(data));
        }
        boolean fullBright = false;
        switch (debugging) {
            case OFF: 
            case SHOW_WIREFRAME: {
                float saturationMultiplier = (float)CONFIG.client().graphics().advancedGraphics().getSaturationMultiplier();
                float brightnessMultiplier = (float)CONFIG.client().graphics().advancedGraphics().getBrightnessMultiplier();
                if ((double)saturationMultiplier == 1.0 && (double)brightnessMultiplier == 1.0) {
                    color = DataPointUtil.getColor(data);
                    break;
                }
                float[] ahsv = ColorUtil.argbToAhsv(DataPointUtil.getColor(data));
                color = ColorUtil.ahsvToArgb(ahsv[0], ahsv[1], ahsv[2] * saturationMultiplier, ahsv[3] * brightnessMultiplier);
                break;
            }
            case SHOW_DETAIL: 
            case SHOW_DETAIL_WIREFRAME: {
                color = LodUtil.DEBUG_DETAIL_LEVEL_COLORS[detailLevel];
                fullBright = true;
                break;
            }
            case SHOW_GENMODE: 
            case SHOW_GENMODE_WIREFRAME: {
                color = LodUtil.DEBUG_DETAIL_LEVEL_COLORS[DataPointUtil.getGenerationMode(data)];
                fullBright = true;
                break;
            }
            case SHOW_OVERLAPPING_QUADS: 
            case SHOW_OVERLAPPING_QUADS_WIREFRAME: {
                color = ColorUtil.WHITE;
                fullBright = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown debug mode: " + (Object)((Object)debugging));
            }
        }
        LodBox.addBoxQuadsToBuilder(quadBuilder, width, dy, width, x, y, z, color, DataPointUtil.getLightSky(data), fullBright ? (byte)15 : (byte)DataPointUtil.getLightBlock(data), topData, botData, adjData, adjFillBlack);
    }
}

