/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.model.obj;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.github.fabricators_of_create.porting_lib.model.BakedQuadBuilder;
import io.github.fabricators_of_create.porting_lib.model.IModelBuilder;
import io.github.fabricators_of_create.porting_lib.model.IModelConfiguration;
import io.github.fabricators_of_create.porting_lib.model.IModelGeometryPart;
import io.github.fabricators_of_create.porting_lib.model.IMultipartModelGeometry;
import io.github.fabricators_of_create.porting_lib.model.IVertexConsumer;
import io.github.fabricators_of_create.porting_lib.model.ModelLoaderRegistry;
import io.github.fabricators_of_create.porting_lib.model.SimpleRenderable;
import io.github.fabricators_of_create.porting_lib.model.obj.LineReader;
import io.github.fabricators_of_create.porting_lib.model.obj.MaterialLibrary;
import io.github.fabricators_of_create.porting_lib.model.obj.OBJLoader;
import io.github.fabricators_of_create.porting_lib.util.client.UnitSprite;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import joptsimple.internal.Strings;
import net.minecraft.class_1058;
import net.minecraft.class_1088;
import net.minecraft.class_1100;
import net.minecraft.class_1160;
import net.minecraft.class_1162;
import net.minecraft.class_2350;
import net.minecraft.class_241;
import net.minecraft.class_296;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3665;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import net.minecraft.class_777;
import org.apache.commons.lang3.tuple.Pair;

public class OBJModel
implements IMultipartModelGeometry<OBJModel> {
    private static class_1162 COLOR_WHITE = new class_1162(1.0f, 1.0f, 1.0f, 1.0f);
    private static class_241[] DEFAULT_COORDS = new class_241[]{new class_241(0.0f, 0.0f), new class_241(0.0f, 1.0f), new class_241(1.0f, 1.0f), new class_241(1.0f, 0.0f)};
    private final Map<String, ModelGroup> parts = Maps.newHashMap();
    private final List<class_1160> positions = Lists.newArrayList();
    private final List<class_241> texCoords = Lists.newArrayList();
    private final List<class_1160> normals = Lists.newArrayList();
    private final List<class_1162> colors = Lists.newArrayList();
    public final boolean detectCullableFaces;
    public final boolean diffuseLighting;
    public final boolean flipV;
    public final boolean ambientToFullbright;
    public final class_2960 modelLocation;
    @Nullable
    public final String materialLibraryOverrideLocation;

    OBJModel(LineReader reader, ModelSettings settings) throws IOException {
        String[] line;
        this.modelLocation = settings.modelLocation;
        this.detectCullableFaces = settings.detectCullableFaces;
        this.diffuseLighting = settings.diffuseLighting;
        this.flipV = settings.flipV;
        this.ambientToFullbright = settings.ambientToFullbright;
        this.materialLibraryOverrideLocation = settings.materialLibraryOverrideLocation;
        String modelDomain = this.modelLocation.method_12836();
        String modelPath = this.modelLocation.method_12832();
        int lastSlash = modelPath.lastIndexOf(47);
        modelPath = lastSlash >= 0 ? modelPath.substring(0, lastSlash + 1) : "";
        MaterialLibrary mtllib = MaterialLibrary.EMPTY;
        MaterialLibrary.Material currentMat = null;
        String currentSmoothingGroup = null;
        ModelObject currentGroup = null;
        ModelObject currentObject = null;
        ModelMesh currentMesh = null;
        boolean objAboveGroup = false;
        if (this.materialLibraryOverrideLocation != null) {
            String lib = this.materialLibraryOverrideLocation;
            mtllib = lib.contains(":") ? OBJLoader.INSTANCE.loadMaterialLibrary(new class_2960(lib)) : OBJLoader.INSTANCE.loadMaterialLibrary(new class_2960(modelDomain, modelPath + lib));
        }
        while ((line = reader.readAndSplitLine(true)) != null) {
            switch (line[0]) {
                case "mtllib": {
                    if (this.materialLibraryOverrideLocation != null) break;
                    String lib = line[1];
                    if (lib.contains(":")) {
                        mtllib = OBJLoader.INSTANCE.loadMaterialLibrary(new class_2960(lib));
                        break;
                    }
                    mtllib = OBJLoader.INSTANCE.loadMaterialLibrary(new class_2960(modelDomain, modelPath + lib));
                    break;
                }
                case "usemtl": {
                    String mat = Strings.join((String[])Arrays.copyOfRange(line, 1, line.length), (String)" ");
                    MaterialLibrary.Material newMat = mtllib.getMaterial(mat);
                    if (Objects.equals(newMat, currentMat)) break;
                    currentMat = newMat;
                    if (currentMesh != null && currentMesh.mat == null && currentMesh.faces.size() == 0) {
                        currentMesh.mat = currentMat;
                        break;
                    }
                    currentMesh = null;
                    break;
                }
                case "v": {
                    this.positions.add(OBJModel.parseVector4To3(line));
                    break;
                }
                case "vt": {
                    this.texCoords.add(OBJModel.parseVector2(line));
                    break;
                }
                case "vn": {
                    this.normals.add(OBJModel.parseVector3(line));
                    break;
                }
                case "vc": {
                    this.colors.add(OBJModel.parseVector4(line));
                    break;
                }
                case "f": {
                    if (currentMesh == null) {
                        currentMesh = new ModelMesh(currentMat, currentSmoothingGroup);
                        if (currentObject != null) {
                            currentObject.meshes.add(currentMesh);
                        } else {
                            if (currentGroup == null) {
                                currentGroup = new ModelGroup("");
                                this.parts.put("", (ModelGroup)currentGroup);
                            }
                            ((ModelGroup)currentGroup).meshes.add(currentMesh);
                        }
                    }
                    int[][] vertices = new int[line.length - 1][];
                    for (int i = 0; i < vertices.length; ++i) {
                        String vertexData = line[i + 1];
                        String[] vertexParts = vertexData.split("/");
                        int[] vertex = Arrays.stream(vertexParts).mapToInt(num -> Strings.isNullOrEmpty((String)num) ? 0 : Integer.parseInt(num)).toArray();
                        vertex[0] = vertex[0] < 0 ? this.positions.size() + vertex[0] : vertex[0] - 1;
                        if (vertex.length > 1) {
                            vertex[1] = vertex[1] < 0 ? this.texCoords.size() + vertex[1] : vertex[1] - 1;
                            if (vertex.length > 2) {
                                vertex[2] = vertex[2] < 0 ? this.normals.size() + vertex[2] : vertex[2] - 1;
                                if (vertex.length > 3) {
                                    vertex[3] = vertex[3] < 0 ? this.colors.size() + vertex[3] : vertex[3] - 1;
                                }
                            }
                        }
                        vertices[i] = vertex;
                    }
                    currentMesh.faces.add(vertices);
                    break;
                }
                case "s": {
                    String smoothingGroup;
                    String string = smoothingGroup = "off".equals(line[1]) ? null : line[1];
                    if (Objects.equals(currentSmoothingGroup, smoothingGroup)) break;
                    currentSmoothingGroup = smoothingGroup;
                    if (currentMesh != null && currentMesh.smoothingGroup == null && currentMesh.faces.size() == 0) {
                        currentMesh.smoothingGroup = currentSmoothingGroup;
                        break;
                    }
                    currentMesh = null;
                    break;
                }
                case "g": {
                    String name = line[1];
                    if (objAboveGroup) {
                        currentObject = new ModelObject(currentGroup.name() + "/" + name);
                        ((ModelGroup)currentGroup).parts.put(name, currentObject);
                    } else {
                        currentGroup = new ModelGroup(name);
                        this.parts.put(name, (ModelGroup)currentGroup);
                        currentObject = null;
                    }
                    currentMesh = null;
                    break;
                }
                case "o": {
                    String name = line[1];
                    if (objAboveGroup || currentGroup == null) {
                        objAboveGroup = true;
                        currentGroup = new ModelGroup(name);
                        this.parts.put(name, (ModelGroup)currentGroup);
                        currentObject = null;
                    } else {
                        currentObject = new ModelObject(currentGroup.name() + "/" + name);
                        ((ModelGroup)currentGroup).parts.put(name, currentObject);
                    }
                    currentMesh = null;
                    break;
                }
            }
        }
    }

    public static class_1160 parseVector4To3(String[] line) {
        switch (line.length) {
            case 1: {
                return new class_1160(0.0f, 0.0f, 0.0f);
            }
            case 2: {
                return new class_1160(Float.parseFloat(line[1]), 0.0f, 0.0f);
            }
            case 3: {
                return new class_1160(Float.parseFloat(line[1]), Float.parseFloat(line[2]), 0.0f);
            }
            case 4: {
                return new class_1160(Float.parseFloat(line[1]), Float.parseFloat(line[2]), Float.parseFloat(line[3]));
            }
        }
        class_1162 vec4 = OBJModel.parseVector4(line);
        return new class_1160(vec4.method_4953() / vec4.method_23853(), vec4.method_4956() / vec4.method_23853(), vec4.method_4957() / vec4.method_23853());
    }

    public static class_241 parseVector2(String[] line) {
        switch (line.length) {
            case 1: {
                return new class_241(0.0f, 0.0f);
            }
            case 2: {
                return new class_241(Float.parseFloat(line[1]), 0.0f);
            }
        }
        return new class_241(Float.parseFloat(line[1]), Float.parseFloat(line[2]));
    }

    public static class_1160 parseVector3(String[] line) {
        switch (line.length) {
            case 1: {
                return new class_1160(0.0f, 0.0f, 0.0f);
            }
            case 2: {
                return new class_1160(Float.parseFloat(line[1]), 0.0f, 0.0f);
            }
            case 3: {
                return new class_1160(Float.parseFloat(line[1]), Float.parseFloat(line[2]), 0.0f);
            }
        }
        return new class_1160(Float.parseFloat(line[1]), Float.parseFloat(line[2]), Float.parseFloat(line[3]));
    }

    public static class_1162 parseVector4(String[] line) {
        switch (line.length) {
            case 1: {
                return new class_1162(0.0f, 0.0f, 0.0f, 1.0f);
            }
            case 2: {
                return new class_1162(Float.parseFloat(line[1]), 0.0f, 0.0f, 1.0f);
            }
            case 3: {
                return new class_1162(Float.parseFloat(line[1]), Float.parseFloat(line[2]), 0.0f, 1.0f);
            }
            case 4: {
                return new class_1162(Float.parseFloat(line[1]), Float.parseFloat(line[2]), Float.parseFloat(line[3]), 1.0f);
            }
        }
        return new class_1162(Float.parseFloat(line[1]), Float.parseFloat(line[2]), Float.parseFloat(line[3]), Float.parseFloat(line[4]));
    }

    @Override
    public Collection<? extends IModelGeometryPart> getParts() {
        return this.parts.values();
    }

    @Override
    public Optional<? extends IModelGeometryPart> getPart(String name) {
        return Optional.ofNullable(this.parts.get(name));
    }

    private Pair<class_777, class_2350> makeQuad(int[][] indices, int tintIndex, class_1162 colorTint, class_1162 ambientColor, class_1058 texture, class_4590 transform) {
        boolean needsNormalRecalculation = false;
        for (int[] ints : indices) {
            needsNormalRecalculation |= ints.length < 3;
        }
        class_1160 faceNormal = new class_1160(0.0f, 0.0f, 0.0f);
        if (needsNormalRecalculation) {
            class_1160 a = this.positions.get(indices[0][0]);
            class_1160 ab = this.positions.get(indices[1][0]);
            class_1160 ac = this.positions.get(indices[2][0]);
            class_1160 abs = ab.method_23850();
            abs.method_4944(a);
            class_1160 acs = ac.method_23850();
            acs.method_4944(a);
            abs.method_4951(acs);
            abs.method_4952();
            faceNormal = abs;
        }
        class_1162[] pos = new class_1162[4];
        class_1160[] norm = new class_1160[4];
        BakedQuadBuilder builder = new BakedQuadBuilder(texture);
        builder.setQuadTint(tintIndex);
        class_241 uv2 = new class_241(0.0f, 0.0f);
        if (this.ambientToFullbright) {
            int fakeLight = (int)((ambientColor.method_4953() + ambientColor.method_4956() + ambientColor.method_4957()) * 15.0f / 3.0f);
            uv2 = new class_241((float)(fakeLight << 4) / 32767.0f, (float)(fakeLight << 4) / 32767.0f);
            builder.setApplyDiffuseLighting(fakeLight == 0);
        } else {
            builder.setApplyDiffuseLighting(this.diffuseLighting);
        }
        boolean hasTransform = !transform.isIdentity();
        class_4590 transformation = hasTransform ? transform.blockCenterToCorner() : transform;
        for (int i = 0; i < 4; ++i) {
            class_1162 color;
            class_1160 norm0;
            int[] index = indices[Math.min(i, indices.length - 1)];
            class_1160 pos0 = this.positions.get(index[0]);
            class_1162 position = new class_1162(pos0);
            class_241 texCoord = index.length >= 2 && this.texCoords.size() > 0 ? this.texCoords.get(index[1]) : DEFAULT_COORDS[i];
            class_1160 normal = norm0 = !needsNormalRecalculation && index.length >= 3 && this.normals.size() > 0 ? this.normals.get(index[2]) : faceNormal;
            class_1162 class_11622 = color = index.length >= 4 && this.colors.size() > 0 ? this.colors.get(index[3]) : COLOR_WHITE;
            if (hasTransform) {
                normal = norm0.method_23850();
                transformation.transformPosition(position);
                transformation.transformNormal(normal);
            }
            class_1162 tintedColor = new class_1162(color.method_4953() * colorTint.method_4953(), color.method_4956() * colorTint.method_4956(), color.method_4957() * colorTint.method_4957(), color.method_23853() * colorTint.method_23853());
            this.putVertexData(builder, position, texCoord, normal, tintedColor, uv2, texture);
            pos[i] = position;
            norm[i] = normal;
        }
        builder.setQuadOrientation(class_2350.method_10147((float)norm[0].method_4943(), (float)norm[0].method_4945(), (float)norm[0].method_4947()));
        class_2350 cull = null;
        if (this.detectCullableFaces) {
            if (class_3532.method_15347((float)pos[0].method_4953(), (float)0.0f) && class_3532.method_15347((float)pos[1].method_4953(), (float)0.0f) && class_3532.method_15347((float)pos[2].method_4953(), (float)0.0f) && class_3532.method_15347((float)pos[3].method_4953(), (float)0.0f) && norm[0].method_4943() < 0.0f) {
                cull = class_2350.field_11039;
            } else if (class_3532.method_15347((float)pos[0].method_4953(), (float)1.0f) && class_3532.method_15347((float)pos[1].method_4953(), (float)1.0f) && class_3532.method_15347((float)pos[2].method_4953(), (float)1.0f) && class_3532.method_15347((float)pos[3].method_4953(), (float)1.0f) && norm[0].method_4943() > 0.0f) {
                cull = class_2350.field_11034;
            } else if (class_3532.method_15347((float)pos[0].method_4957(), (float)0.0f) && class_3532.method_15347((float)pos[1].method_4957(), (float)0.0f) && class_3532.method_15347((float)pos[2].method_4957(), (float)0.0f) && class_3532.method_15347((float)pos[3].method_4957(), (float)0.0f) && norm[0].method_4947() < 0.0f) {
                cull = class_2350.field_11043;
            } else if (class_3532.method_15347((float)pos[0].method_4957(), (float)1.0f) && class_3532.method_15347((float)pos[1].method_4957(), (float)1.0f) && class_3532.method_15347((float)pos[2].method_4957(), (float)1.0f) && class_3532.method_15347((float)pos[3].method_4957(), (float)1.0f) && norm[0].method_4947() > 0.0f) {
                cull = class_2350.field_11035;
            } else if (class_3532.method_15347((float)pos[0].method_4956(), (float)0.0f) && class_3532.method_15347((float)pos[1].method_4956(), (float)0.0f) && class_3532.method_15347((float)pos[2].method_4956(), (float)0.0f) && class_3532.method_15347((float)pos[3].method_4956(), (float)0.0f) && norm[0].method_4945() < 0.0f) {
                cull = class_2350.field_11033;
            } else if (class_3532.method_15347((float)pos[0].method_4956(), (float)1.0f) && class_3532.method_15347((float)pos[1].method_4956(), (float)1.0f) && class_3532.method_15347((float)pos[2].method_4956(), (float)1.0f) && class_3532.method_15347((float)pos[3].method_4956(), (float)1.0f) && norm[0].method_4945() > 0.0f) {
                cull = class_2350.field_11036;
            }
        }
        return Pair.of((Object)builder.build(), cull);
    }

    private void putVertexData(IVertexConsumer consumer, class_1162 position0, class_241 texCoord0, class_1160 normal0, class_1162 color0, class_241 uv2, class_1058 texture) {
        ImmutableList elements = consumer.getVertexFormat().method_1357();
        block10: for (int j = 0; j < elements.size(); ++j) {
            class_296 e = (class_296)elements.get(j);
            switch (e.method_1382()) {
                case field_1633: {
                    consumer.put(j, position0.method_4953(), position0.method_4956(), position0.method_4957(), position0.method_23853());
                    continue block10;
                }
                case field_1632: {
                    consumer.put(j, color0.method_4953(), color0.method_4956(), color0.method_4957(), color0.method_23853());
                    continue block10;
                }
                case field_1636: {
                    switch (e.method_1385()) {
                        case 0: {
                            consumer.put(j, texture.method_4580((double)(texCoord0.field_1343 * 16.0f)), texture.method_4570((double)((this.flipV ? 1.0f - texCoord0.field_1342 : texCoord0.field_1342) * 16.0f)));
                            continue block10;
                        }
                        case 2: {
                            consumer.put(j, uv2.field_1343, uv2.field_1342);
                            continue block10;
                        }
                    }
                    consumer.put(j, new float[0]);
                    continue block10;
                }
                case field_1635: {
                    consumer.put(j, normal0.method_4943(), normal0.method_4945(), normal0.method_4947());
                    continue block10;
                }
                default: {
                    consumer.put(j, new float[0]);
                }
            }
        }
    }

    public SimpleRenderable bakeRenderable(IModelConfiguration configuration) {
        SimpleRenderable.Builder builder = SimpleRenderable.builder();
        for (Map.Entry<String, ModelGroup> entry : this.parts.entrySet()) {
            String name = entry.getKey();
            ModelGroup part = entry.getValue();
            part.bake(builder.child(name), configuration);
        }
        return builder.get();
    }

    public record ModelSettings(@Nonnull class_2960 modelLocation, boolean detectCullableFaces, boolean diffuseLighting, boolean flipV, boolean ambientToFullbright, @Nullable String materialLibraryOverrideLocation) {
    }

    private class ModelMesh {
        @Nullable
        public MaterialLibrary.Material mat;
        @Nullable
        public String smoothingGroup;
        public final List<int[][]> faces = Lists.newArrayList();

        public ModelMesh(@Nullable MaterialLibrary.Material currentMat, String currentSmoothingGroup) {
            this.mat = currentMat;
            this.smoothingGroup = currentSmoothingGroup;
        }

        public void addQuads(IModelConfiguration owner, IModelBuilder<?> modelBuilder, Function<class_4730, class_1058> spriteGetter, class_3665 modelTransform) {
            if (this.mat == null) {
                return;
            }
            class_1058 texture = spriteGetter.apply(ModelLoaderRegistry.resolveTexture(this.mat.diffuseColorMap, owner));
            int tintIndex = this.mat.diffuseTintIndex;
            class_1162 colorTint = this.mat.diffuseColor;
            for (int[][] face : this.faces) {
                Pair<class_777, class_2350> quad = OBJModel.this.makeQuad(face, tintIndex, colorTint, this.mat.ambientColor, texture, modelTransform.method_3509());
                if (quad.getRight() == null) {
                    modelBuilder.addGeneralQuad((class_777)quad.getLeft());
                    continue;
                }
                modelBuilder.addFaceQuad((class_2350)quad.getRight(), (class_777)quad.getLeft());
            }
        }

        public void bake(SimpleRenderable.PartBuilder<?> builder, IModelConfiguration configuration) {
            MaterialLibrary.Material mat = this.mat;
            if (mat == null) {
                return;
            }
            int tintIndex = mat.diffuseTintIndex;
            class_1162 colorTint = mat.diffuseColor;
            ArrayList<class_777> quads = new ArrayList<class_777>();
            for (int[][] face : this.faces) {
                Pair<class_777, class_2350> pair = OBJModel.this.makeQuad(face, tintIndex, colorTint, mat.ambientColor, UnitSprite.INSTANCE, class_4590.method_22931());
                quads.add((class_777)pair.getLeft());
            }
            class_2960 textureLocation = ModelLoaderRegistry.resolveTexture(mat.diffuseColorMap, configuration).method_24147();
            class_2960 texturePath = new class_2960(textureLocation.method_12836(), "textures/" + textureLocation.method_12832() + ".png");
            builder.addMesh(texturePath, quads);
        }
    }

    public class ModelObject
    implements IModelGeometryPart {
        public final String name;
        List<ModelMesh> meshes = Lists.newArrayList();

        ModelObject(String name) {
            this.name = name;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public void addQuads(IModelConfiguration owner, IModelBuilder<?> modelBuilder, class_1088 bakery, Function<class_4730, class_1058> spriteGetter, class_3665 modelTransform, class_2960 modelLocation) {
            for (ModelMesh mesh : this.meshes) {
                mesh.addQuads(owner, modelBuilder, spriteGetter, modelTransform);
            }
        }

        public void bake(SimpleRenderable.PartBuilder<?> builder, IModelConfiguration configuration) {
            for (ModelMesh mesh : this.meshes) {
                mesh.bake(builder, configuration);
            }
        }

        @Override
        public Collection<class_4730> getTextures(IModelConfiguration owner, Function<class_2960, class_1100> modelGetter, Set<com.mojang.datafixers.util.Pair<String, String>> missingTextureErrors) {
            return this.meshes.stream().flatMap(mesh -> mesh.mat != null ? Stream.of(ModelLoaderRegistry.resolveTexture(mesh.mat.diffuseColorMap, owner)) : Stream.of(new class_4730[0])).collect(Collectors.toSet());
        }
    }

    public class ModelGroup
    extends ModelObject {
        final Map<String, ModelObject> parts;

        ModelGroup(String name) {
            super(name);
            this.parts = Maps.newHashMap();
        }

        public Collection<? extends IModelGeometryPart> getParts() {
            return this.parts.values();
        }

        @Override
        public void addQuads(IModelConfiguration owner, IModelBuilder<?> modelBuilder, class_1088 bakery, Function<class_4730, class_1058> spriteGetter, class_3665 modelTransform, class_2960 modelLocation) {
            super.addQuads(owner, modelBuilder, bakery, spriteGetter, modelTransform, modelLocation);
            this.getParts().stream().filter(owner::getPartVisibility).forEach(part -> part.addQuads(owner, modelBuilder, bakery, spriteGetter, modelTransform, modelLocation));
        }

        @Override
        public void bake(SimpleRenderable.PartBuilder<?> builder, IModelConfiguration configuration) {
            super.bake(builder, configuration);
            for (Map.Entry<String, ModelObject> entry : this.parts.entrySet()) {
                String name = entry.getKey();
                ModelObject part = entry.getValue();
                part.bake(builder.child(name), configuration);
            }
        }

        @Override
        public Collection<class_4730> getTextures(IModelConfiguration owner, Function<class_2960, class_1100> modelGetter, Set<com.mojang.datafixers.util.Pair<String, String>> missingTextureErrors) {
            HashSet combined = Sets.newHashSet();
            combined.addAll(super.getTextures(owner, modelGetter, missingTextureErrors));
            for (IModelGeometryPart iModelGeometryPart : this.getParts()) {
                combined.addAll(iModelGeometryPart.getTextures(owner, modelGetter, missingTextureErrors));
            }
            return combined;
        }
    }
}

