/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.model;

import io.github.fabricators_of_create.porting_lib.model.IRenderable;
import io.github.fabricators_of_create.porting_lib.model.MultipartTransforms;
import io.github.fabricators_of_create.porting_lib.util.client.VertexUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1159;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_777;

public class SimpleRenderable
implements IRenderable<MultipartTransforms> {
    private final List<Part> parts = new ArrayList<Part>();

    private SimpleRenderable() {
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void render(class_4587 poseStack, class_4597 bufferSource, Function<class_2960, class_1921> renderTypeFunction, int lightmapCoord, int overlayCoord, float partialTicks, MultipartTransforms renderValues) {
        for (Part part : this.parts) {
            part.render(poseStack, bufferSource, renderTypeFunction, lightmapCoord, overlayCoord, renderValues);
        }
    }

    public static class Builder {
        private final SimpleRenderable renderable = new SimpleRenderable();

        private Builder() {
        }

        public PartBuilder<Builder> child(String name) {
            Part child = new Part(name);
            this.renderable.parts.add(child);
            return new PartBuilder<Builder>(this, child);
        }

        public SimpleRenderable get() {
            return this.renderable;
        }
    }

    private static class Part {
        private final String name;
        private final List<Part> parts = new ArrayList<Part>();
        private final List<Mesh> meshes = new ArrayList<Mesh>();

        public Part(String name) {
            this.name = name;
        }

        public void render(class_4587 poseStack, class_4597 bufferSource, Function<class_2960, class_1921> renderTypeFunction, int lightmapCoord, int overlayCoord, MultipartTransforms renderValues) {
            class_1159 matrix = renderValues.getPartValues(this.name);
            if (matrix != null) {
                poseStack.method_22903();
                poseStack.method_34425(matrix);
            }
            for (Part part : this.parts) {
                part.render(poseStack, bufferSource, renderTypeFunction, lightmapCoord, overlayCoord, renderValues);
            }
            for (Mesh mesh : this.meshes) {
                mesh.render(poseStack, bufferSource, renderTypeFunction, lightmapCoord, overlayCoord, renderValues);
            }
            if (matrix != null) {
                poseStack.method_22909();
            }
        }
    }

    public static class PartBuilder<T> {
        private final T parent;
        private final Part part;

        private PartBuilder(T parent, Part part) {
            this.parent = parent;
            this.part = part;
        }

        public PartBuilder<PartBuilder<T>> child(String name) {
            Part child = new Part(this.part.name + "/" + name);
            this.part.parts.add(child);
            return new PartBuilder<PartBuilder<T>>(this, child);
        }

        public PartBuilder<T> addMesh(class_2960 texture, List<class_777> quads) {
            Mesh mesh = new Mesh(texture);
            mesh.quads.addAll(quads);
            this.part.meshes.add(mesh);
            return this;
        }

        public T end() {
            return this.parent;
        }
    }

    private static class Mesh {
        private final class_2960 texture;
        private final List<class_777> quads = new ArrayList<class_777>();

        public Mesh(class_2960 texture) {
            this.texture = texture;
        }

        public void render(class_4587 poseStack, class_4597 bufferSource, Function<class_2960, class_1921> renderTypeFunction, int lightmapCoord, int overlayCoord, MultipartTransforms renderValues) {
            class_4588 consumer = bufferSource.getBuffer(renderTypeFunction.apply(this.texture));
            for (class_777 quad : this.quads) {
                VertexUtils.putBulkData(consumer, poseStack.method_23760(), quad, 1.0f, 1.0f, 1.0f, 1.0f, lightmapCoord, overlayCoord, true);
            }
        }
    }
}

