/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import io.github.fabricators_of_create.porting_lib.mixin.client.accessor.BlockModelAccessor;
import io.github.fabricators_of_create.porting_lib.model.CompositeModel;
import io.github.fabricators_of_create.porting_lib.model.DynamicBucketModel;
import io.github.fabricators_of_create.porting_lib.model.IModelBuilder;
import io.github.fabricators_of_create.porting_lib.model.IModelConfiguration;
import io.github.fabricators_of_create.porting_lib.model.IModelGeometry;
import io.github.fabricators_of_create.porting_lib.model.IModelLoader;
import io.github.fabricators_of_create.porting_lib.model.ISimpleModelGeometry;
import io.github.fabricators_of_create.porting_lib.model.ItemLayerModel;
import io.github.fabricators_of_create.porting_lib.model.SimpleModelState;
import io.github.fabricators_of_create.porting_lib.model.obj.OBJLoader;
import io.github.fabricators_of_create.porting_lib.util.TransformationHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1088;
import net.minecraft.class_1100;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3304;
import net.minecraft.class_3518;
import net.minecraft.class_3665;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import net.minecraft.class_783;
import net.minecraft.class_785;
import net.minecraft.class_787;
import net.minecraft.class_793;
import net.minecraft.class_799;
import net.minecraft.class_804;
import net.minecraft.class_809;

public class ModelLoaderRegistry {
    private static final Map<class_2960, IModelLoader<?>> loaders = Maps.newHashMap();
    private static final Pattern FILESYSTEM_PATH_TO_RESLOC = Pattern.compile("(?:.*[\\\\/]assets[\\\\/](?<namespace>[a-z_-]+)[\\\\/]textures[\\\\/])?(?<path>[a-z_\\\\/-]+)\\.png");
    public static final String WHITE_TEXTURE = "porting_lib:white";

    public static void init() {
        BlockModelAccessor.setGSON(new GsonBuilder().registerTypeAdapter(class_793.class, (Object)new class_793.class_795()).registerTypeAdapter(class_785.class, (Object)new class_785.class_786()).registerTypeAdapter(class_783.class, (Object)new class_783.class_784()).registerTypeAdapter(class_787.class, (Object)new class_787.class_788()).registerTypeAdapter(class_804.class, (Object)new class_804.class_805()).registerTypeAdapter(class_809.class, (Object)new class_809.class_810()).registerTypeAdapter(class_799.class, (Object)new class_799.class_800()).registerTypeAdapter(class_4590.class, (Object)new TransformationHelper.Deserializer()).create());
        ModelLoaderRegistry.registerLoader(new class_2960("minecraft", "elements"), VanillaProxy.Loader.INSTANCE);
        ModelLoaderRegistry.registerLoader(new class_2960("forge", "obj"), OBJLoader.INSTANCE);
        ModelLoaderRegistry.registerLoader(new class_2960("forge", "bucket"), DynamicBucketModel.Loader.INSTANCE);
        ModelLoaderRegistry.registerLoader(new class_2960("forge", "composite"), CompositeModel.Loader.INSTANCE);
        ModelLoaderRegistry.registerLoader(new class_2960("forge", "item-layers"), ItemLayerModel.Loader.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerLoader(class_2960 id, IModelLoader<?> loader) {
        Map<class_2960, IModelLoader<?>> map = loaders;
        synchronized (map) {
            loaders.put(id, loader);
            ((class_3304)class_310.method_1551().method_1478()).method_14477(loader);
        }
    }

    public static IModelGeometry<?> getModel(class_2960 loaderId, JsonDeserializationContext deserializationContext, JsonObject data) {
        if (!loaders.containsKey(loaderId)) {
            throw new IllegalStateException(String.format("Model loader '%s' not found. Registered loaders: %s", loaderId, loaders.keySet().stream().map(class_2960::toString).collect(Collectors.joining(", "))));
        }
        IModelLoader<?> loader = loaders.get(loaderId);
        return loader.read(deserializationContext, data);
    }

    @Nullable
    public static class_3665 deserializeModelTransforms(JsonDeserializationContext deserializationContext, JsonObject modelData) {
        if (!modelData.has("transform")) {
            return null;
        }
        return ModelLoaderRegistry.deserializeTransform(deserializationContext, modelData.get("transform")).orElse(null);
    }

    public static Optional<class_3665> deserializeTransform(JsonDeserializationContext context, JsonElement transformData) {
        if (!transformData.isJsonObject()) {
            try {
                class_4590 base = (class_4590)context.deserialize(transformData, class_4590.class);
                return Optional.of(new SimpleModelState(ImmutableMap.of(), base.blockCenterToCorner()));
            }
            catch (JsonParseException e) {
                throw new JsonParseException("transform: expected a string, object or valid base transformation, got: " + transformData);
            }
        }
        JsonObject transform = transformData.getAsJsonObject();
        EnumMap transforms = Maps.newEnumMap(class_809.class_811.class);
        ModelLoaderRegistry.deserializeTRSR(context, transforms, transform, "thirdperson", class_809.class_811.field_4320);
        ModelLoaderRegistry.deserializeTRSR(context, transforms, transform, "thirdperson_righthand", class_809.class_811.field_4320);
        ModelLoaderRegistry.deserializeTRSR(context, transforms, transform, "thirdperson_lefthand", class_809.class_811.field_4323);
        ModelLoaderRegistry.deserializeTRSR(context, transforms, transform, "firstperson", class_809.class_811.field_4322);
        ModelLoaderRegistry.deserializeTRSR(context, transforms, transform, "firstperson_righthand", class_809.class_811.field_4322);
        ModelLoaderRegistry.deserializeTRSR(context, transforms, transform, "firstperson_lefthand", class_809.class_811.field_4321);
        ModelLoaderRegistry.deserializeTRSR(context, transforms, transform, "head", class_809.class_811.field_4316);
        ModelLoaderRegistry.deserializeTRSR(context, transforms, transform, "gui", class_809.class_811.field_4317);
        ModelLoaderRegistry.deserializeTRSR(context, transforms, transform, "ground", class_809.class_811.field_4318);
        ModelLoaderRegistry.deserializeTRSR(context, transforms, transform, "fixed", class_809.class_811.field_4319);
        int k = transform.entrySet().size();
        if (transform.has("matrix")) {
            --k;
        }
        if (transform.has("translation")) {
            --k;
        }
        if (transform.has("rotation")) {
            --k;
        }
        if (transform.has("scale")) {
            --k;
        }
        if (transform.has("post-rotation")) {
            --k;
        }
        if (transform.has("origin")) {
            --k;
        }
        if (k > 0) {
            throw new JsonParseException("transform: allowed keys: 'thirdperson', 'firstperson', 'gui', 'head', 'matrix', 'translation', 'rotation', 'scale', 'post-rotation', 'origin'");
        }
        class_4590 base = class_4590.method_22931();
        if (!transform.entrySet().isEmpty()) {
            base = (class_4590)context.deserialize((JsonElement)transform, class_4590.class);
        }
        SimpleModelState state = new SimpleModelState(Maps.immutableEnumMap((Map)transforms), base);
        return Optional.of(state);
    }

    private static void deserializeTRSR(JsonDeserializationContext context, EnumMap<class_809.class_811, class_4590> transforms, JsonObject transform, String name, class_809.class_811 itemCameraTransform) {
        if (transform.has(name)) {
            class_4590 t = (class_4590)context.deserialize(transform.remove(name), class_4590.class);
            transforms.put(itemCameraTransform, t.blockCenterToCorner());
        }
    }

    @Nullable
    public static IModelGeometry<?> deserializeGeometry(JsonDeserializationContext deserializationContext, JsonObject object) {
        if (!object.has("loader")) {
            return null;
        }
        class_2960 loader = new class_2960(class_3518.method_15265((JsonObject)object, (String)"loader"));
        return ModelLoaderRegistry.getModel(loader, deserializationContext, object);
    }

    public static class_4730 resolveTexture(@Nullable String tex, IModelConfiguration owner) {
        if (tex == null) {
            return ModelLoaderRegistry.blockMaterial(WHITE_TEXTURE);
        }
        if (tex.startsWith("#")) {
            return owner.resolveTexture(tex);
        }
        Matcher match = FILESYSTEM_PATH_TO_RESLOC.matcher(tex);
        if (match.matches()) {
            String namespace = match.group("namespace");
            String path = match.group("path").replace("\\", "/");
            if (namespace != null) {
                return ModelLoaderRegistry.blockMaterial(new class_2960(namespace, path));
            }
            return ModelLoaderRegistry.blockMaterial(path);
        }
        return ModelLoaderRegistry.blockMaterial(tex);
    }

    public static class_4730 blockMaterial(String location) {
        return new class_4730(class_1059.field_5275, new class_2960(location));
    }

    public static class_4730 blockMaterial(class_2960 location) {
        return new class_4730(class_1059.field_5275, location);
    }

    public static class VanillaProxy
    implements ISimpleModelGeometry<VanillaProxy> {
        private final List<class_785> elements;

        public VanillaProxy(List<class_785> list) {
            this.elements = list;
        }

        @Override
        public void addQuads(IModelConfiguration owner, IModelBuilder<?> modelBuilder, class_1088 bakery, Function<class_4730, class_1058> spriteGetter, class_3665 modelTransform, class_2960 modelLocation) {
            for (class_785 blockpart : this.elements) {
                for (class_2350 direction : blockpart.field_4230.keySet()) {
                    class_783 blockpartface = (class_783)blockpart.field_4230.get(direction);
                    class_1058 textureatlassprite1 = spriteGetter.apply(owner.resolveTexture(blockpartface.field_4224));
                    if (blockpartface.field_4225 == null) {
                        modelBuilder.addGeneralQuad(BlockModelAccessor.port_lib$bakeFace(blockpart, blockpartface, textureatlassprite1, direction, modelTransform, modelLocation));
                        continue;
                    }
                    modelBuilder.addFaceQuad(modelTransform.method_3509().rotateTransform(blockpartface.field_4225), BlockModelAccessor.port_lib$bakeFace(blockpart, blockpartface, textureatlassprite1, direction, modelTransform, modelLocation));
                }
            }
        }

        @Override
        public Collection<class_4730> getTextures(IModelConfiguration owner, Function<class_2960, class_1100> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            HashSet textures = Sets.newHashSet();
            for (class_785 part : this.elements) {
                for (class_783 face : part.field_4230.values()) {
                    class_4730 texture = owner.resolveTexture(face.field_4224);
                    if (Objects.equals(texture, class_1047.method_4539().toString())) {
                        missingTextureErrors.add((Pair<String, String>)Pair.of((Object)face.field_4224, (Object)owner.getModelName()));
                    }
                    textures.add(texture);
                }
            }
            return textures;
        }

        public static class Loader
        implements IModelLoader<VanillaProxy> {
            public static final Loader INSTANCE = new Loader();

            private Loader() {
            }

            public void method_14491(class_3300 resourceManager) {
            }

            @Override
            public VanillaProxy read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
                List<class_785> list = this.getModelElements(deserializationContext, modelContents);
                return new VanillaProxy(list);
            }

            private List<class_785> getModelElements(JsonDeserializationContext deserializationContext, JsonObject object) {
                ArrayList list = Lists.newArrayList();
                if (object.has("elements")) {
                    for (JsonElement jsonelement : class_3518.method_15261((JsonObject)object, (String)"elements")) {
                        list.add((class_785)deserializationContext.deserialize(jsonelement, class_785.class));
                    }
                }
                return list;
            }
        }
    }
}

