/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.model;

import com.google.common.collect.Lists;
import io.github.fabricators_of_create.porting_lib.model.BakedQuadBuilder;
import io.github.fabricators_of_create.porting_lib.model.IVertexConsumer;
import io.github.fabricators_of_create.porting_lib.model.TRSRTransformer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1058;
import net.minecraft.class_2350;
import net.minecraft.class_293;
import net.minecraft.class_296;
import net.minecraft.class_4590;
import net.minecraft.class_777;

public final class ItemTextureQuadConverter {
    private ItemTextureQuadConverter() {
    }

    public static List<class_777> convertTexture(class_4590 transform, class_1058 template, class_1058 sprite, float z, class_2350 facing, int color, int tint) {
        return ItemTextureQuadConverter.convertTexture(transform, template, sprite, z, facing, color, tint, 0);
    }

    public static List<class_777> convertTexture(class_4590 transform, class_1058 template, class_1058 sprite, float z, class_2350 facing, int color, int tint, int luminosity) {
        List<class_777> horizontal = ItemTextureQuadConverter.convertTextureHorizontal(transform, template, sprite, z, facing, color, tint, luminosity);
        List<class_777> vertical = ItemTextureQuadConverter.convertTextureVertical(transform, template, sprite, z, facing, color, tint, luminosity);
        return horizontal.size() <= vertical.size() ? horizontal : vertical;
    }

    public static List<class_777> convertTextureHorizontal(class_4590 transform, class_1058 template, class_1058 sprite, float z, class_2350 facing, int color, int tint) {
        return ItemTextureQuadConverter.convertTextureHorizontal(transform, template, sprite, z, facing, color, tint, 0);
    }

    public static List<class_777> convertTextureHorizontal(class_4590 transform, class_1058 template, class_1058 sprite, float z, class_2350 facing, int color, int tint, int luminosity) {
        int w = template.method_4578();
        int h = template.method_4595();
        float wScale = 16.0f / (float)w;
        float hScale = 16.0f / (float)h;
        ArrayList quads = Lists.newArrayList();
        int startY = 0;
        for (int y = 1; y <= h; ++y) {
            int x;
            if (y < h) {
                boolean sameRow = true;
                for (x = 0; x < w; ++x) {
                    if (template.method_4583(0, x, y) == template.method_4583(0, x, startY)) continue;
                    sameRow = false;
                    break;
                }
                if (sameRow) continue;
            }
            int startX = -1;
            for (x = 0; x <= w; ++x) {
                if (x < w) {
                    boolean isVisible;
                    boolean bl = isVisible = !template.method_4583(0, x, startY);
                    if (startX < 0 && isVisible) {
                        startX = x;
                    }
                    if (isVisible) continue;
                }
                if (startX < 0) continue;
                quads.add(ItemTextureQuadConverter.genQuad(transform, (float)startX * wScale, (float)startY * hScale, (float)x * wScale, (float)y * hScale, z, sprite, facing, color, tint, luminosity));
                startX = -1;
            }
            startY = y;
        }
        return quads;
    }

    public static List<class_777> convertTextureVertical(class_4590 transform, class_1058 template, class_1058 sprite, float z, class_2350 facing, int color, int tint) {
        return ItemTextureQuadConverter.convertTextureVertical(transform, template, sprite, z, facing, color, tint, 0);
    }

    public static List<class_777> convertTextureVertical(class_4590 transform, class_1058 template, class_1058 sprite, float z, class_2350 facing, int color, int tint, int luminosity) {
        int w = template.method_4578();
        int h = template.method_4595();
        float wScale = 16.0f / (float)w;
        float hScale = 16.0f / (float)h;
        ArrayList quads = Lists.newArrayList();
        int startX = 0;
        for (int x = 1; x <= w; ++x) {
            int y;
            if (x < w) {
                boolean sameColumn = true;
                for (y = 0; y < h; ++y) {
                    if (template.method_4583(0, x, y) == template.method_4583(0, startX, y)) continue;
                    sameColumn = false;
                    break;
                }
                if (sameColumn) continue;
            }
            int startY = -1;
            for (y = 0; y <= h; ++y) {
                if (y < h) {
                    boolean isVisible;
                    boolean bl = isVisible = !template.method_4583(0, startX, y);
                    if (startY < 0 && isVisible) {
                        startY = y;
                    }
                    if (isVisible) continue;
                }
                if (startY < 0) continue;
                quads.add(ItemTextureQuadConverter.genQuad(transform, (float)startX * wScale, (float)startY * hScale, (float)x * wScale, (float)y * hScale, z, sprite, facing, color, tint, luminosity));
                startY = -1;
            }
            startX = x;
        }
        return quads;
    }

    private static boolean isVisible(int color) {
        return (float)(color >> 24 & 0xFF) / 255.0f > 0.1f;
    }

    public static class_777 genQuad(class_4590 transform, float x1, float y1, float x2, float y2, float z, class_1058 sprite, class_2350 facing, int color, int tint) {
        return ItemTextureQuadConverter.genQuad(transform, x1, y1, x2, y2, z, sprite, facing, color, tint, 0);
    }

    public static class_777 genQuad(class_4590 transform, float x1, float y1, float x2, float y2, float z, class_1058 sprite, class_2350 facing, int color, int tint, int luminosity) {
        float u1 = sprite.method_4580((double)x1);
        float v1 = sprite.method_4570((double)y1);
        float u2 = sprite.method_4580((double)x2);
        float v2 = sprite.method_4570((double)y2);
        float tmp = y1 /= 16.0f;
        y1 = 1.0f - (y2 /= 16.0f);
        y2 = 1.0f - tmp;
        return ItemTextureQuadConverter.putQuad(transform, facing, sprite, color, tint, x1 /= 16.0f, y1, x2 /= 16.0f, y2, z, u1, v1, u2, v2, luminosity);
    }

    private static class_777 putQuad(class_4590 transform, class_2350 side, class_1058 sprite, int color, int tint, float x1, float y1, float x2, float y2, float z, float u1, float v1, float u2, float v2, int luminosity) {
        IVertexConsumer consumer;
        BakedQuadBuilder builder = new BakedQuadBuilder(sprite);
        builder.setQuadTint(tint);
        builder.setQuadOrientation(side);
        builder.setApplyDiffuseLighting(luminosity == 0);
        boolean hasTransform = !transform.isIdentity();
        IVertexConsumer iVertexConsumer = consumer = hasTransform ? new TRSRTransformer(builder, transform) : builder;
        if (side == class_2350.field_11035) {
            ItemTextureQuadConverter.putVertex(consumer, side, x1, y1, z, u1, v2, color, luminosity);
            ItemTextureQuadConverter.putVertex(consumer, side, x2, y1, z, u2, v2, color, luminosity);
            ItemTextureQuadConverter.putVertex(consumer, side, x2, y2, z, u2, v1, color, luminosity);
            ItemTextureQuadConverter.putVertex(consumer, side, x1, y2, z, u1, v1, color, luminosity);
        } else {
            ItemTextureQuadConverter.putVertex(consumer, side, x1, y1, z, u1, v2, color, luminosity);
            ItemTextureQuadConverter.putVertex(consumer, side, x1, y2, z, u1, v1, color, luminosity);
            ItemTextureQuadConverter.putVertex(consumer, side, x2, y2, z, u2, v1, color, luminosity);
            ItemTextureQuadConverter.putVertex(consumer, side, x2, y1, z, u2, v2, color, luminosity);
        }
        return builder.build();
    }

    private static void putVertex(IVertexConsumer consumer, class_2350 side, float x, float y, float z, float u, float v, int color, int luminosity) {
        class_293 format = consumer.getVertexFormat();
        block6: for (int e = 0; e < format.method_1357().size(); ++e) {
            class_296 element = (class_296)format.method_1357().get(e);
            switch (element.method_1382()) {
                case field_1633: {
                    consumer.put(e, x, y, z, 1.0f);
                    continue block6;
                }
                case field_1632: {
                    float r = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(color >> 0 & 0xFF) / 255.0f;
                    float a = (float)(color >> 24 & 0xFF) / 255.0f;
                    consumer.put(e, r, g, b, a);
                    continue block6;
                }
                case field_1635: {
                    float offX = side.method_10148();
                    float offY = side.method_10164();
                    float offZ = side.method_10165();
                    consumer.put(e, offX, offY, offZ, 0.0f);
                    continue block6;
                }
                case field_1636: {
                    if (element.method_1385() == 0) {
                        consumer.put(e, u, v, 0.0f, 1.0f);
                        continue block6;
                    }
                    if (element.method_1385() == 2) {
                        consumer.put(e, (float)(luminosity << 4) / 32768.0f, (float)(luminosity << 4) / 32768.0f, 0.0f, 1.0f);
                        continue block6;
                    }
                }
                default: {
                    consumer.put(e, new float[0]);
                }
            }
        }
    }
}

