/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import io.github.fabricators_of_create.porting_lib.model.BakedQuadBuilder;
import io.github.fabricators_of_create.porting_lib.model.CompositeModelState;
import io.github.fabricators_of_create.porting_lib.model.IModelConfiguration;
import io.github.fabricators_of_create.porting_lib.model.IModelGeometry;
import io.github.fabricators_of_create.porting_lib.model.IModelLoader;
import io.github.fabricators_of_create.porting_lib.model.IVertexConsumer;
import io.github.fabricators_of_create.porting_lib.model.ItemMultiLayerBakedModel;
import io.github.fabricators_of_create.porting_lib.model.PerspectiveMapWrapper;
import io.github.fabricators_of_create.porting_lib.model.TRSRTransformer;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1100;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_293;
import net.minecraft.class_296;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3665;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import net.minecraft.class_777;
import net.minecraft.class_806;
import net.minecraft.class_809;

public final class ItemLayerModel
implements IModelGeometry<ItemLayerModel> {
    public static final ItemLayerModel INSTANCE = new ItemLayerModel((ImmutableList<class_4730>)ImmutableList.of());
    private static final class_2350[] HORIZONTALS = new class_2350[]{class_2350.field_11036, class_2350.field_11033};
    private static final class_2350[] VERTICALS = new class_2350[]{class_2350.field_11039, class_2350.field_11034};
    private ImmutableList<class_4730> textures;
    private final ImmutableSet<Integer> fullbrightLayers;

    public ItemLayerModel() {
        this(null, (ImmutableSet<Integer>)ImmutableSet.of());
    }

    public ItemLayerModel(ImmutableList<class_4730> textures) {
        this(textures, (ImmutableSet<Integer>)ImmutableSet.of());
    }

    public ItemLayerModel(@Nullable ImmutableList<class_4730> textures, ImmutableSet<Integer> fullbrightLayers) {
        this.textures = textures;
        this.fullbrightLayers = fullbrightLayers;
    }

    private static ImmutableList<class_4730> getTextures(IModelConfiguration model) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int i = 0;
        while (model.isTexturePresent("layer" + i)) {
            builder.add((Object)model.resolveTexture("layer" + i));
            ++i;
        }
        return builder.build();
    }

    @Override
    public class_1087 bake(IModelConfiguration owner, class_1088 bakery, Function<class_4730, class_1058> spriteGetter, class_3665 modelTransform, class_806 overrides, class_2960 modelLocation) {
        ImmutableMap<class_809.class_811, class_4590> transformMap = PerspectiveMapWrapper.getTransforms(new CompositeModelState(owner.getCombinedTransform(), modelTransform));
        class_4590 transform = modelTransform.method_3509();
        class_1058 particle = spriteGetter.apply(owner.isTexturePresent("particle") ? owner.resolveTexture("particle") : (class_4730)this.textures.get(0));
        ItemMultiLayerBakedModel.Builder builder = ItemMultiLayerBakedModel.builder(owner, particle, overrides, transformMap);
        for (int i = 0; i < this.textures.size(); ++i) {
            class_1058 tas = spriteGetter.apply((class_4730)this.textures.get(i));
            boolean fullbright = this.fullbrightLayers.contains((Object)i);
            class_1921 rt = ItemLayerModel.getLayerRenderType(fullbright);
            builder.addQuads(rt, (Collection<class_777>)ItemLayerModel.getQuadsForSprite(i, tas, transform, fullbright));
        }
        return builder.build();
    }

    public static class_1921 getLayerRenderType(boolean isFullbright) {
        return class_1921.method_23581();
    }

    public static ImmutableList<class_777> getQuadsForSprites(List<class_4730> textures, class_4590 transform, Function<class_4730, class_1058> spriteGetter) {
        return ItemLayerModel.getQuadsForSprites(textures, transform, spriteGetter, Collections.emptySet());
    }

    public static ImmutableList<class_777> getQuadsForSprites(List<class_4730> textures, class_4590 transform, Function<class_4730, class_1058> spriteGetter, Set<Integer> fullbrights) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < textures.size(); ++i) {
            class_1058 tas = spriteGetter.apply(textures.get(i));
            builder.addAll(ItemLayerModel.getQuadsForSprite(i, tas, transform, fullbrights.contains(i)));
        }
        return builder.build();
    }

    public static ImmutableList<class_777> getQuadsForSprite(int tint, class_1058 sprite, class_4590 transform) {
        return ItemLayerModel.getQuadsForSprite(tint, sprite, transform, false);
    }

    public static ImmutableList<class_777> getQuadsForSprite(int tint, class_1058 sprite, class_4590 transform, boolean fullbright) {
        int off;
        int off2;
        boolean face;
        boolean building;
        int u;
        ImmutableList.Builder builder = ImmutableList.builder();
        int uMax = sprite.method_4578();
        int vMax = sprite.method_4595();
        FaceData faceData = new FaceData(uMax, vMax);
        boolean translucent = false;
        for (int f = 0; f < sprite.method_4592(); ++f) {
            boolean[] ptv = new boolean[uMax];
            Arrays.fill(ptv, true);
            for (int v = 0; v < vMax; ++v) {
                boolean ptu = true;
                for (u = 0; u < uMax; ++u) {
                    boolean t;
                    int alpha = sprite.getPixelRGBA(f, u, vMax - v - 1) >> 24 & 0xFF;
                    boolean bl = t = (float)alpha / 255.0f <= 0.1f;
                    if (!t && alpha < 255) {
                        translucent = true;
                    }
                    if (ptu && !t) {
                        faceData.set(class_2350.field_11039, u, v);
                    }
                    if (!ptu && t) {
                        faceData.set(class_2350.field_11034, u - 1, v);
                    }
                    if (ptv[u] && !t) {
                        faceData.set(class_2350.field_11036, u, v);
                    }
                    if (!ptv[u] && t) {
                        faceData.set(class_2350.field_11033, u, v - 1);
                    }
                    ptu = t;
                    ptv[u] = t;
                }
                if (ptu) continue;
                faceData.set(class_2350.field_11034, uMax - 1, v);
            }
            for (int u2 = 0; u2 < uMax; ++u2) {
                if (ptv[u2]) continue;
                faceData.set(class_2350.field_11033, u2, vMax - 1);
            }
        }
        for (class_2350 facing : HORIZONTALS) {
            for (int v = 0; v < vMax; ++v) {
                int uStart = 0;
                int uEnd = uMax;
                building = false;
                for (int u3 = 0; u3 < uMax; ++u3) {
                    face = faceData.get(facing, u3, v);
                    if (!translucent) {
                        if (!face) continue;
                        if (!building) {
                            building = true;
                            uStart = u3;
                        }
                        uEnd = u3 + 1;
                        continue;
                    }
                    if (building && !face) {
                        off2 = facing == class_2350.field_11033 ? 1 : 0;
                        builder.add((Object)ItemLayerModel.buildSideQuad(transform, facing, tint, sprite, uStart, v + off2, u3 - uStart, fullbright));
                        building = false;
                        continue;
                    }
                    if (building || !face) continue;
                    building = true;
                    uStart = u3;
                }
                if (!building) continue;
                off = facing == class_2350.field_11033 ? 1 : 0;
                builder.add((Object)ItemLayerModel.buildSideQuad(transform, facing, tint, sprite, uStart, v + off, uEnd - uStart, fullbright));
            }
        }
        for (class_2350 facing : VERTICALS) {
            for (u = 0; u < uMax; ++u) {
                int vStart = 0;
                int vEnd = vMax;
                building = false;
                for (int v = 0; v < vMax; ++v) {
                    face = faceData.get(facing, u, v);
                    if (!translucent) {
                        if (!face) continue;
                        if (!building) {
                            building = true;
                            vStart = v;
                        }
                        vEnd = v + 1;
                        continue;
                    }
                    if (building && !face) {
                        off2 = facing == class_2350.field_11034 ? 1 : 0;
                        builder.add((Object)ItemLayerModel.buildSideQuad(transform, facing, tint, sprite, u + off2, vStart, v - vStart, fullbright));
                        building = false;
                        continue;
                    }
                    if (building || !face) continue;
                    building = true;
                    vStart = v;
                }
                if (!building) continue;
                off = facing == class_2350.field_11034 ? 1 : 0;
                builder.add((Object)ItemLayerModel.buildSideQuad(transform, facing, tint, sprite, u + off, vStart, vEnd - vStart, fullbright));
            }
        }
        builder.add((Object)ItemLayerModel.buildQuad(transform, class_2350.field_11043, sprite, tint, fullbright, 0.0f, 0.0f, 0.46875f, sprite.method_4594(), sprite.method_4575(), 0.0f, 1.0f, 0.46875f, sprite.method_4594(), sprite.method_4593(), 1.0f, 1.0f, 0.46875f, sprite.method_4577(), sprite.method_4593(), 1.0f, 0.0f, 0.46875f, sprite.method_4577(), sprite.method_4575()));
        builder.add((Object)ItemLayerModel.buildQuad(transform, class_2350.field_11035, sprite, tint, fullbright, 0.0f, 0.0f, 0.53125f, sprite.method_4594(), sprite.method_4575(), 1.0f, 0.0f, 0.53125f, sprite.method_4577(), sprite.method_4575(), 1.0f, 1.0f, 0.53125f, sprite.method_4577(), sprite.method_4593(), 0.0f, 1.0f, 0.53125f, sprite.method_4594(), sprite.method_4593()));
        return builder.build();
    }

    @Override
    public Collection<class_4730> getTextures(IModelConfiguration owner, Function<class_2960, class_1100> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        this.textures = ItemLayerModel.getTextures(owner);
        return this.textures;
    }

    private static class_777 buildSideQuad(class_4590 transform, class_2350 side, int tint, class_1058 sprite, int u, int v, int size, boolean fullbright) {
        float eps = 0.01f;
        int width = sprite.method_4578();
        int height = sprite.method_4595();
        float x0 = (float)u / (float)width;
        float y0 = (float)v / (float)height;
        float x1 = x0;
        float y1 = y0;
        float z0 = 0.46875f;
        float z1 = 0.53125f;
        switch (side) {
            case field_11039: {
                z0 = 0.53125f;
                z1 = 0.46875f;
            }
            case field_11034: {
                y1 = (float)(v + size) / (float)height;
                break;
            }
            case field_11033: {
                z0 = 0.53125f;
                z1 = 0.46875f;
            }
            case field_11036: {
                x1 = (float)(u + size) / (float)width;
                break;
            }
            default: {
                throw new IllegalArgumentException("can't handle z-oriented side");
            }
        }
        float dx = (float)side.method_10163().method_10263() * 0.01f / (float)width;
        float dy = (float)side.method_10163().method_10264() * 0.01f / (float)height;
        float u0 = 16.0f * (x0 - dx);
        float u1 = 16.0f * (x1 - dx);
        float v0 = 16.0f * (1.0f - y0 - dy);
        float v1 = 16.0f * (1.0f - y1 - dy);
        return ItemLayerModel.buildQuad(transform, ItemLayerModel.remap(side), sprite, tint, fullbright, x0, y0, z0, sprite.method_4580((double)u0), sprite.method_4570((double)v0), x1, y1, z0, sprite.method_4580((double)u1), sprite.method_4570((double)v1), x1, y1, z1, sprite.method_4580((double)u1), sprite.method_4570((double)v1), x0, y0, z1, sprite.method_4580((double)u0), sprite.method_4570((double)v0));
    }

    private static class_2350 remap(class_2350 side) {
        return side.method_10166() == class_2350.class_2351.field_11052 ? side.method_10153() : side;
    }

    private static class_777 buildQuad(class_4590 transform, class_2350 side, class_1058 sprite, int tint, boolean fullbright, float x0, float y0, float z0, float u0, float v0, float x1, float y1, float z1, float u1, float v1, float x2, float y2, float z2, float u2, float v2, float x3, float y3, float z3, float u3, float v3) {
        BakedQuadBuilder builder = new BakedQuadBuilder(sprite);
        builder.setQuadTint(tint);
        builder.setQuadOrientation(side);
        builder.setApplyDiffuseLighting(false);
        boolean hasTransform = !transform.isIdentity();
        IVertexConsumer consumer = hasTransform ? new TRSRTransformer(builder, transform) : builder;
        int vLight = fullbright ? 15 : 0;
        int uLight = vLight;
        ItemLayerModel.putVertex(consumer, side, x0, y0, z0, u0, v0, uLight, vLight);
        ItemLayerModel.putVertex(consumer, side, x1, y1, z1, u1, v1, uLight, vLight);
        ItemLayerModel.putVertex(consumer, side, x2, y2, z2, u2, v2, uLight, vLight);
        ItemLayerModel.putVertex(consumer, side, x3, y3, z3, u3, v3, uLight, vLight);
        return builder.build();
    }

    private static void putVertex(IVertexConsumer consumer, class_2350 side, float x, float y, float z, float u, float v, int uLight, int vLight) {
        class_293 format = consumer.getVertexFormat();
        block10: for (int e = 0; e < format.method_1357().size(); ++e) {
            class_296 element = (class_296)format.method_1357().get(e);
            switch (element.method_1382()) {
                case field_1633: {
                    consumer.put(e, x, y, z, 1.0f);
                    continue block10;
                }
                case field_1632: {
                    consumer.put(e, 1.0f, 1.0f, 1.0f, 1.0f);
                    continue block10;
                }
                case field_1635: {
                    float offX = side.method_10148();
                    float offY = side.method_10164();
                    float offZ = side.method_10165();
                    consumer.put(e, offX, offY, offZ, 0.0f);
                    continue block10;
                }
                case field_1636: {
                    switch (element.method_1385()) {
                        case 0: {
                            consumer.put(e, u, v, 0.0f, 1.0f);
                            continue block10;
                        }
                        case 2: {
                            consumer.put(e, (float)(uLight << 4) / 32768.0f, (float)(vLight << 4) / 32768.0f, 0.0f, 1.0f);
                            continue block10;
                        }
                    }
                }
                default: {
                    consumer.put(e, new float[0]);
                }
            }
        }
    }

    private static class FaceData {
        private final EnumMap<class_2350, BitSet> data = new EnumMap(class_2350.class);
        private final int vMax;

        FaceData(int uMax, int vMax) {
            this.vMax = vMax;
            this.data.put(class_2350.field_11039, new BitSet(uMax * vMax));
            this.data.put(class_2350.field_11034, new BitSet(uMax * vMax));
            this.data.put(class_2350.field_11036, new BitSet(uMax * vMax));
            this.data.put(class_2350.field_11033, new BitSet(uMax * vMax));
        }

        public void set(class_2350 facing, int u, int v) {
            this.data.get(facing).set(this.getIndex(u, v));
        }

        public boolean get(class_2350 facing, int u, int v) {
            return this.data.get(facing).get(this.getIndex(u, v));
        }

        private int getIndex(int u, int v) {
            return v * this.vMax + u;
        }
    }

    public static class Loader
    implements IModelLoader<ItemLayerModel> {
        public static final Loader INSTANCE = new Loader();

        public void method_14491(class_3300 resourceManager) {
        }

        @Override
        public ItemLayerModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            ImmutableSet.Builder fullbrightLayers = ImmutableSet.builder();
            if (modelContents.has("fullbright_layers")) {
                JsonArray arr = class_3518.method_15261((JsonObject)modelContents, (String)"fullbright_layers");
                for (int i = 0; i < arr.size(); ++i) {
                    fullbrightLayers.add((Object)arr.get(i).getAsInt());
                }
            }
            return new ItemLayerModel(null, (ImmutableSet<Integer>)fullbrightLayers.build());
        }
    }
}

