/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import io.github.fabricators_of_create.porting_lib.model.CompositeModelState;
import io.github.fabricators_of_create.porting_lib.model.IModelConfiguration;
import io.github.fabricators_of_create.porting_lib.model.IModelGeometry;
import io.github.fabricators_of_create.porting_lib.model.IModelLoader;
import io.github.fabricators_of_create.porting_lib.model.ItemLayerModel;
import io.github.fabricators_of_create.porting_lib.model.ItemMultiLayerBakedModel;
import io.github.fabricators_of_create.porting_lib.model.ItemTextureQuadConverter;
import io.github.fabricators_of_create.porting_lib.model.PerspectiveMapWrapper;
import io.github.fabricators_of_create.porting_lib.model.SimpleModelState;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1086;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1100;
import net.minecraft.class_1158;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3665;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import net.minecraft.class_638;
import net.minecraft.class_777;
import net.minecraft.class_806;
import net.minecraft.class_809;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class DynamicBucketModel
implements IModelGeometry<DynamicBucketModel> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final float NORTH_Z_COVER = 0.4685f;
    private static final float SOUTH_Z_COVER = 0.5315f;
    private static final float NORTH_Z_FLUID = 0.468625f;
    private static final float SOUTH_Z_FLUID = 0.531375f;
    @Nonnull
    private final class_3611 fluid;
    private final boolean flipGas;
    private final boolean tint;
    private final boolean coverIsMask;
    private final boolean applyFluidLuminosity;

    @Deprecated
    public DynamicBucketModel(class_3611 fluid, boolean flipGas, boolean tint, boolean coverIsMask) {
        this(fluid, flipGas, tint, coverIsMask, true);
    }

    public DynamicBucketModel(class_3611 fluid, boolean flipGas, boolean tint, boolean coverIsMask, boolean applyFluidLuminosity) {
        this.fluid = fluid;
        this.flipGas = flipGas;
        this.tint = tint;
        this.coverIsMask = coverIsMask;
        this.applyFluidLuminosity = applyFluidLuminosity;
    }

    public DynamicBucketModel withFluid(class_3611 newFluid) {
        return new DynamicBucketModel(newFluid, this.flipGas, this.tint, this.coverIsMask, this.applyFluidLuminosity);
    }

    @Override
    public class_1087 bake(IModelConfiguration owner, class_1088 bakery, Function<class_4730, class_1058> spriteGetter, class_3665 modelTransform, class_806 overrides, class_2960 modelLocation) {
        class_1058 templateSprite;
        class_1058 particleSprite;
        class_4730 particleLocation = owner.isTexturePresent("particle") ? owner.resolveTexture("particle") : null;
        class_4730 baseLocation = owner.isTexturePresent("base") ? owner.resolveTexture("base") : null;
        class_4730 fluidMaskLocation = owner.isTexturePresent("fluid") ? owner.resolveTexture("fluid") : null;
        class_4730 coverLocation = owner.isTexturePresent("cover") ? owner.resolveTexture("cover") : null;
        class_3665 transformsFromModel = owner.getCombinedTransform();
        class_1058 fluidSprite = this.fluid != class_3612.field_15906 ? spriteGetter.apply(new class_4730(class_1059.field_5275, this.fluid.getAttributes().getStillTexture())) : null;
        class_1058 coverSprite = coverLocation != null && (!this.coverIsMask || baseLocation != null) ? spriteGetter.apply(coverLocation) : null;
        ImmutableMap<class_809.class_811, class_4590> transformMap = PerspectiveMapWrapper.getTransforms(new CompositeModelState(transformsFromModel, modelTransform));
        class_1058 class_10582 = particleSprite = particleLocation != null ? spriteGetter.apply(particleLocation) : null;
        if (particleSprite == null) {
            particleSprite = fluidSprite;
        }
        if (particleSprite == null && !this.coverIsMask) {
            particleSprite = coverSprite;
        }
        if (this.flipGas && this.fluid != class_3612.field_15906 && this.fluid.getAttributes().isLighterThanAir()) {
            modelTransform = new SimpleModelState(modelTransform.method_3509().blockCornerToCenter().method_22933(new class_4590(null, new class_1158(0.0f, 0.0f, 1.0f, 0.0f), null, null).blockCenterToCorner()));
        }
        class_4590 transform = modelTransform.method_3509();
        ItemMultiLayerBakedModel.Builder builder = ItemMultiLayerBakedModel.builder(owner, particleSprite, new ContainedFluidOverrideHandler(overrides, bakery, owner, this), transformMap);
        if (baseLocation != null) {
            builder.addQuads(ItemLayerModel.getLayerRenderType(false), (Collection<class_777>)ItemLayerModel.getQuadsForSprites((List<class_4730>)ImmutableList.of((Object)baseLocation), transform, spriteGetter));
        }
        if (fluidMaskLocation != null && fluidSprite != null && (templateSprite = spriteGetter.apply(fluidMaskLocation)) != null) {
            int luminosity = this.applyFluidLuminosity ? this.fluid.getAttributes().getLuminosity() : 0;
            int color = this.tint ? this.fluid.getAttributes().getColor() : -1;
            builder.addQuads(ItemLayerModel.getLayerRenderType(luminosity > 0), ItemTextureQuadConverter.convertTexture(transform, templateSprite, fluidSprite, 0.468625f, class_2350.field_11043, color, 1, luminosity));
            builder.addQuads(ItemLayerModel.getLayerRenderType(luminosity > 0), ItemTextureQuadConverter.convertTexture(transform, templateSprite, fluidSprite, 0.531375f, class_2350.field_11035, color, 1, luminosity));
        }
        if (this.coverIsMask) {
            if (coverSprite != null && baseLocation != null) {
                class_1058 baseSprite = spriteGetter.apply(baseLocation);
                builder.addQuads(ItemLayerModel.getLayerRenderType(false), ItemTextureQuadConverter.convertTexture(transform, coverSprite, baseSprite, 0.4685f, class_2350.field_11043, -1, 2));
                builder.addQuads(ItemLayerModel.getLayerRenderType(false), ItemTextureQuadConverter.convertTexture(transform, coverSprite, baseSprite, 0.5315f, class_2350.field_11035, -1, 2));
            }
        } else if (coverSprite != null) {
            builder.addQuads(ItemLayerModel.getLayerRenderType(false), ItemTextureQuadConverter.genQuad(transform, 0.0f, 0.0f, 16.0f, 16.0f, 0.4685f, coverSprite, class_2350.field_11043, -1, 2));
            builder.addQuads(ItemLayerModel.getLayerRenderType(false), ItemTextureQuadConverter.genQuad(transform, 0.0f, 0.0f, 16.0f, 16.0f, 0.5315f, coverSprite, class_2350.field_11035, -1, 2));
        }
        builder.setParticle(particleSprite);
        return builder.build();
    }

    @Override
    public Collection<class_4730> getTextures(IModelConfiguration owner, Function<class_2960, class_1100> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet texs = Sets.newHashSet();
        if (owner.isTexturePresent("particle")) {
            texs.add(owner.resolveTexture("particle"));
        }
        if (owner.isTexturePresent("base")) {
            texs.add(owner.resolveTexture("base"));
        }
        if (owner.isTexturePresent("fluid")) {
            texs.add(owner.resolveTexture("fluid"));
        }
        if (owner.isTexturePresent("cover")) {
            texs.add(owner.resolveTexture("cover"));
        }
        return texs;
    }

    private static final class ContainedFluidOverrideHandler
    extends class_806 {
        private final Map<String, class_1087> cache = Maps.newHashMap();
        private final class_806 nested;
        private final class_1088 bakery;
        private final IModelConfiguration owner;
        private final DynamicBucketModel parent;

        private ContainedFluidOverrideHandler(class_806 nested, class_1088 bakery, IModelConfiguration owner, DynamicBucketModel parent) {
            this.nested = nested;
            this.bakery = bakery;
            this.owner = owner;
            this.parent = parent;
        }

        public class_1087 method_3495(class_1087 originalModel, class_1799 stack, @Nullable class_638 world, @Nullable class_1309 entity, int seed) {
            class_1087 overriden = this.nested.method_3495(originalModel, stack, world, entity, seed);
            if (overriden != originalModel) {
                return overriden;
            }
            return TransferUtil.getFluidContained(stack).map(fluidStack -> {
                class_3611 fluid = fluidStack.getFluid();
                String name = fluid.getRegistryName().toString();
                if (!this.cache.containsKey(name)) {
                    DynamicBucketModel unbaked = this.parent.withFluid(fluid);
                    class_1087 bakedModel = unbaked.bake(this.owner, this.bakery, class_4730::method_24148, (class_3665)class_1086.field_5350, this, new class_2960("forge:bucket_override"));
                    this.cache.put(name, bakedModel);
                    return bakedModel;
                }
                return this.cache.get(name);
            }).orElse(originalModel);
        }
    }

    public static enum Loader implements IModelLoader<DynamicBucketModel>
    {
        INSTANCE;


        public void method_14491(class_3300 resourceManager) {
        }

        @Override
        public DynamicBucketModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            if (!modelContents.has("fluid")) {
                throw new RuntimeException("Bucket model requires 'fluid' value.");
            }
            class_2960 fluidName = new class_2960(modelContents.get("fluid").getAsString());
            class_3611 fluid = (class_3611)class_2378.field_11154.method_10223(fluidName);
            boolean flip = false;
            if (modelContents.has("flipGas")) {
                flip = modelContents.get("flipGas").getAsBoolean();
            }
            boolean tint = true;
            if (modelContents.has("applyTint")) {
                tint = modelContents.get("applyTint").getAsBoolean();
            }
            boolean coverIsMask = true;
            if (modelContents.has("coverIsMask")) {
                coverIsMask = modelContents.get("coverIsMask").getAsBoolean();
            }
            boolean applyFluidLuminosity = true;
            if (modelContents.has("applyFluidLuminosity")) {
                applyFluidLuminosity = modelContents.get("applyFluidLuminosity").getAsBoolean();
            }
            return new DynamicBucketModel(fluid, flip, tint, coverIsMask, applyFluidLuminosity);
        }
    }
}

