/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.model;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import io.github.fabricators_of_create.porting_lib.model.CompositeModelState;
import io.github.fabricators_of_create.porting_lib.model.CustomDataBlockView;
import io.github.fabricators_of_create.porting_lib.model.EmptyModelData;
import io.github.fabricators_of_create.porting_lib.model.IModelBuilder;
import io.github.fabricators_of_create.porting_lib.model.IModelConfiguration;
import io.github.fabricators_of_create.porting_lib.model.IModelData;
import io.github.fabricators_of_create.porting_lib.model.IModelGeometryPart;
import io.github.fabricators_of_create.porting_lib.model.IModelLoader;
import io.github.fabricators_of_create.porting_lib.model.IMultipartModelGeometry;
import io.github.fabricators_of_create.porting_lib.model.ModelDataMap;
import io.github.fabricators_of_create.porting_lib.model.ModelProperty;
import io.github.fabricators_of_create.porting_lib.model.PerspectiveMapWrapper;
import io.github.fabricators_of_create.porting_lib.model.SimpleModelState;
import io.github.fabricators_of_create.porting_lib.render.TransformTypeDependentItemBakedModel;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachedBlockView;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1100;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3665;
import net.minecraft.class_4587;
import net.minecraft.class_4730;
import net.minecraft.class_777;
import net.minecraft.class_793;
import net.minecraft.class_806;
import net.minecraft.class_809;

public class CompositeModel
implements class_1087,
FabricBakedModel,
TransformTypeDependentItemBakedModel {
    private final ImmutableMap<String, class_1087> bakedParts;
    private final boolean isAmbientOcclusion;
    private final boolean isGui3d;
    private final boolean isSideLit;
    private final class_1058 particle;
    private final class_806 overrides;
    private final class_3665 transforms;

    public CompositeModel(boolean isGui3d, boolean isSideLit, boolean isAmbientOcclusion, class_1058 particle, ImmutableMap<String, class_1087> bakedParts, class_3665 combinedTransform, class_806 overrides) {
        this.bakedParts = bakedParts;
        this.isAmbientOcclusion = isAmbientOcclusion;
        this.isGui3d = isGui3d;
        this.isSideLit = isSideLit;
        this.particle = particle;
        this.overrides = overrides;
        this.transforms = combinedTransform;
    }

    public List<class_777> method_4707(@Nullable class_2680 state, @Nullable class_2350 side, Random rand) {
        return List.of();
    }

    public boolean method_4708() {
        return this.isAmbientOcclusion;
    }

    public boolean method_4712() {
        return this.isGui3d;
    }

    public boolean method_24304() {
        return this.isSideLit;
    }

    public boolean method_4713() {
        return false;
    }

    public class_1058 method_4711() {
        return this.particle;
    }

    public class_809 method_4709() {
        return class_809.field_4301;
    }

    public class_806 method_4710() {
        return this.overrides;
    }

    @Override
    public class_1087 handlePerspective(class_809.class_811 cameraTransformType, class_4587 poseStack) {
        return PerspectiveMapWrapper.handlePerspective((class_1087)this, this.transforms, cameraTransformType, poseStack);
    }

    @Nullable
    public class_1087 getPart(String name) {
        return (class_1087)this.bakedParts.get((Object)name);
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<Random> randomSupplier, RenderContext context) {
        if (blockView instanceof RenderAttachedBlockView) {
            RenderAttachedBlockView renderAttachedBlockView = (RenderAttachedBlockView)blockView;
            for (Map.Entry entry : this.bakedParts.entrySet()) {
                ((FabricBakedModel)entry.getValue()).emitBlockQuads((class_1920)new CustomDataBlockView(renderAttachedBlockView, CompositeModelData.get((IModelData)renderAttachedBlockView.getBlockEntityRenderAttachment(pos), (String)entry.getKey())), state, pos, randomSupplier, context);
            }
        }
    }

    public void emitItemQuads(class_1799 stack, Supplier<Random> randomSupplier, RenderContext context) {
        for (Map.Entry entry : this.bakedParts.entrySet()) {
            ((FabricBakedModel)entry.getValue()).emitItemQuads(stack, randomSupplier, context);
        }
    }

    public static class CompositeModelData
    extends ModelDataMap {
        public static final ModelProperty<CompositeModelData> SUBMODEL_DATA = new ModelProperty();
        private final Map<String, IModelData> parts = new HashMap<String, IModelData>();

        public static Optional<CompositeModelData> get(IModelData modelData) {
            return Optional.ofNullable(modelData.getData(SUBMODEL_DATA));
        }

        public static IModelData get(IModelData modelData, String name) {
            return CompositeModelData.get(modelData).map(data -> data.getSubmodelData(name)).orElse(EmptyModelData.INSTANCE);
        }

        public IModelData getSubmodelData(String name) {
            if (this.parts.containsKey(name)) {
                return this.parts.get(name);
            }
            return EmptyModelData.INSTANCE;
        }

        public void putSubmodelData(String name, IModelData data) {
            this.parts.put(name, data);
        }

        @Override
        public boolean hasProperty(ModelProperty<?> prop) {
            return prop == SUBMODEL_DATA || super.hasProperty(prop);
        }

        @Override
        @Nullable
        public <T> T getData(ModelProperty<T> prop) {
            if (prop == SUBMODEL_DATA) {
                return (T)this;
            }
            return super.getData(prop);
        }

        @Override
        @Nullable
        public <T> T setData(ModelProperty<T> prop, T data) {
            if (prop == SUBMODEL_DATA) {
                return (T)this;
            }
            return super.setData(prop, data);
        }
    }

    private static class ModelDataWrapper
    extends ModelDataMap {
        private final IModelData parent;

        public static IModelData wrap(IModelData parent) {
            return new ModelDataWrapper(parent);
        }

        private ModelDataWrapper(IModelData parent) {
            this.parent = parent;
        }

        @Override
        public boolean hasProperty(ModelProperty<?> prop) {
            return super.hasProperty(prop) || this.parent.hasProperty(prop);
        }

        @Override
        @Nullable
        public <T> T getData(ModelProperty<T> prop) {
            return super.hasProperty(prop) ? super.getData(prop) : this.parent.getData(prop);
        }

        @Override
        @Nullable
        public <T> T setData(ModelProperty<T> prop, T data) {
            return super.setData(prop, data);
        }
    }

    public static class Loader
    implements IModelLoader<Geometry> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        public void method_14491(class_3300 resourceManager) {
        }

        @Override
        public Geometry read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            if (!modelContents.has("parts")) {
                throw new RuntimeException("Composite model requires a \"parts\" element.");
            }
            ImmutableMap.Builder parts = ImmutableMap.builder();
            for (Map.Entry part : modelContents.get("parts").getAsJsonObject().entrySet()) {
                SimpleModelState modelTransform = SimpleModelState.IDENTITY;
                parts.put((Object)((String)part.getKey()), (Object)new Submodel((String)part.getKey(), (class_793)deserializationContext.deserialize((JsonElement)part.getValue(), class_793.class), modelTransform));
            }
            return new Geometry((ImmutableMap<String, Submodel>)parts.build());
        }
    }

    public static class Geometry
    implements IMultipartModelGeometry<Geometry> {
        private final ImmutableMap<String, Submodel> parts;

        Geometry(ImmutableMap<String, Submodel> parts) {
            this.parts = parts;
        }

        @Override
        public Collection<? extends IModelGeometryPart> getParts() {
            return this.parts.values();
        }

        @Override
        public Optional<? extends IModelGeometryPart> getPart(String name) {
            return Optional.ofNullable((Submodel)this.parts.get((Object)name));
        }

        @Override
        public class_1087 bake(IModelConfiguration owner, class_1088 bakery, Function<class_4730, class_1058> spriteGetter, class_3665 modelTransform, class_806 overrides, class_2960 modelLocation) {
            class_4730 particleLocation = owner.resolveTexture("particle");
            class_1058 particle = spriteGetter.apply(particleLocation);
            ImmutableMap.Builder bakedParts = ImmutableMap.builder();
            for (Map.Entry part : this.parts.entrySet()) {
                Submodel submodel = (Submodel)part.getValue();
                if (!owner.getPartVisibility(submodel)) continue;
                bakedParts.put((Object)((String)part.getKey()), (Object)submodel.bakeModel(bakery, spriteGetter, modelTransform, modelLocation));
            }
            return new CompositeModel(owner.isShadedInGui(), owner.isSideLit(), owner.useSmoothLighting(), particle, (ImmutableMap<String, class_1087>)bakedParts.build(), owner.getCombinedTransform(), overrides);
        }

        @Override
        public Collection<class_4730> getTextures(IModelConfiguration owner, Function<class_2960, class_1100> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            HashSet<class_4730> textures = new HashSet<class_4730>();
            for (Submodel part : this.parts.values()) {
                textures.addAll(part.getTextures(owner, modelGetter, missingTextureErrors));
            }
            return textures;
        }
    }

    private static class Submodel
    implements IModelGeometryPart {
        private final String name;
        private final class_793 model;
        private final class_3665 modelTransform;

        private Submodel(String name, class_793 model, class_3665 modelTransform) {
            this.name = name;
            this.model = model;
            this.modelTransform = modelTransform;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public void addQuads(IModelConfiguration owner, IModelBuilder<?> modelBuilder, class_1088 bakery, Function<class_4730, class_1058> spriteGetter, class_3665 modelTransform, class_2960 modelLocation) {
            throw new UnsupportedOperationException("Attempted to call adQuads on a Submodel instance. Please don't.");
        }

        public class_1087 bakeModel(class_1088 bakery, Function<class_4730, class_1058> spriteGetter, class_3665 modelTransform, class_2960 modelLocation) {
            return this.model.method_4753(bakery, spriteGetter, (class_3665)new CompositeModelState(this.modelTransform, modelTransform, this.modelTransform.method_3512() || modelTransform.method_3512()), modelLocation);
        }

        @Override
        public Collection<class_4730> getTextures(IModelConfiguration owner, Function<class_2960, class_1100> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            return this.model.method_4754(modelGetter, missingTextureErrors);
        }
    }
}

