/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.mixin.common;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import io.github.fabricators_of_create.porting_lib.PortingLib;
import io.github.fabricators_of_create.porting_lib.block.LightEmissiveBlock;
import io.github.fabricators_of_create.porting_lib.block.NeighborChangeListeningBlock;
import io.github.fabricators_of_create.porting_lib.block.WeakPowerCheckingBlock;
import io.github.fabricators_of_create.porting_lib.entity.PartEntity;
import io.github.fabricators_of_create.porting_lib.event.common.ExplosionEvents;
import io.github.fabricators_of_create.porting_lib.extensions.BlockEntityExtensions;
import io.github.fabricators_of_create.porting_lib.extensions.LevelExtensions;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_3695;
import net.minecraft.class_4538;
import net.minecraft.class_5362;
import net.minecraft.class_5575;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_1937.class}, priority=1100)
public abstract class LevelMixin
implements class_1936,
LevelExtensions {
    @Unique
    private List<LevelExtensions.ChangedPosData> port_lib$modifiedStates = null;
    @Unique
    private final ArrayList<class_2586> port_lib$freshBlockEntities = new ArrayList();
    @Unique
    private final ArrayList<class_2586> port_lib$pendingFreshBlockEntities = new ArrayList();
    @Unique
    private final SnapshotParticipant<LevelExtensions.LevelSnapshotData> port_lib$snapshotParticipant = new SnapshotParticipant<LevelExtensions.LevelSnapshotData>(){

        protected LevelExtensions.LevelSnapshotData createSnapshot() {
            LevelExtensions.LevelSnapshotData data = new LevelExtensions.LevelSnapshotData(LevelMixin.this.port_lib$modifiedStates);
            if (LevelMixin.this.port_lib$modifiedStates == null) {
                LevelMixin.this.port_lib$modifiedStates = new LinkedList<LevelExtensions.ChangedPosData>();
            }
            return data;
        }

        protected void readSnapshot(LevelExtensions.LevelSnapshotData snapshot) {
            LevelMixin.this.port_lib$modifiedStates = snapshot.changedStates();
        }

        protected void onFinalCommit() {
            super.onFinalCommit();
            List<LevelExtensions.ChangedPosData> modifications = LevelMixin.this.port_lib$modifiedStates;
            LevelMixin.this.port_lib$modifiedStates = null;
            for (LevelExtensions.ChangedPosData data : modifications) {
                LevelMixin.this.method_8652(data.pos(), data.state(), data.flags());
            }
        }
    };
    @Unique
    final Int2ObjectMap<PartEntity<?>> port_lib$multiparts = new Int2ObjectOpenHashMap();
    @Shadow
    private boolean field_9249;

    @Shadow
    public abstract class_2680 method_8320(class_2338 var1);

    @Shadow
    public abstract class_3695 method_16107();

    @Shadow
    public abstract int method_8488(class_2338 var1);

    @Override
    public SnapshotParticipant<LevelExtensions.LevelSnapshotData> snapshotParticipant() {
        return this.port_lib$snapshotParticipant;
    }

    @Inject(method={"getBlockState"}, at={@At(value="INVOKE", shift=At.Shift.BEFORE, target="Lnet/minecraft/world/level/Level;getChunk(II)Lnet/minecraft/world/level/chunk/LevelChunk;")}, cancellable=true)
    private void port_lib$getBlockState(class_2338 pos, CallbackInfoReturnable<class_2680> cir) {
        if (this.port_lib$modifiedStates != null) {
            for (LevelExtensions.ChangedPosData data : this.port_lib$modifiedStates) {
                if (!data.pos().equals((Object)pos)) continue;
                class_2680 state = data.state();
                if (state == null) {
                    PortingLib.LOGGER.error("null blockstate stored in snapshots at " + pos);
                    new Throwable().printStackTrace();
                } else {
                    cir.setReturnValue((Object)state);
                }
                return;
            }
        }
    }

    @Inject(method={"setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;II)Z"}, at={@At(value="INVOKE", shift=At.Shift.BEFORE, target="Lnet/minecraft/world/level/Level;getChunkAt(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/chunk/LevelChunk;")}, cancellable=true)
    private void port_lib$setBlock(class_2338 pos, class_2680 state, int flags, int recursionLeft, CallbackInfoReturnable<Boolean> cir) {
        if (state == null) {
            PortingLib.LOGGER.error("Setting null blockstate at " + pos);
            new Throwable().printStackTrace();
        }
        if (this.port_lib$modifiedStates != null) {
            this.port_lib$modifiedStates.add(new LevelExtensions.ChangedPosData(pos, state, flags));
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;II)Z"}, at={@At(value="JUMP", opcode=165)}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void port_lib$lightBlock(class_2338 pos, class_2680 state, int flags, int recursionLeft, CallbackInfoReturnable<Boolean> cir, class_2818 levelChunk, class_2248 block, class_2680 blockstate, class_2680 blockstate1) {
        block5: {
            block6: {
                int n;
                class_2680 old = this.method_8320(pos);
                class_2248 class_22482 = old.method_26204();
                if (!(class_22482 instanceof LightEmissiveBlock)) break block5;
                LightEmissiveBlock lightEmissiveBlock = (LightEmissiveBlock)class_22482;
                int oldLight = lightEmissiveBlock.getLightEmission(old, (class_1922)this, pos);
                int oldOpacity = old.method_26193((class_1922)this, pos);
                if (blockstate1 == blockstate) break block5;
                if (blockstate1.method_26193((class_1922)this, pos) != oldOpacity) break block6;
                class_2248 class_22483 = blockstate1.method_26204();
                if (class_22483 instanceof LightEmissiveBlock) {
                    LightEmissiveBlock lm = (LightEmissiveBlock)class_22483;
                    n = lm.getLightEmission(blockstate1, (class_1922)this, pos);
                } else {
                    n = blockstate1.method_26213();
                }
                if (n == oldLight && !blockstate1.method_26211() && !blockstate.method_26211()) break block5;
            }
            this.method_16107().method_15396("queueCheckLight");
            this.method_8398().method_12130().method_15513(pos);
            this.method_16107().method_15407();
        }
    }

    @ModifyExpressionValue(method={"getSignal"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;isRedstoneConductor(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)Z")})
    public boolean port_lib$getRedstoneSignal(boolean conductor, class_2338 pos, class_2350 facing) {
        WeakPowerCheckingBlock checking;
        if (conductor) {
            return true;
        }
        class_2680 state = this.method_8320(pos);
        class_2248 class_22482 = state.method_26204();
        return class_22482 instanceof WeakPowerCheckingBlock && (checking = (WeakPowerCheckingBlock)class_22482).shouldCheckWeakPower(state, (class_4538)this, pos, facing);
    }

    @Inject(method={"updateNeighbourForOutputSignal"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getBlockState(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;", shift=At.Shift.BY, by=2, ordinal=0)}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void port_lib$updateNeighbourForOutputSignal(class_2338 pos, class_2248 block, CallbackInfo ci, Iterator<?> var3, class_2350 direction, class_2338 offset, class_2680 state) {
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof NeighborChangeListeningBlock) {
            NeighborChangeListeningBlock listener = (NeighborChangeListeningBlock)class_22482;
            listener.onNeighborChange(state, (class_4538)this, offset, pos);
        }
    }

    @Inject(method={"explode(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/damagesource/DamageSource;Lnet/minecraft/world/level/ExplosionDamageCalculator;DDDFZLnet/minecraft/world/level/Explosion$BlockInteraction;)Lnet/minecraft/world/level/Explosion;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Explosion;explode()V", shift=At.Shift.BEFORE)}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void port_lib$onStartExplosion(@Nullable class_1297 exploder, @Nullable class_1282 damageSource, @Nullable class_5362 context, double x, double y, double z, float size, boolean causesFire, class_1927.class_4179 mode, CallbackInfoReturnable<class_1927> cir, class_1927 explosion) {
        if (((ExplosionEvents.Start)ExplosionEvents.START.invoker()).onExplosionStart((class_1937)this, explosion)) {
            cir.setReturnValue((Object)explosion);
        }
    }

    @Inject(method={"getEntities(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;)Ljava/util/List;"}, at={@At(value="TAIL")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void port_lib$appendPartEntitiesPredicate(@Nullable class_1297 entity, class_238 area, Predicate<? super class_1297> predicate, CallbackInfoReturnable<List<class_1297>> cir, List<class_1297> list) {
        for (PartEntity p : this.getPartEntities()) {
            if (p == entity || !p.method_5829().method_994(area) || !predicate.test(p)) continue;
            list.add(p);
        }
    }

    @Inject(method={"getEntities(Lnet/minecraft/world/level/entity/EntityTypeTest;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;)Ljava/util/List;"}, at={@At(value="TAIL")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private <T extends class_1297> void port_lib$appendPartEntitiesTypeTest(class_5575<class_1297, T> test, class_238 area, Predicate<? super T> predicate, CallbackInfoReturnable<List<T>> cir, List<class_1297> list) {
        for (PartEntity p : this.getPartEntities()) {
            class_1297 t = (class_1297)test.method_31796((Object)p);
            if (t == null || !t.method_5829().method_994(area) || !predicate.test(t)) continue;
            list.add(t);
        }
    }

    @Inject(method={"tickBlockEntities"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/profiling/ProfilerFiller;push(Ljava/lang/String;)V", shift=At.Shift.AFTER)})
    public void port_lib$pendingBlockEntities(CallbackInfo ci) {
        if (!this.port_lib$pendingFreshBlockEntities.isEmpty()) {
            this.port_lib$freshBlockEntities.addAll(this.port_lib$pendingFreshBlockEntities);
            this.port_lib$pendingFreshBlockEntities.clear();
        }
    }

    @Inject(method={"tickBlockEntities"}, at={@At(value="INVOKE", target="Ljava/util/List;isEmpty()Z")})
    public void port_lib$onBlockEntitiesLoad(CallbackInfo ci) {
        if (!this.port_lib$freshBlockEntities.isEmpty()) {
            this.port_lib$freshBlockEntities.forEach(BlockEntityExtensions::onLoad);
            this.port_lib$freshBlockEntities.clear();
        }
    }

    @Override
    @Unique
    public void addFreshBlockEntities(Collection<class_2586> beList) {
        if (this.field_9249) {
            this.port_lib$pendingFreshBlockEntities.addAll(beList);
        } else {
            this.port_lib$freshBlockEntities.addAll(beList);
        }
    }

    @Override
    public Int2ObjectMap<PartEntity<?>> getPartEntityMap() {
        return this.port_lib$multiparts;
    }
}

