/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.loot;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.fabricators_of_create.porting_lib.PortingLib;
import io.github.fabricators_of_create.porting_lib.loot.GlobalLootModifierSerializer;
import io.github.fabricators_of_create.porting_lib.loot.IGlobalLootModifier;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.fabricmc.fabric.api.event.registry.FabricRegistryBuilder;
import net.minecraft.class_2370;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5270;
import net.minecraft.class_5341;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootModifierManager
extends class_4309 {
    public static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON_INSTANCE = class_5270.method_27861().create();
    private static final String folder = "loot_modifiers";
    public static class_2370<GlobalLootModifierSerializer> SERIALIZER = (class_2370)FabricRegistryBuilder.createSimple(GlobalLootModifierSerializer.class, (class_2960)PortingLib.id("loot_modifier")).buildAndRegister();
    private Map<class_2960, IGlobalLootModifier> registeredLootModifiers = ImmutableMap.of();

    public LootModifierManager() {
        super(GSON_INSTANCE, folder);
    }

    public static GlobalLootModifierSerializer<?> getSerializerForName(class_2960 resourcelocation) {
        return (GlobalLootModifierSerializer)SERIALIZER.method_10223(resourcelocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void apply(Map<class_2960, JsonElement> resourceList, class_3300 resourceManagerIn, class_3695 profilerIn) {
        ImmutableMap immutablemap;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ArrayList<class_2960> finalLocations = new ArrayList<class_2960>();
        class_2960 resourcelocation = new class_2960("assets/forge", "loot_modifiers/global_loot_modifiers.json");
        try {
            for (class_3298 iresource : resourceManagerIn.method_14489(resourcelocation)) {
                try {
                    InputStream inputstream = iresource.method_14482();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));){
                        JsonObject jsonobject = (JsonObject)class_3518.method_15276((Gson)GSON_INSTANCE, (Reader)reader, JsonObject.class);
                        boolean replace = jsonobject.get("replace").getAsBoolean();
                        if (replace) {
                            finalLocations.clear();
                        }
                        JsonArray entryList = jsonobject.get("entries").getAsJsonArray();
                        for (JsonElement entry : entryList) {
                            String loc = entry.getAsString();
                            class_2960 res = new class_2960(loc);
                            finalLocations.remove(res);
                            finalLocations.add(res);
                        }
                    }
                    finally {
                        if (inputstream == null) continue;
                        inputstream.close();
                    }
                }
                catch (IOException | RuntimeException ioexception) {
                    LOGGER.error("Couldn't read global loot modifier list {} in data pack {}", (Object)resourcelocation, (Object)iresource.method_14480(), (Object)ioexception);
                }
                finally {
                    IOUtils.closeQuietly((Closeable)iresource);
                }
            }
        }
        catch (IOException ioexception1) {
            LOGGER.error("Couldn't read global loot modifier list from {}", (Object)resourcelocation, (Object)ioexception1);
        }
        finalLocations.forEach(location -> {
            try {
                IGlobalLootModifier modifier = this.deserializeModifier((class_2960)location, (JsonElement)resourceList.get(location));
                if (modifier != null) {
                    builder.put(location, (Object)modifier);
                }
            }
            catch (Exception exception) {
                LOGGER.error("Couldn't parse loot modifier {}", location, (Object)exception);
            }
        });
        this.registeredLootModifiers = immutablemap = builder.build();
    }

    private IGlobalLootModifier deserializeModifier(class_2960 location, JsonElement element) {
        if (!element.isJsonObject()) {
            return null;
        }
        JsonObject object = element.getAsJsonObject();
        class_5341[] lootConditions = (class_5341[])GSON_INSTANCE.fromJson(object.get("conditions"), class_5341[].class);
        class_2960 serializer = location;
        if (object.has("type")) {
            serializer = new class_2960(class_3518.method_15265((JsonObject)object, (String)"type"));
        }
        return ((GlobalLootModifierSerializer)SERIALIZER.method_10223(serializer)).read(location, object, lootConditions);
    }

    public Collection<IGlobalLootModifier> getAllLootMods() {
        return this.registeredLootModifiers.values();
    }
}

