/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.event.common;

import io.github.fabricators_of_create.porting_lib.event.common.EntityEvent;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1917;
import net.minecraft.class_1936;
import net.minecraft.class_3730;

public class LivingEntityEvents {
    public static final Event<ExperienceDrop> EXPERIENCE_DROP = EventFactory.createArrayBacked(ExperienceDrop.class, callbacks -> (i, player) -> {
        int n = 0;
        ExperienceDrop[] experienceDropArray = callbacks;
        int n2 = experienceDropArray.length;
        if (n < n2) {
            ExperienceDrop callback = experienceDropArray[n];
            return callback.onLivingEntityExperienceDrop(i, player);
        }
        return i;
    });
    public static final Event<KnockBackStrength> KNOCKBACK_STRENGTH = EventFactory.createArrayBacked(KnockBackStrength.class, callbacks -> (strength, player) -> {
        int n = 0;
        KnockBackStrength[] knockBackStrengthArray = callbacks;
        int n2 = knockBackStrengthArray.length;
        if (n < n2) {
            KnockBackStrength callback = knockBackStrengthArray[n];
            return callback.onLivingEntityTakeKnockback(strength, player);
        }
        return strength;
    });
    public static final Event<Drops> DROPS = EventFactory.createArrayBacked(Drops.class, callbacks -> (target, source, drops) -> {
        for (Drops callback : callbacks) {
            if (!callback.onLivingEntityDrops(target, source, drops)) continue;
            return true;
        }
        return false;
    });
    public static final Event<Fall> FALL = EventFactory.createArrayBacked(Fall.class, callbacks -> info -> {
        for (Fall e : callbacks) {
            e.onFall(info);
            if (!info.isCanceled()) continue;
            return;
        }
    });
    public static final Event<LootingLevel> LOOTING_LEVEL = EventFactory.createArrayBacked(LootingLevel.class, callbacks -> (source, target, level, recent) -> {
        for (LootingLevel callback : callbacks) {
            int lootingLevel = callback.modifyLootingLevel(source, target, level, recent);
            if (lootingLevel == level) continue;
            return lootingLevel;
        }
        return level;
    });
    public static final Event<Tick> TICK = EventFactory.createArrayBacked(Tick.class, callbacks -> entity -> {
        for (Tick callback : callbacks) {
            callback.onLivingEntityTick(entity);
        }
    });
    public static final Event<Hurt> HURT = EventFactory.createArrayBacked(Hurt.class, callbacks -> (source, amount) -> {
        for (Hurt callback : callbacks) {
            float newAmount = callback.onHurt(source, amount);
            if (newAmount == amount) continue;
            return newAmount;
        }
        return amount;
    });
    public static final Event<ActuallyHurt> ACTUALLY_HURT = EventFactory.createArrayBacked(ActuallyHurt.class, callbacks -> (source, damaged, amount) -> {
        for (ActuallyHurt callback : callbacks) {
            float newAmount = callback.onHurt(source, damaged, amount);
            if (newAmount == amount) continue;
            return newAmount;
        }
        return amount;
    });
    public static final Event<CheckSpawn> CHECK_SPAWN = EventFactory.createArrayBacked(CheckSpawn.class, callbacks -> (entity, world, x, y, z, spawner, spawnReason) -> {
        for (CheckSpawn callback : callbacks) {
            if (callback.onCheckSpawn(entity, world, x, y, z, spawner, spawnReason)) continue;
            return true;
        }
        return false;
    });
    public static final Event<Jump> JUMP = EventFactory.createArrayBacked(Jump.class, callbacks -> entity -> {
        for (Jump callback : callbacks) {
            callback.onLivingEntityJump(entity);
        }
    });
    public static final Event<Attack> ATTACK = EventFactory.createArrayBacked(Attack.class, callbacks -> (entity, source, amount) -> {
        for (Attack callback : callbacks) {
            if (!callback.onAttack(entity, source, amount)) continue;
            return true;
        }
        return false;
    });
    public static final Event<EquipmentChange> EQUIPMENT_CHANGE = EventFactory.createArrayBacked(EquipmentChange.class, callbacks -> (entity, slot, from, to) -> {
        for (EquipmentChange callback : callbacks) {
            callback.onEquipmentChange(entity, slot, from, to);
        }
    });

    @FunctionalInterface
    public static interface EquipmentChange {
        public void onEquipmentChange(class_1309 var1, class_1304 var2, @Nonnull class_1799 var3, @Nonnull class_1799 var4);
    }

    @FunctionalInterface
    public static interface Attack {
        public boolean onAttack(class_1309 var1, class_1282 var2, float var3);
    }

    @FunctionalInterface
    public static interface Jump {
        public void onLivingEntityJump(class_1309 var1);
    }

    @FunctionalInterface
    public static interface CheckSpawn {
        public boolean onCheckSpawn(class_1308 var1, class_1936 var2, double var3, double var5, double var7, @Nullable class_1917 var9, class_3730 var10);
    }

    @FunctionalInterface
    public static interface ActuallyHurt {
        public float onHurt(class_1282 var1, class_1309 var2, float var3);
    }

    @FunctionalInterface
    public static interface Hurt {
        public float onHurt(class_1282 var1, float var2);
    }

    @FunctionalInterface
    public static interface Tick {
        public void onLivingEntityTick(class_1309 var1);
    }

    @FunctionalInterface
    public static interface LootingLevel {
        public int modifyLootingLevel(class_1282 var1, class_1309 var2, int var3, boolean var4);
    }

    @FunctionalInterface
    public static interface Fall {
        public void onFall(FallEvent var1);

        public static final class FallEvent
        extends EntityEvent {
            private final class_1282 source;
            private float distance;
            private float damageMultiplier;

            public FallEvent(class_1309 entity, class_1282 source, float distance, float damageMultiplier) {
                super((class_1297)entity);
                this.source = source;
                this.distance = distance;
                this.damageMultiplier = damageMultiplier;
            }

            @Override
            public void sendEvent() {
                ((Fall)FALL.invoker()).onFall(this);
            }

            public class_1282 getSource() {
                return this.source;
            }

            public float getDistance() {
                return this.distance;
            }

            public float getDamageMultiplier() {
                return this.damageMultiplier;
            }

            public void setDamageMultiplier(float damageMultiplier) {
                this.damageMultiplier = damageMultiplier;
            }

            public void setDistance(float distance) {
                this.distance = distance;
            }
        }
    }

    @FunctionalInterface
    public static interface Drops {
        public boolean onLivingEntityDrops(class_1309 var1, class_1282 var2, Collection<class_1542> var3);
    }

    @FunctionalInterface
    public static interface KnockBackStrength {
        public double onLivingEntityTakeKnockback(double var1, class_1657 var3);
    }

    @FunctionalInterface
    public static interface ExperienceDrop {
        public int onLivingEntityExperienceDrop(int var1, class_1657 var2);
    }
}

