/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.event.common;

import io.github.fabricators_of_create.porting_lib.block.CustomExpBlock;
import io.github.fabricators_of_create.porting_lib.event.BaseEvent;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_4538;

public abstract class BlockEvents
extends BaseEvent {
    public static final Event<BlockBreak> BLOCK_BREAK = EventFactory.createArrayBacked(BlockBreak.class, callbacks -> event -> {
        for (BlockBreak e : callbacks) {
            e.onBlockBreak(event);
        }
    });
    public static final Event<LeftClickBlock> LEFT_CLICK_BLOCK = EventFactory.createArrayBacked(LeftClickBlock.class, callbacks -> (player, pos, face) -> {
        for (LeftClickBlock e : callbacks) {
            e.onLeftClickBlock(player, pos, face);
        }
    });
    private final class_1936 world;
    private final class_2338 pos;
    private final class_2680 state;

    public BlockEvents(class_1936 world, class_2338 pos, class_2680 state) {
        this.pos = pos;
        this.world = world;
        this.state = state;
    }

    public class_1936 getWorld() {
        return this.world;
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public class_2680 getState() {
        return this.state;
    }

    public static interface LeftClickBlock {
        public void onLeftClickBlock(class_1657 var1, class_2338 var2, class_2350 var3);
    }

    public static interface BlockBreak {
        public void onBlockBreak(BreakEvent var1);
    }

    public static class BreakEvent
    extends BlockEvents {
        private final class_1657 player;
        private int exp;

        public BreakEvent(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
            super((class_1936)world, pos, state);
            this.player = player;
            if (state == null || !player.method_7305(state)) {
                this.exp = 0;
            } else {
                int n;
                int bonusLevel = class_1890.method_8225((class_1887)class_1893.field_9130, (class_1799)player.method_6047());
                int silklevel = class_1890.method_8225((class_1887)class_1893.field_9099, (class_1799)player.method_6047());
                class_2248 class_22482 = state.method_26204();
                if (class_22482 instanceof CustomExpBlock) {
                    CustomExpBlock exp = (CustomExpBlock)class_22482;
                    n = exp.getExpDrop(state, (class_4538)world, pos, bonusLevel, silklevel);
                } else {
                    n = 0;
                }
                this.exp = n;
            }
        }

        public class_1657 getPlayer() {
            return this.player;
        }

        public int getExpToDrop() {
            return this.isCanceled() ? 0 : this.exp;
        }

        public void setExpToDrop(int exp) {
            this.exp = exp;
        }

        @Override
        public void sendEvent() {
            ((BlockBreak)BLOCK_BREAK.invoker()).onBlockBreak(this);
        }
    }
}

