/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.fabricators_of_create.porting_lib.crafting.DifferenceIngredient;
import io.github.fabricators_of_create.porting_lib.crafting.IntersectionIngredient;
import io.github.fabricators_of_create.porting_lib.crafting.NBTIngredient;
import io.github.tropheusj.serialization_hooks.ingredient.CombinedIngredient;
import io.github.tropheusj.serialization_hooks.ingredient.IngredientDeserializer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLootTableProvider;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class CraftingHelper {
    public static void init() {
        CraftingHelper.register(new class_2960("forge", "compound"), (IngredientDeserializer)new CombinedIngredient.Deserializer());
        CraftingHelper.register(NBTIngredient.Serializer.ID, NBTIngredient.Serializer.INSTANCE);
        CraftingHelper.register(DifferenceIngredient.Serializer.ID, DifferenceIngredient.Serializer.INSTANCE);
        CraftingHelper.register(IntersectionIngredient.Serializer.ID, IntersectionIngredient.Serializer.INSTANCE);
    }

    public static IngredientDeserializer register(class_2960 key, IngredientDeserializer serializer) {
        return (IngredientDeserializer)class_2378.method_10230((class_2378)IngredientDeserializer.REGISTRY, (class_2960)key, (Object)serializer);
    }

    @Nullable
    public static class_2960 getID(IngredientDeserializer serializer) {
        return IngredientDeserializer.REGISTRY.method_10221((Object)serializer);
    }

    public static class_1799 getItemStack(JsonObject json, boolean readNBT) {
        return CraftingHelper.getItemStack(json, readNBT, false);
    }

    public static class_1792 getItem(String itemName, boolean disallowsAirInRecipe) {
        class_1792 item = CraftingHelper.tryGetItem(itemName, disallowsAirInRecipe);
        if (item == null) {
            if (!class_2378.field_11142.method_10250(new class_2960(itemName))) {
                throw new JsonSyntaxException("Unknown item '" + itemName + "'");
            }
            if (disallowsAirInRecipe && item == class_1802.field_8162) {
                throw new JsonSyntaxException("Invalid item: " + itemName);
            }
        }
        return Objects.requireNonNull(item);
    }

    @Nullable
    public static class_1792 tryGetItem(String itemName, boolean disallowsAirInRecipe) {
        class_2960 itemKey = new class_2960(itemName);
        if (!class_2378.field_11142.method_10250(itemKey)) {
            return null;
        }
        class_1792 item = (class_1792)class_2378.field_11142.method_10223(itemKey);
        if (disallowsAirInRecipe && item == class_1802.field_8162) {
            return null;
        }
        return item;
    }

    public static class_2487 getNBT(JsonElement element) {
        try {
            if (element.isJsonObject()) {
                return class_2522.method_10718((String)FabricLootTableProvider.GSON.toJson(element));
            }
            return class_2522.method_10718((String)class_3518.method_15287((JsonElement)element, (String)"nbt"));
        }
        catch (CommandSyntaxException e) {
            throw new JsonSyntaxException("Invalid NBT Entry: " + e);
        }
    }

    @Nullable
    public static class_2487 tryGetNBT(JsonElement element) {
        try {
            if (element.isJsonObject()) {
                return class_2522.method_10718((String)FabricLootTableProvider.GSON.toJson(element));
            }
            return class_2522.method_10718((String)class_3518.method_15287((JsonElement)element, (String)"nbt"));
        }
        catch (CommandSyntaxException e) {
            return null;
        }
    }

    public static class_1799 getItemStack(JsonObject json, boolean readNBT, boolean disallowsAirInRecipe) {
        String itemName = class_3518.method_15265((JsonObject)json, (String)"item");
        class_1792 item = CraftingHelper.getItem(itemName, disallowsAirInRecipe);
        if (readNBT && json.has("nbt")) {
            class_2487 nbt = CraftingHelper.getNBT(json.get("nbt"));
            class_2487 tmp = new class_2487();
            if (nbt.method_10545("ForgeCaps")) {
                tmp.method_10566("ForgeCaps", nbt.method_10580("ForgeCaps"));
                nbt.method_10551("ForgeCaps");
            }
            tmp.method_10566("tag", (class_2520)nbt);
            tmp.method_10582("id", itemName);
            tmp.method_10569("Count", class_3518.method_15282((JsonObject)json, (String)"count", (int)1));
            return class_1799.method_7915((class_2487)tmp);
        }
        return new class_1799((class_1935)item, class_3518.method_15282((JsonObject)json, (String)"count", (int)1));
    }

    @Nullable
    public static class_1799 tryGetItemStack(JsonObject json, boolean readNBT, boolean disallowsAirInRecipe) {
        JsonElement nameElement = json.get("name");
        if (nameElement == null || !nameElement.isJsonPrimitive()) {
            return null;
        }
        String itemName = nameElement.getAsString();
        class_1792 item = CraftingHelper.tryGetItem(itemName, disallowsAirInRecipe);
        if (readNBT && json.has("nbt")) {
            class_2487 nbt = CraftingHelper.tryGetNBT(json.get("nbt"));
            if (nbt == null) {
                return null;
            }
            class_2487 tmp = new class_2487();
            if (nbt.method_10545("ForgeCaps")) {
                tmp.method_10566("ForgeCaps", nbt.method_10580("ForgeCaps"));
                nbt.method_10551("ForgeCaps");
            }
            tmp.method_10566("tag", (class_2520)nbt);
            tmp.method_10582("id", itemName);
            tmp.method_10569("Count", class_3518.method_15282((JsonObject)json, (String)"count", (int)1));
            return class_1799.method_7915((class_2487)tmp);
        }
        return new class_1799((class_1935)item, class_3518.method_15282((JsonObject)json, (String)"count", (int)1));
    }

    public static class_1856 merge(Collection<class_1856> parts) {
        return class_1856.method_8092(parts.stream().flatMap(i -> Arrays.stream(i.field_9019)));
    }

    public static boolean areShareTagsEqual(class_1799 stack, class_1799 other) {
        class_2487 shareTagA = stack.method_7969();
        class_2487 shareTagB = other.method_7969();
        if (shareTagA == null) {
            return shareTagB == null;
        }
        return shareTagB != null && shareTagA.equals((Object)shareTagB);
    }

    public static Predicate<JsonObject> getConditionPredicate(JsonObject json) {
        return ResourceConditions.get((class_2960)new class_2960(class_3518.method_15265((JsonObject)json, (String)"condition")));
    }

    public static boolean processConditions(JsonArray conditions) {
        for (int x = 0; x < conditions.size(); ++x) {
            if (!conditions.get(x).isJsonObject()) {
                throw new JsonSyntaxException("Conditions must be an array of JsonObjects");
            }
            JsonObject json = conditions.get(x).getAsJsonObject();
            if (CraftingHelper.getConditionPredicate(json).test(json)) continue;
            return false;
        }
        return true;
    }
}

